/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.Protocol;
import software.amazon.awssdk.services.mediaconnect.model.UpdateEncryption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFlowSourceRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, UpdateFlowSourceRequest> {
    private static final SdkField<UpdateEncryption> DECRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::decryption)).setter(UpdateFlowSourceRequest.setter(Builder::decryption)).constructor(UpdateEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryption").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::description)).setter(UpdateFlowSourceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::entitlementArn)).setter(UpdateFlowSourceRequest.setter(Builder::entitlementArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementArn").build()}).build();
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::flowArn)).setter(UpdateFlowSourceRequest.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()}).build();
    private static final SdkField<Integer> INGEST_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::ingestPort)).setter(UpdateFlowSourceRequest.setter(Builder::ingestPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestPort").build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::maxBitrate)).setter(UpdateFlowSourceRequest.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<Integer> MAX_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::maxLatency)).setter(UpdateFlowSourceRequest.setter(Builder::maxLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLatency").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::protocolAsString)).setter(UpdateFlowSourceRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::sourceArn)).setter(UpdateFlowSourceRequest.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sourceArn").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::streamId)).setter(UpdateFlowSourceRequest.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final SdkField<String> WHITELIST_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::whitelistCidr)).setter(UpdateFlowSourceRequest.setter(Builder::whitelistCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitelistCidr").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECRYPTION_FIELD, DESCRIPTION_FIELD, ENTITLEMENT_ARN_FIELD, FLOW_ARN_FIELD, INGEST_PORT_FIELD, MAX_BITRATE_FIELD, MAX_LATENCY_FIELD, PROTOCOL_FIELD, SOURCE_ARN_FIELD, STREAM_ID_FIELD, WHITELIST_CIDR_FIELD));
    private final UpdateEncryption decryption;
    private final String description;
    private final String entitlementArn;
    private final String flowArn;
    private final Integer ingestPort;
    private final Integer maxBitrate;
    private final Integer maxLatency;
    private final String protocol;
    private final String sourceArn;
    private final String streamId;
    private final String whitelistCidr;

    private UpdateFlowSourceRequest(BuilderImpl builder) {
        super(builder);
        this.decryption = builder.decryption;
        this.description = builder.description;
        this.entitlementArn = builder.entitlementArn;
        this.flowArn = builder.flowArn;
        this.ingestPort = builder.ingestPort;
        this.maxBitrate = builder.maxBitrate;
        this.maxLatency = builder.maxLatency;
        this.protocol = builder.protocol;
        this.sourceArn = builder.sourceArn;
        this.streamId = builder.streamId;
        this.whitelistCidr = builder.whitelistCidr;
    }

    public UpdateEncryption decryption() {
        return this.decryption;
    }

    public String description() {
        return this.description;
    }

    public String entitlementArn() {
        return this.entitlementArn;
    }

    public String flowArn() {
        return this.flowArn;
    }

    public Integer ingestPort() {
        return this.ingestPort;
    }

    public Integer maxBitrate() {
        return this.maxBitrate;
    }

    public Integer maxLatency() {
        return this.maxLatency;
    }

    public Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public String streamId() {
        return this.streamId;
    }

    public String whitelistCidr() {
        return this.whitelistCidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.decryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.whitelistCidr());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowSourceRequest)) {
            return false;
        }
        UpdateFlowSourceRequest other = (UpdateFlowSourceRequest)((Object)obj);
        return Objects.equals(this.decryption(), other.decryption()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.entitlementArn(), other.entitlementArn()) && Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.ingestPort(), other.ingestPort()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.maxLatency(), other.maxLatency()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.whitelistCidr(), other.whitelistCidr());
    }

    public String toString() {
        return ToString.builder((String)"UpdateFlowSourceRequest").add("Decryption", (Object)this.decryption()).add("Description", (Object)this.description()).add("EntitlementArn", (Object)this.entitlementArn()).add("FlowArn", (Object)this.flowArn()).add("IngestPort", (Object)this.ingestPort()).add("MaxBitrate", (Object)this.maxBitrate()).add("MaxLatency", (Object)this.maxLatency()).add("Protocol", (Object)this.protocolAsString()).add("SourceArn", (Object)this.sourceArn()).add("StreamId", (Object)this.streamId()).add("WhitelistCidr", (Object)this.whitelistCidr()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Decryption": {
                return Optional.ofNullable(clazz.cast(this.decryption()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EntitlementArn": {
                return Optional.ofNullable(clazz.cast(this.entitlementArn()));
            }
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "IngestPort": {
                return Optional.ofNullable(clazz.cast(this.ingestPort()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "MaxLatency": {
                return Optional.ofNullable(clazz.cast(this.maxLatency()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "StreamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "WhitelistCidr": {
                return Optional.ofNullable(clazz.cast(this.whitelistCidr()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowSourceRequest, T> g) {
        return obj -> g.apply((UpdateFlowSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private UpdateEncryption decryption;
        private String description;
        private String entitlementArn;
        private String flowArn;
        private Integer ingestPort;
        private Integer maxBitrate;
        private Integer maxLatency;
        private String protocol;
        private String sourceArn;
        private String streamId;
        private String whitelistCidr;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowSourceRequest model) {
            super(model);
            this.decryption(model.decryption);
            this.description(model.description);
            this.entitlementArn(model.entitlementArn);
            this.flowArn(model.flowArn);
            this.ingestPort(model.ingestPort);
            this.maxBitrate(model.maxBitrate);
            this.maxLatency(model.maxLatency);
            this.protocol(model.protocol);
            this.sourceArn(model.sourceArn);
            this.streamId(model.streamId);
            this.whitelistCidr(model.whitelistCidr);
        }

        public final UpdateEncryption.Builder getDecryption() {
            return this.decryption != null ? this.decryption.toBuilder() : null;
        }

        @Override
        public final Builder decryption(UpdateEncryption decryption) {
            this.decryption = decryption;
            return this;
        }

        public final void setDecryption(UpdateEncryption.BuilderImpl decryption) {
            this.decryption = decryption != null ? decryption.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEntitlementArn() {
            return this.entitlementArn;
        }

        @Override
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        public final Integer getIngestPort() {
            return this.ingestPort;
        }

        @Override
        public final Builder ingestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
            return this;
        }

        public final void setIngestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getMaxLatency() {
            return this.maxLatency;
        }

        @Override
        public final Builder maxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public final void setMaxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
        }

        public final String getProtocolAsString() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final String getWhitelistCidr() {
            return this.whitelistCidr;
        }

        @Override
        public final Builder whitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
            return this;
        }

        public final void setWhitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowSourceRequest build() {
            return new UpdateFlowSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFlowSourceRequest> {
        public Builder decryption(UpdateEncryption var1);

        default public Builder decryption(Consumer<UpdateEncryption.Builder> decryption) {
            return this.decryption((UpdateEncryption)((UpdateEncryption.Builder)UpdateEncryption.builder().applyMutation(decryption)).build());
        }

        public Builder description(String var1);

        public Builder entitlementArn(String var1);

        public Builder flowArn(String var1);

        public Builder ingestPort(Integer var1);

        public Builder maxBitrate(Integer var1);

        public Builder maxLatency(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder sourceArn(String var1);

        public Builder streamId(String var1);

        public Builder whitelistCidr(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

