/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.mediaconnect.MediaConnectAsyncClient;
import software.amazon.awssdk.services.mediaconnect.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.waiters.MediaConnectAsyncWaiter;
import software.amazon.awssdk.services.mediaconnect.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultMediaConnectAsyncWaiter
implements MediaConnectAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final MediaConnectAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeFlowResponse> flowActiveWaiter;
    private final AsyncWaiter<DescribeFlowResponse> flowDeletedWaiter;
    private final AsyncWaiter<DescribeFlowResponse> flowStandbyWaiter;
    private final AsyncWaiter<GetRouterInputResponse> inputActiveWaiter;
    private final AsyncWaiter<GetRouterInputResponse> inputDeletedWaiter;
    private final AsyncWaiter<GetRouterInputResponse> inputStandbyWaiter;
    private final AsyncWaiter<GetRouterOutputResponse> outputActiveWaiter;
    private final AsyncWaiter<GetRouterOutputResponse> outputDeletedWaiter;
    private final AsyncWaiter<GetRouterOutputResponse> outputRoutedWaiter;
    private final AsyncWaiter<GetRouterOutputResponse> outputStandbyWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultMediaConnectAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (MediaConnectAsyncClient)MediaConnectAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.flowActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeFlowResponse.class).acceptors(DefaultMediaConnectAsyncWaiter.flowActiveWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectAsyncWaiter.flowActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.flowDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeFlowResponse.class).acceptors(DefaultMediaConnectAsyncWaiter.flowDeletedWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectAsyncWaiter.flowDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.flowStandbyWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeFlowResponse.class).acceptors(DefaultMediaConnectAsyncWaiter.flowStandbyWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectAsyncWaiter.flowStandbyWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.inputActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetRouterInputResponse.class).acceptors(DefaultMediaConnectAsyncWaiter.inputActiveWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectAsyncWaiter.inputActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.inputDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetRouterInputResponse.class).acceptors(DefaultMediaConnectAsyncWaiter.inputDeletedWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectAsyncWaiter.inputDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.inputStandbyWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetRouterInputResponse.class).acceptors(DefaultMediaConnectAsyncWaiter.inputStandbyWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectAsyncWaiter.inputStandbyWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.outputActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetRouterOutputResponse.class).acceptors(DefaultMediaConnectAsyncWaiter.outputActiveWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectAsyncWaiter.outputActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.outputDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetRouterOutputResponse.class).acceptors(DefaultMediaConnectAsyncWaiter.outputDeletedWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectAsyncWaiter.outputDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.outputRoutedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetRouterOutputResponse.class).acceptors(DefaultMediaConnectAsyncWaiter.outputRoutedWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectAsyncWaiter.outputRoutedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.outputStandbyWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetRouterOutputResponse.class).acceptors(DefaultMediaConnectAsyncWaiter.outputStandbyWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectAsyncWaiter.outputStandbyWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFlowResponse>> waitUntilFlowActive(DescribeFlowRequest describeFlowRequest) {
        return this.flowActiveWaiter.runAsync(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFlowResponse>> waitUntilFlowActive(DescribeFlowRequest describeFlowRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.flowActiveWaiter.runAsync(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)), DefaultMediaConnectAsyncWaiter.flowActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFlowResponse>> waitUntilFlowDeleted(DescribeFlowRequest describeFlowRequest) {
        return this.flowDeletedWaiter.runAsync(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFlowResponse>> waitUntilFlowDeleted(DescribeFlowRequest describeFlowRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.flowDeletedWaiter.runAsync(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)), DefaultMediaConnectAsyncWaiter.flowDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFlowResponse>> waitUntilFlowStandby(DescribeFlowRequest describeFlowRequest) {
        return this.flowStandbyWaiter.runAsync(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFlowResponse>> waitUntilFlowStandby(DescribeFlowRequest describeFlowRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.flowStandbyWaiter.runAsync(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)), DefaultMediaConnectAsyncWaiter.flowStandbyWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRouterInputResponse>> waitUntilInputActive(GetRouterInputRequest getRouterInputRequest) {
        return this.inputActiveWaiter.runAsync(() -> this.client.getRouterInput(this.applyWaitersUserAgent(getRouterInputRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRouterInputResponse>> waitUntilInputActive(GetRouterInputRequest getRouterInputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.inputActiveWaiter.runAsync(() -> this.client.getRouterInput(this.applyWaitersUserAgent(getRouterInputRequest)), DefaultMediaConnectAsyncWaiter.inputActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRouterInputResponse>> waitUntilInputDeleted(GetRouterInputRequest getRouterInputRequest) {
        return this.inputDeletedWaiter.runAsync(() -> this.client.getRouterInput(this.applyWaitersUserAgent(getRouterInputRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRouterInputResponse>> waitUntilInputDeleted(GetRouterInputRequest getRouterInputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.inputDeletedWaiter.runAsync(() -> this.client.getRouterInput(this.applyWaitersUserAgent(getRouterInputRequest)), DefaultMediaConnectAsyncWaiter.inputDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRouterInputResponse>> waitUntilInputStandby(GetRouterInputRequest getRouterInputRequest) {
        return this.inputStandbyWaiter.runAsync(() -> this.client.getRouterInput(this.applyWaitersUserAgent(getRouterInputRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRouterInputResponse>> waitUntilInputStandby(GetRouterInputRequest getRouterInputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.inputStandbyWaiter.runAsync(() -> this.client.getRouterInput(this.applyWaitersUserAgent(getRouterInputRequest)), DefaultMediaConnectAsyncWaiter.inputStandbyWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRouterOutputResponse>> waitUntilOutputActive(GetRouterOutputRequest getRouterOutputRequest) {
        return this.outputActiveWaiter.runAsync(() -> this.client.getRouterOutput(this.applyWaitersUserAgent(getRouterOutputRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRouterOutputResponse>> waitUntilOutputActive(GetRouterOutputRequest getRouterOutputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.outputActiveWaiter.runAsync(() -> this.client.getRouterOutput(this.applyWaitersUserAgent(getRouterOutputRequest)), DefaultMediaConnectAsyncWaiter.outputActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRouterOutputResponse>> waitUntilOutputDeleted(GetRouterOutputRequest getRouterOutputRequest) {
        return this.outputDeletedWaiter.runAsync(() -> this.client.getRouterOutput(this.applyWaitersUserAgent(getRouterOutputRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRouterOutputResponse>> waitUntilOutputDeleted(GetRouterOutputRequest getRouterOutputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.outputDeletedWaiter.runAsync(() -> this.client.getRouterOutput(this.applyWaitersUserAgent(getRouterOutputRequest)), DefaultMediaConnectAsyncWaiter.outputDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRouterOutputResponse>> waitUntilOutputRouted(GetRouterOutputRequest getRouterOutputRequest) {
        return this.outputRoutedWaiter.runAsync(() -> this.client.getRouterOutput(this.applyWaitersUserAgent(getRouterOutputRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRouterOutputResponse>> waitUntilOutputRouted(GetRouterOutputRequest getRouterOutputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.outputRoutedWaiter.runAsync(() -> this.client.getRouterOutput(this.applyWaitersUserAgent(getRouterOutputRequest)), DefaultMediaConnectAsyncWaiter.outputRoutedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRouterOutputResponse>> waitUntilOutputStandby(GetRouterOutputRequest getRouterOutputRequest) {
        return this.outputStandbyWaiter.runAsync(() -> this.client.getRouterOutput(this.applyWaitersUserAgent(getRouterOutputRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRouterOutputResponse>> waitUntilOutputStandby(GetRouterOutputRequest getRouterOutputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.outputStandbyWaiter.runAsync(() -> this.client.getRouterOutput(this.applyWaitersUserAgent(getRouterOutputRequest)), DefaultMediaConnectAsyncWaiter.outputStandbyWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeFlowResponse>> flowActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFlowResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFlowResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "STANDBY");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Flow.Status=STANDBY) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Flow.Status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeFlowResponse>> flowDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFlowResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFlowResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "NotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Flow.Status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeFlowResponse>> flowStandbyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFlowResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFlowResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "STANDBY");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "STOPPING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Flow.Status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRouterInputResponse>> inputActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRouterInputResponse>> result = new ArrayList<WaiterAcceptor<? super GetRouterInputResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (RouterInput.State=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRouterInputResponse>> inputDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRouterInputResponse>> result = new ArrayList<WaiterAcceptor<? super GetRouterInputResponse>>();
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (RouterInput.State=ERROR) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "NotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRouterInputResponse>> inputStandbyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRouterInputResponse>> result = new ArrayList<WaiterAcceptor<? super GetRouterInputResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "STANDBY");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "STOPPING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (RouterInput.State=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRouterOutputResponse>> outputActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRouterOutputResponse>> result = new ArrayList<WaiterAcceptor<? super GetRouterOutputResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (RouterOutput.State=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRouterOutputResponse>> outputDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRouterOutputResponse>> result = new ArrayList<WaiterAcceptor<? super GetRouterOutputResponse>>();
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (RouterOutput.State=ERROR) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "NotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRouterOutputResponse>> outputRoutedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRouterOutputResponse>> result = new ArrayList<WaiterAcceptor<? super GetRouterOutputResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("RoutedState").value(), "ROUTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("RoutedState").value(), "ROUTING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "ServiceUnavailableException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRouterOutputResponse>> outputStandbyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRouterOutputResponse>> result = new ArrayList<WaiterAcceptor<? super GetRouterOutputResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "STANDBY");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "STOPPING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectAsyncWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (RouterOutput.State=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration flowActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration flowDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration flowStandbyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration inputActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration inputDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration inputStandbyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration outputActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration outputDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration outputRoutedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration outputStandbyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static MediaConnectAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends MediaConnectRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MediaConnectRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements MediaConnectAsyncWaiter.Builder {
        private MediaConnectAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public MediaConnectAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public MediaConnectAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public MediaConnectAsyncWaiter.Builder client(MediaConnectAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public MediaConnectAsyncWaiter build() {
            return new DefaultMediaConnectAsyncWaiter(this);
        }
    }
}

