/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MaintenanceConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputTier;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputTransitEncryption;
import software.amazon.awssdk.services.mediaconnect.model.RoutingScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRouterInputRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, UpdateRouterInputRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateRouterInputRequest.getter(UpdateRouterInputRequest::arn)).setter(UpdateRouterInputRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateRouterInputRequest.getter(UpdateRouterInputRequest::name)).setter(UpdateRouterInputRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<RouterInputConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(UpdateRouterInputRequest.getter(UpdateRouterInputRequest::configuration)).setter(UpdateRouterInputRequest.setter(Builder::configuration)).constructor(RouterInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<Long> MAXIMUM_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaximumBitrate").getter(UpdateRouterInputRequest.getter(UpdateRouterInputRequest::maximumBitrate)).setter(UpdateRouterInputRequest.setter(Builder::maximumBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumBitrate").build()}).build();
    private static final SdkField<String> ROUTING_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingScope").getter(UpdateRouterInputRequest.getter(UpdateRouterInputRequest::routingScopeAsString)).setter(UpdateRouterInputRequest.setter(Builder::routingScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingScope").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(UpdateRouterInputRequest.getter(UpdateRouterInputRequest::tierAsString)).setter(UpdateRouterInputRequest.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()}).build();
    private static final SdkField<RouterInputTransitEncryption> TRANSIT_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransitEncryption").getter(UpdateRouterInputRequest.getter(UpdateRouterInputRequest::transitEncryption)).setter(UpdateRouterInputRequest.setter(Builder::transitEncryption)).constructor(RouterInputTransitEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitEncryption").build()}).build();
    private static final SdkField<MaintenanceConfiguration> MAINTENANCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceConfiguration").getter(UpdateRouterInputRequest.getter(UpdateRouterInputRequest::maintenanceConfiguration)).setter(UpdateRouterInputRequest.setter(Builder::maintenanceConfiguration)).constructor(MaintenanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, CONFIGURATION_FIELD, MAXIMUM_BITRATE_FIELD, ROUTING_SCOPE_FIELD, TIER_FIELD, TRANSIT_ENCRYPTION_FIELD, MAINTENANCE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateRouterInputRequest.memberNameToFieldInitializer();
    private final String arn;
    private final String name;
    private final RouterInputConfiguration configuration;
    private final Long maximumBitrate;
    private final String routingScope;
    private final String tier;
    private final RouterInputTransitEncryption transitEncryption;
    private final MaintenanceConfiguration maintenanceConfiguration;

    private UpdateRouterInputRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.maximumBitrate = builder.maximumBitrate;
        this.routingScope = builder.routingScope;
        this.tier = builder.tier;
        this.transitEncryption = builder.transitEncryption;
        this.maintenanceConfiguration = builder.maintenanceConfiguration;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final RouterInputConfiguration configuration() {
        return this.configuration;
    }

    public final Long maximumBitrate() {
        return this.maximumBitrate;
    }

    public final RoutingScope routingScope() {
        return RoutingScope.fromValue(this.routingScope);
    }

    public final String routingScopeAsString() {
        return this.routingScope;
    }

    public final RouterInputTier tier() {
        return RouterInputTier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final RouterInputTransitEncryption transitEncryption() {
        return this.transitEncryption;
    }

    public final MaintenanceConfiguration maintenanceConfiguration() {
        return this.maintenanceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRouterInputRequest)) {
            return false;
        }
        UpdateRouterInputRequest other = (UpdateRouterInputRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.maximumBitrate(), other.maximumBitrate()) && Objects.equals(this.routingScopeAsString(), other.routingScopeAsString()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.transitEncryption(), other.transitEncryption()) && Objects.equals(this.maintenanceConfiguration(), other.maintenanceConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRouterInputRequest").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Configuration", (Object)this.configuration()).add("MaximumBitrate", (Object)this.maximumBitrate()).add("RoutingScope", (Object)this.routingScopeAsString()).add("Tier", (Object)this.tierAsString()).add("TransitEncryption", (Object)this.transitEncryption()).add("MaintenanceConfiguration", (Object)this.maintenanceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "MaximumBitrate": {
                return Optional.ofNullable(clazz.cast(this.maximumBitrate()));
            }
            case "RoutingScope": {
                return Optional.ofNullable(clazz.cast(this.routingScopeAsString()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "TransitEncryption": {
                return Optional.ofNullable(clazz.cast(this.transitEncryption()));
            }
            case "MaintenanceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.maintenanceConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("maximumBitrate", MAXIMUM_BITRATE_FIELD);
        map.put("routingScope", ROUTING_SCOPE_FIELD);
        map.put("tier", TIER_FIELD);
        map.put("transitEncryption", TRANSIT_ENCRYPTION_FIELD);
        map.put("maintenanceConfiguration", MAINTENANCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRouterInputRequest, T> g) {
        return obj -> g.apply((UpdateRouterInputRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private RouterInputConfiguration configuration;
        private Long maximumBitrate;
        private String routingScope;
        private String tier;
        private RouterInputTransitEncryption transitEncryption;
        private MaintenanceConfiguration maintenanceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRouterInputRequest model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.configuration(model.configuration);
            this.maximumBitrate(model.maximumBitrate);
            this.routingScope(model.routingScope);
            this.tier(model.tier);
            this.transitEncryption(model.transitEncryption);
            this.maintenanceConfiguration(model.maintenanceConfiguration);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RouterInputConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(RouterInputConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RouterInputConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Long getMaximumBitrate() {
            return this.maximumBitrate;
        }

        public final void setMaximumBitrate(Long maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
        }

        @Override
        public final Builder maximumBitrate(Long maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
            return this;
        }

        public final String getRoutingScope() {
            return this.routingScope;
        }

        public final void setRoutingScope(String routingScope) {
            this.routingScope = routingScope;
        }

        @Override
        public final Builder routingScope(String routingScope) {
            this.routingScope = routingScope;
            return this;
        }

        @Override
        public final Builder routingScope(RoutingScope routingScope) {
            this.routingScope(routingScope == null ? null : routingScope.toString());
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(RouterInputTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final RouterInputTransitEncryption.Builder getTransitEncryption() {
            return this.transitEncryption != null ? this.transitEncryption.toBuilder() : null;
        }

        public final void setTransitEncryption(RouterInputTransitEncryption.BuilderImpl transitEncryption) {
            this.transitEncryption = transitEncryption != null ? transitEncryption.build() : null;
        }

        @Override
        public final Builder transitEncryption(RouterInputTransitEncryption transitEncryption) {
            this.transitEncryption = transitEncryption;
            return this;
        }

        public final MaintenanceConfiguration.Builder getMaintenanceConfiguration() {
            return this.maintenanceConfiguration != null ? this.maintenanceConfiguration.toBuilder() : null;
        }

        public final void setMaintenanceConfiguration(MaintenanceConfiguration.BuilderImpl maintenanceConfiguration) {
            this.maintenanceConfiguration = maintenanceConfiguration != null ? maintenanceConfiguration.build() : null;
        }

        @Override
        public final Builder maintenanceConfiguration(MaintenanceConfiguration maintenanceConfiguration) {
            this.maintenanceConfiguration = maintenanceConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRouterInputRequest build() {
            return new UpdateRouterInputRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRouterInputRequest> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder configuration(RouterInputConfiguration var1);

        default public Builder configuration(Consumer<RouterInputConfiguration.Builder> configuration) {
            return this.configuration((RouterInputConfiguration)((RouterInputConfiguration.Builder)RouterInputConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder maximumBitrate(Long var1);

        public Builder routingScope(String var1);

        public Builder routingScope(RoutingScope var1);

        public Builder tier(String var1);

        public Builder tier(RouterInputTier var1);

        public Builder transitEncryption(RouterInputTransitEncryption var1);

        default public Builder transitEncryption(Consumer<RouterInputTransitEncryption.Builder> transitEncryption) {
            return this.transitEncryption((RouterInputTransitEncryption)((RouterInputTransitEncryption.Builder)RouterInputTransitEncryption.builder().applyMutation(transitEncryption)).build());
        }

        public Builder maintenanceConfiguration(MaintenanceConfiguration var1);

        default public Builder maintenanceConfiguration(Consumer<MaintenanceConfiguration.Builder> maintenanceConfiguration) {
            return this.maintenanceConfiguration((MaintenanceConfiguration)((MaintenanceConfiguration.Builder)MaintenanceConfiguration.builder().applyMutation(maintenanceConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

