/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TakeRouterInputRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, TakeRouterInputRequest> {
    private static final SdkField<String> ROUTER_OUTPUT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouterOutputArn").getter(TakeRouterInputRequest.getter(TakeRouterInputRequest::routerOutputArn)).setter(TakeRouterInputRequest.setter(Builder::routerOutputArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("RouterOutputArn").build()}).build();
    private static final SdkField<String> ROUTER_INPUT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouterInputArn").getter(TakeRouterInputRequest.getter(TakeRouterInputRequest::routerInputArn)).setter(TakeRouterInputRequest.setter(Builder::routerInputArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerInputArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTER_OUTPUT_ARN_FIELD, ROUTER_INPUT_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TakeRouterInputRequest.memberNameToFieldInitializer();
    private final String routerOutputArn;
    private final String routerInputArn;

    private TakeRouterInputRequest(BuilderImpl builder) {
        super(builder);
        this.routerOutputArn = builder.routerOutputArn;
        this.routerInputArn = builder.routerInputArn;
    }

    public final String routerOutputArn() {
        return this.routerOutputArn;
    }

    public final String routerInputArn() {
        return this.routerInputArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.routerOutputArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.routerInputArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TakeRouterInputRequest)) {
            return false;
        }
        TakeRouterInputRequest other = (TakeRouterInputRequest)((Object)obj);
        return Objects.equals(this.routerOutputArn(), other.routerOutputArn()) && Objects.equals(this.routerInputArn(), other.routerInputArn());
    }

    public final String toString() {
        return ToString.builder((String)"TakeRouterInputRequest").add("RouterOutputArn", (Object)this.routerOutputArn()).add("RouterInputArn", (Object)this.routerInputArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouterOutputArn": {
                return Optional.ofNullable(clazz.cast(this.routerOutputArn()));
            }
            case "RouterInputArn": {
                return Optional.ofNullable(clazz.cast(this.routerInputArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("RouterOutputArn", ROUTER_OUTPUT_ARN_FIELD);
        map.put("routerInputArn", ROUTER_INPUT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TakeRouterInputRequest, T> g) {
        return obj -> g.apply((TakeRouterInputRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private String routerOutputArn;
        private String routerInputArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TakeRouterInputRequest model) {
            super(model);
            this.routerOutputArn(model.routerOutputArn);
            this.routerInputArn(model.routerInputArn);
        }

        public final String getRouterOutputArn() {
            return this.routerOutputArn;
        }

        public final void setRouterOutputArn(String routerOutputArn) {
            this.routerOutputArn = routerOutputArn;
        }

        @Override
        public final Builder routerOutputArn(String routerOutputArn) {
            this.routerOutputArn = routerOutputArn;
            return this;
        }

        public final String getRouterInputArn() {
            return this.routerInputArn;
        }

        public final void setRouterInputArn(String routerInputArn) {
            this.routerInputArn = routerInputArn;
        }

        @Override
        public final Builder routerInputArn(String routerInputArn) {
            this.routerInputArn = routerInputArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TakeRouterInputRequest build() {
            return new TakeRouterInputRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TakeRouterInputRequest> {
        public Builder routerOutputArn(String var1);

        public Builder routerInputArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

