/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.SrtEncryptionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SrtListenerRouterOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SrtListenerRouterOutputConfiguration> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(SrtListenerRouterOutputConfiguration.getter(SrtListenerRouterOutputConfiguration::port)).setter(SrtListenerRouterOutputConfiguration.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<Long> MINIMUM_LATENCY_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MinimumLatencyMilliseconds").getter(SrtListenerRouterOutputConfiguration.getter(SrtListenerRouterOutputConfiguration::minimumLatencyMilliseconds)).setter(SrtListenerRouterOutputConfiguration.setter(Builder::minimumLatencyMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLatencyMilliseconds").build()}).build();
    private static final SdkField<SrtEncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(SrtListenerRouterOutputConfiguration.getter(SrtListenerRouterOutputConfiguration::encryptionConfiguration)).setter(SrtListenerRouterOutputConfiguration.setter(Builder::encryptionConfiguration)).constructor(SrtEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD, MINIMUM_LATENCY_MILLISECONDS_FIELD, ENCRYPTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SrtListenerRouterOutputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer port;
    private final Long minimumLatencyMilliseconds;
    private final SrtEncryptionConfiguration encryptionConfiguration;

    private SrtListenerRouterOutputConfiguration(BuilderImpl builder) {
        this.port = builder.port;
        this.minimumLatencyMilliseconds = builder.minimumLatencyMilliseconds;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public final Integer port() {
        return this.port;
    }

    public final Long minimumLatencyMilliseconds() {
        return this.minimumLatencyMilliseconds;
    }

    public final SrtEncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLatencyMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtListenerRouterOutputConfiguration)) {
            return false;
        }
        SrtListenerRouterOutputConfiguration other = (SrtListenerRouterOutputConfiguration)obj;
        return Objects.equals(this.port(), other.port()) && Objects.equals(this.minimumLatencyMilliseconds(), other.minimumLatencyMilliseconds()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"SrtListenerRouterOutputConfiguration").add("Port", (Object)this.port()).add("MinimumLatencyMilliseconds", (Object)this.minimumLatencyMilliseconds()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "MinimumLatencyMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.minimumLatencyMilliseconds()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("port", PORT_FIELD);
        map.put("minimumLatencyMilliseconds", MINIMUM_LATENCY_MILLISECONDS_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SrtListenerRouterOutputConfiguration, T> g) {
        return obj -> g.apply((SrtListenerRouterOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer port;
        private Long minimumLatencyMilliseconds;
        private SrtEncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtListenerRouterOutputConfiguration model) {
            this.port(model.port);
            this.minimumLatencyMilliseconds(model.minimumLatencyMilliseconds);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Long getMinimumLatencyMilliseconds() {
            return this.minimumLatencyMilliseconds;
        }

        public final void setMinimumLatencyMilliseconds(Long minimumLatencyMilliseconds) {
            this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
        }

        @Override
        public final Builder minimumLatencyMilliseconds(Long minimumLatencyMilliseconds) {
            this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
            return this;
        }

        public final SrtEncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(SrtEncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(SrtEncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public SrtListenerRouterOutputConfiguration build() {
            return new SrtListenerRouterOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SrtListenerRouterOutputConfiguration> {
        public Builder port(Integer var1);

        public Builder minimumLatencyMilliseconds(Long var1);

        public Builder encryptionConfiguration(SrtEncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<SrtEncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((SrtEncryptionConfiguration)((SrtEncryptionConfiguration.Builder)SrtEncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }
    }
}

