/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.SrtDecryptionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SrtListenerRouterInputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SrtListenerRouterInputConfiguration> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(SrtListenerRouterInputConfiguration.getter(SrtListenerRouterInputConfiguration::port)).setter(SrtListenerRouterInputConfiguration.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<Long> MINIMUM_LATENCY_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MinimumLatencyMilliseconds").getter(SrtListenerRouterInputConfiguration.getter(SrtListenerRouterInputConfiguration::minimumLatencyMilliseconds)).setter(SrtListenerRouterInputConfiguration.setter(Builder::minimumLatencyMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLatencyMilliseconds").build()}).build();
    private static final SdkField<SrtDecryptionConfiguration> DECRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DecryptionConfiguration").getter(SrtListenerRouterInputConfiguration.getter(SrtListenerRouterInputConfiguration::decryptionConfiguration)).setter(SrtListenerRouterInputConfiguration.setter(Builder::decryptionConfiguration)).constructor(SrtDecryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD, MINIMUM_LATENCY_MILLISECONDS_FIELD, DECRYPTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SrtListenerRouterInputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer port;
    private final Long minimumLatencyMilliseconds;
    private final SrtDecryptionConfiguration decryptionConfiguration;

    private SrtListenerRouterInputConfiguration(BuilderImpl builder) {
        this.port = builder.port;
        this.minimumLatencyMilliseconds = builder.minimumLatencyMilliseconds;
        this.decryptionConfiguration = builder.decryptionConfiguration;
    }

    public final Integer port() {
        return this.port;
    }

    public final Long minimumLatencyMilliseconds() {
        return this.minimumLatencyMilliseconds;
    }

    public final SrtDecryptionConfiguration decryptionConfiguration() {
        return this.decryptionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLatencyMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.decryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtListenerRouterInputConfiguration)) {
            return false;
        }
        SrtListenerRouterInputConfiguration other = (SrtListenerRouterInputConfiguration)obj;
        return Objects.equals(this.port(), other.port()) && Objects.equals(this.minimumLatencyMilliseconds(), other.minimumLatencyMilliseconds()) && Objects.equals(this.decryptionConfiguration(), other.decryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"SrtListenerRouterInputConfiguration").add("Port", (Object)this.port()).add("MinimumLatencyMilliseconds", (Object)this.minimumLatencyMilliseconds()).add("DecryptionConfiguration", (Object)this.decryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "MinimumLatencyMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.minimumLatencyMilliseconds()));
            }
            case "DecryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.decryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("port", PORT_FIELD);
        map.put("minimumLatencyMilliseconds", MINIMUM_LATENCY_MILLISECONDS_FIELD);
        map.put("decryptionConfiguration", DECRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SrtListenerRouterInputConfiguration, T> g) {
        return obj -> g.apply((SrtListenerRouterInputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer port;
        private Long minimumLatencyMilliseconds;
        private SrtDecryptionConfiguration decryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtListenerRouterInputConfiguration model) {
            this.port(model.port);
            this.minimumLatencyMilliseconds(model.minimumLatencyMilliseconds);
            this.decryptionConfiguration(model.decryptionConfiguration);
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Long getMinimumLatencyMilliseconds() {
            return this.minimumLatencyMilliseconds;
        }

        public final void setMinimumLatencyMilliseconds(Long minimumLatencyMilliseconds) {
            this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
        }

        @Override
        public final Builder minimumLatencyMilliseconds(Long minimumLatencyMilliseconds) {
            this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
            return this;
        }

        public final SrtDecryptionConfiguration.Builder getDecryptionConfiguration() {
            return this.decryptionConfiguration != null ? this.decryptionConfiguration.toBuilder() : null;
        }

        public final void setDecryptionConfiguration(SrtDecryptionConfiguration.BuilderImpl decryptionConfiguration) {
            this.decryptionConfiguration = decryptionConfiguration != null ? decryptionConfiguration.build() : null;
        }

        @Override
        public final Builder decryptionConfiguration(SrtDecryptionConfiguration decryptionConfiguration) {
            this.decryptionConfiguration = decryptionConfiguration;
            return this;
        }

        public SrtListenerRouterInputConfiguration build() {
            return new SrtListenerRouterInputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SrtListenerRouterInputConfiguration> {
        public Builder port(Integer var1);

        public Builder minimumLatencyMilliseconds(Long var1);

        public Builder decryptionConfiguration(SrtDecryptionConfiguration var1);

        default public Builder decryptionConfiguration(Consumer<SrtDecryptionConfiguration.Builder> decryptionConfiguration) {
            return this.decryptionConfiguration((SrtDecryptionConfiguration)((SrtDecryptionConfiguration.Builder)SrtDecryptionConfiguration.builder().applyMutation(decryptionConfiguration)).build());
        }
    }
}

