/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.ForwardErrorCorrectionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RtpRouterInputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RtpRouterInputConfiguration> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(RtpRouterInputConfiguration.getter(RtpRouterInputConfiguration::port)).setter(RtpRouterInputConfiguration.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> FORWARD_ERROR_CORRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForwardErrorCorrection").getter(RtpRouterInputConfiguration.getter(RtpRouterInputConfiguration::forwardErrorCorrectionAsString)).setter(RtpRouterInputConfiguration.setter(Builder::forwardErrorCorrection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forwardErrorCorrection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD, FORWARD_ERROR_CORRECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RtpRouterInputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer port;
    private final String forwardErrorCorrection;

    private RtpRouterInputConfiguration(BuilderImpl builder) {
        this.port = builder.port;
        this.forwardErrorCorrection = builder.forwardErrorCorrection;
    }

    public final Integer port() {
        return this.port;
    }

    public final ForwardErrorCorrectionState forwardErrorCorrection() {
        return ForwardErrorCorrectionState.fromValue(this.forwardErrorCorrection);
    }

    public final String forwardErrorCorrectionAsString() {
        return this.forwardErrorCorrection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardErrorCorrectionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RtpRouterInputConfiguration)) {
            return false;
        }
        RtpRouterInputConfiguration other = (RtpRouterInputConfiguration)obj;
        return Objects.equals(this.port(), other.port()) && Objects.equals(this.forwardErrorCorrectionAsString(), other.forwardErrorCorrectionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RtpRouterInputConfiguration").add("Port", (Object)this.port()).add("ForwardErrorCorrection", (Object)this.forwardErrorCorrectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "ForwardErrorCorrection": {
                return Optional.ofNullable(clazz.cast(this.forwardErrorCorrectionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("port", PORT_FIELD);
        map.put("forwardErrorCorrection", FORWARD_ERROR_CORRECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RtpRouterInputConfiguration, T> g) {
        return obj -> g.apply((RtpRouterInputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer port;
        private String forwardErrorCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(RtpRouterInputConfiguration model) {
            this.port(model.port);
            this.forwardErrorCorrection(model.forwardErrorCorrection);
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getForwardErrorCorrection() {
            return this.forwardErrorCorrection;
        }

        public final void setForwardErrorCorrection(String forwardErrorCorrection) {
            this.forwardErrorCorrection = forwardErrorCorrection;
        }

        @Override
        public final Builder forwardErrorCorrection(String forwardErrorCorrection) {
            this.forwardErrorCorrection = forwardErrorCorrection;
            return this;
        }

        @Override
        public final Builder forwardErrorCorrection(ForwardErrorCorrectionState forwardErrorCorrection) {
            this.forwardErrorCorrection(forwardErrorCorrection == null ? null : forwardErrorCorrection.toString());
            return this;
        }

        public RtpRouterInputConfiguration build() {
            return new RtpRouterInputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RtpRouterInputConfiguration> {
        public Builder port(Integer var1);

        public Builder forwardErrorCorrection(String var1);

        public Builder forwardErrorCorrection(ForwardErrorCorrectionState var1);
    }
}

