/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouterOutputType {
    STANDARD("STANDARD"),
    MEDIACONNECT_FLOW("MEDIACONNECT_FLOW"),
    MEDIALIVE_INPUT("MEDIALIVE_INPUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouterOutputType> VALUE_MAP;
    private final String value;

    private RouterOutputType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouterOutputType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouterOutputType> knownValues() {
        EnumSet<RouterOutputType> knownValues = EnumSet.allOf(RouterOutputType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouterOutputType.class, RouterOutputType::toString);
    }
}

