/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.MaintenanceConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.MaintenanceSchedule;
import software.amazon.awssdk.services.mediaconnect.model.MaintenanceScheduleType;
import software.amazon.awssdk.services.mediaconnect.model.MaintenanceType;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputMessage;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputMessagesCopier;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputRoutedState;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputState;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputStreamDetails;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputTier;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputType;
import software.amazon.awssdk.services.mediaconnect.model.RoutingScope;
import software.amazon.awssdk.services.mediaconnect.model.___mapOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterOutput> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RouterOutput.getter(RouterOutput::name)).setter(RouterOutput.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(RouterOutput.getter(RouterOutput::arn)).setter(RouterOutput.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(RouterOutput.getter(RouterOutput::id)).setter(RouterOutput.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(RouterOutput.getter(RouterOutput::stateAsString)).setter(RouterOutput.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputType").getter(RouterOutput.getter(RouterOutput::outputTypeAsString)).setter(RouterOutput.setter(Builder::outputType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputType").build()}).build();
    private static final SdkField<RouterOutputConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(RouterOutput.getter(RouterOutput::configuration)).setter(RouterOutput.setter(Builder::configuration)).constructor(RouterOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> ROUTED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutedState").getter(RouterOutput.getter(RouterOutput::routedStateAsString)).setter(RouterOutput.setter(Builder::routedState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routedState").build()}).build();
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(RouterOutput.getter(RouterOutput::regionName)).setter(RouterOutput.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(RouterOutput.getter(RouterOutput::availabilityZone)).setter(RouterOutput.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<Long> MAXIMUM_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaximumBitrate").getter(RouterOutput.getter(RouterOutput::maximumBitrate)).setter(RouterOutput.setter(Builder::maximumBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumBitrate").build()}).build();
    private static final SdkField<String> ROUTING_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingScope").getter(RouterOutput.getter(RouterOutput::routingScopeAsString)).setter(RouterOutput.setter(Builder::routingScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingScope").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(RouterOutput.getter(RouterOutput::tierAsString)).setter(RouterOutput.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(RouterOutput.getter(RouterOutput::createdAt)).setter(RouterOutput.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(RouterOutput.getter(RouterOutput::updatedAt)).setter(RouterOutput.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<RouterOutputMessage>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Messages").getter(RouterOutput.getter(RouterOutput::messages)).setter(RouterOutput.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouterOutputMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(RouterOutput.getter(RouterOutput::tags)).setter(RouterOutput.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<RouterOutputStreamDetails> STREAM_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamDetails").getter(RouterOutput.getter(RouterOutput::streamDetails)).setter(RouterOutput.setter(Builder::streamDetails)).constructor(RouterOutputStreamDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamDetails").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(RouterOutput.getter(RouterOutput::ipAddress)).setter(RouterOutput.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()}).build();
    private static final SdkField<String> ROUTED_INPUT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutedInputArn").getter(RouterOutput.getter(RouterOutput::routedInputArn)).setter(RouterOutput.setter(Builder::routedInputArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routedInputArn").build()}).build();
    private static final SdkField<String> MAINTENANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceType").getter(RouterOutput.getter(RouterOutput::maintenanceTypeAsString)).setter(RouterOutput.setter(Builder::maintenanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceType").build()}).build();
    private static final SdkField<MaintenanceConfiguration> MAINTENANCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceConfiguration").getter(RouterOutput.getter(RouterOutput::maintenanceConfiguration)).setter(RouterOutput.setter(Builder::maintenanceConfiguration)).constructor(MaintenanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceConfiguration").build()}).build();
    private static final SdkField<String> MAINTENANCE_SCHEDULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceScheduleType").getter(RouterOutput.getter(RouterOutput::maintenanceScheduleTypeAsString)).setter(RouterOutput.setter(Builder::maintenanceScheduleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceScheduleType").build()}).build();
    private static final SdkField<MaintenanceSchedule> MAINTENANCE_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceSchedule").getter(RouterOutput.getter(RouterOutput::maintenanceSchedule)).setter(RouterOutput.setter(Builder::maintenanceSchedule)).constructor(MaintenanceSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceSchedule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, ID_FIELD, STATE_FIELD, OUTPUT_TYPE_FIELD, CONFIGURATION_FIELD, ROUTED_STATE_FIELD, REGION_NAME_FIELD, AVAILABILITY_ZONE_FIELD, MAXIMUM_BITRATE_FIELD, ROUTING_SCOPE_FIELD, TIER_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, MESSAGES_FIELD, TAGS_FIELD, STREAM_DETAILS_FIELD, IP_ADDRESS_FIELD, ROUTED_INPUT_ARN_FIELD, MAINTENANCE_TYPE_FIELD, MAINTENANCE_CONFIGURATION_FIELD, MAINTENANCE_SCHEDULE_TYPE_FIELD, MAINTENANCE_SCHEDULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouterOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String id;
    private final String state;
    private final String outputType;
    private final RouterOutputConfiguration configuration;
    private final String routedState;
    private final String regionName;
    private final String availabilityZone;
    private final Long maximumBitrate;
    private final String routingScope;
    private final String tier;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final List<RouterOutputMessage> messages;
    private final Map<String, String> tags;
    private final RouterOutputStreamDetails streamDetails;
    private final String ipAddress;
    private final String routedInputArn;
    private final String maintenanceType;
    private final MaintenanceConfiguration maintenanceConfiguration;
    private final String maintenanceScheduleType;
    private final MaintenanceSchedule maintenanceSchedule;

    private RouterOutput(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.id = builder.id;
        this.state = builder.state;
        this.outputType = builder.outputType;
        this.configuration = builder.configuration;
        this.routedState = builder.routedState;
        this.regionName = builder.regionName;
        this.availabilityZone = builder.availabilityZone;
        this.maximumBitrate = builder.maximumBitrate;
        this.routingScope = builder.routingScope;
        this.tier = builder.tier;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.messages = builder.messages;
        this.tags = builder.tags;
        this.streamDetails = builder.streamDetails;
        this.ipAddress = builder.ipAddress;
        this.routedInputArn = builder.routedInputArn;
        this.maintenanceType = builder.maintenanceType;
        this.maintenanceConfiguration = builder.maintenanceConfiguration;
        this.maintenanceScheduleType = builder.maintenanceScheduleType;
        this.maintenanceSchedule = builder.maintenanceSchedule;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final RouterOutputState state() {
        return RouterOutputState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final RouterOutputType outputType() {
        return RouterOutputType.fromValue(this.outputType);
    }

    public final String outputTypeAsString() {
        return this.outputType;
    }

    public final RouterOutputConfiguration configuration() {
        return this.configuration;
    }

    public final RouterOutputRoutedState routedState() {
        return RouterOutputRoutedState.fromValue(this.routedState);
    }

    public final String routedStateAsString() {
        return this.routedState;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Long maximumBitrate() {
        return this.maximumBitrate;
    }

    public final RoutingScope routingScope() {
        return RoutingScope.fromValue(this.routingScope);
    }

    public final String routingScopeAsString() {
        return this.routingScope;
    }

    public final RouterOutputTier tier() {
        return RouterOutputTier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public final List<RouterOutputMessage> messages() {
        return this.messages;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final RouterOutputStreamDetails streamDetails() {
        return this.streamDetails;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final String routedInputArn() {
        return this.routedInputArn;
    }

    public final MaintenanceType maintenanceType() {
        return MaintenanceType.fromValue(this.maintenanceType);
    }

    public final String maintenanceTypeAsString() {
        return this.maintenanceType;
    }

    public final MaintenanceConfiguration maintenanceConfiguration() {
        return this.maintenanceConfiguration;
    }

    public final MaintenanceScheduleType maintenanceScheduleType() {
        return MaintenanceScheduleType.fromValue(this.maintenanceScheduleType);
    }

    public final String maintenanceScheduleTypeAsString() {
        return this.maintenanceScheduleType;
    }

    public final MaintenanceSchedule maintenanceSchedule() {
        return this.maintenanceSchedule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.routedStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.streamDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.routedInputArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceScheduleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceSchedule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterOutput)) {
            return false;
        }
        RouterOutput other = (RouterOutput)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.outputTypeAsString(), other.outputTypeAsString()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.routedStateAsString(), other.routedStateAsString()) && Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.maximumBitrate(), other.maximumBitrate()) && Objects.equals(this.routingScopeAsString(), other.routingScopeAsString()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.streamDetails(), other.streamDetails()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.routedInputArn(), other.routedInputArn()) && Objects.equals(this.maintenanceTypeAsString(), other.maintenanceTypeAsString()) && Objects.equals(this.maintenanceConfiguration(), other.maintenanceConfiguration()) && Objects.equals(this.maintenanceScheduleTypeAsString(), other.maintenanceScheduleTypeAsString()) && Objects.equals(this.maintenanceSchedule(), other.maintenanceSchedule());
    }

    public final String toString() {
        return ToString.builder((String)"RouterOutput").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("State", (Object)this.stateAsString()).add("OutputType", (Object)this.outputTypeAsString()).add("Configuration", (Object)this.configuration()).add("RoutedState", (Object)this.routedStateAsString()).add("RegionName", (Object)this.regionName()).add("AvailabilityZone", (Object)this.availabilityZone()).add("MaximumBitrate", (Object)this.maximumBitrate()).add("RoutingScope", (Object)this.routingScopeAsString()).add("Tier", (Object)this.tierAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Messages", this.hasMessages() ? this.messages() : null).add("Tags", this.hasTags() ? this.tags() : null).add("StreamDetails", (Object)this.streamDetails()).add("IpAddress", (Object)this.ipAddress()).add("RoutedInputArn", (Object)this.routedInputArn()).add("MaintenanceType", (Object)this.maintenanceTypeAsString()).add("MaintenanceConfiguration", (Object)this.maintenanceConfiguration()).add("MaintenanceScheduleType", (Object)this.maintenanceScheduleTypeAsString()).add("MaintenanceSchedule", (Object)this.maintenanceSchedule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "OutputType": {
                return Optional.ofNullable(clazz.cast(this.outputTypeAsString()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "RoutedState": {
                return Optional.ofNullable(clazz.cast(this.routedStateAsString()));
            }
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "MaximumBitrate": {
                return Optional.ofNullable(clazz.cast(this.maximumBitrate()));
            }
            case "RoutingScope": {
                return Optional.ofNullable(clazz.cast(this.routingScopeAsString()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "Messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "StreamDetails": {
                return Optional.ofNullable(clazz.cast(this.streamDetails()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "RoutedInputArn": {
                return Optional.ofNullable(clazz.cast(this.routedInputArn()));
            }
            case "MaintenanceType": {
                return Optional.ofNullable(clazz.cast(this.maintenanceTypeAsString()));
            }
            case "MaintenanceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.maintenanceConfiguration()));
            }
            case "MaintenanceScheduleType": {
                return Optional.ofNullable(clazz.cast(this.maintenanceScheduleTypeAsString()));
            }
            case "MaintenanceSchedule": {
                return Optional.ofNullable(clazz.cast(this.maintenanceSchedule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("state", STATE_FIELD);
        map.put("outputType", OUTPUT_TYPE_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("routedState", ROUTED_STATE_FIELD);
        map.put("regionName", REGION_NAME_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("maximumBitrate", MAXIMUM_BITRATE_FIELD);
        map.put("routingScope", ROUTING_SCOPE_FIELD);
        map.put("tier", TIER_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("messages", MESSAGES_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("streamDetails", STREAM_DETAILS_FIELD);
        map.put("ipAddress", IP_ADDRESS_FIELD);
        map.put("routedInputArn", ROUTED_INPUT_ARN_FIELD);
        map.put("maintenanceType", MAINTENANCE_TYPE_FIELD);
        map.put("maintenanceConfiguration", MAINTENANCE_CONFIGURATION_FIELD);
        map.put("maintenanceScheduleType", MAINTENANCE_SCHEDULE_TYPE_FIELD);
        map.put("maintenanceSchedule", MAINTENANCE_SCHEDULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterOutput, T> g) {
        return obj -> g.apply((RouterOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String id;
        private String state;
        private String outputType;
        private RouterOutputConfiguration configuration;
        private String routedState;
        private String regionName;
        private String availabilityZone;
        private Long maximumBitrate;
        private String routingScope;
        private String tier;
        private Instant createdAt;
        private Instant updatedAt;
        private List<RouterOutputMessage> messages = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private RouterOutputStreamDetails streamDetails;
        private String ipAddress;
        private String routedInputArn;
        private String maintenanceType;
        private MaintenanceConfiguration maintenanceConfiguration;
        private String maintenanceScheduleType;
        private MaintenanceSchedule maintenanceSchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(RouterOutput model) {
            this.name(model.name);
            this.arn(model.arn);
            this.id(model.id);
            this.state(model.state);
            this.outputType(model.outputType);
            this.configuration(model.configuration);
            this.routedState(model.routedState);
            this.regionName(model.regionName);
            this.availabilityZone(model.availabilityZone);
            this.maximumBitrate(model.maximumBitrate);
            this.routingScope(model.routingScope);
            this.tier(model.tier);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.messages(model.messages);
            this.tags(model.tags);
            this.streamDetails(model.streamDetails);
            this.ipAddress(model.ipAddress);
            this.routedInputArn(model.routedInputArn);
            this.maintenanceType(model.maintenanceType);
            this.maintenanceConfiguration(model.maintenanceConfiguration);
            this.maintenanceScheduleType(model.maintenanceScheduleType);
            this.maintenanceSchedule(model.maintenanceSchedule);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouterOutputState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getOutputType() {
            return this.outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        @Override
        public final Builder outputType(RouterOutputType outputType) {
            this.outputType(outputType == null ? null : outputType.toString());
            return this;
        }

        public final RouterOutputConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(RouterOutputConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RouterOutputConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getRoutedState() {
            return this.routedState;
        }

        public final void setRoutedState(String routedState) {
            this.routedState = routedState;
        }

        @Override
        public final Builder routedState(String routedState) {
            this.routedState = routedState;
            return this;
        }

        @Override
        public final Builder routedState(RouterOutputRoutedState routedState) {
            this.routedState(routedState == null ? null : routedState.toString());
            return this;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Long getMaximumBitrate() {
            return this.maximumBitrate;
        }

        public final void setMaximumBitrate(Long maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
        }

        @Override
        public final Builder maximumBitrate(Long maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
            return this;
        }

        public final String getRoutingScope() {
            return this.routingScope;
        }

        public final void setRoutingScope(String routingScope) {
            this.routingScope = routingScope;
        }

        @Override
        public final Builder routingScope(String routingScope) {
            this.routingScope = routingScope;
            return this;
        }

        @Override
        public final Builder routingScope(RoutingScope routingScope) {
            this.routingScope(routingScope == null ? null : routingScope.toString());
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(RouterOutputTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<RouterOutputMessage.Builder> getMessages() {
            List<RouterOutputMessage.Builder> result = RouterOutputMessagesCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<RouterOutputMessage.BuilderImpl> messages) {
            this.messages = RouterOutputMessagesCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<RouterOutputMessage> messages) {
            this.messages = RouterOutputMessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(RouterOutputMessage ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<RouterOutputMessage.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (RouterOutputMessage)((RouterOutputMessage.Builder)RouterOutputMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOfStringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOfStringCopier.copy(tags);
            return this;
        }

        public final RouterOutputStreamDetails.Builder getStreamDetails() {
            return this.streamDetails != null ? this.streamDetails.toBuilder() : null;
        }

        public final void setStreamDetails(RouterOutputStreamDetails.BuilderImpl streamDetails) {
            this.streamDetails = streamDetails != null ? streamDetails.build() : null;
        }

        @Override
        public final Builder streamDetails(RouterOutputStreamDetails streamDetails) {
            this.streamDetails = streamDetails;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getRoutedInputArn() {
            return this.routedInputArn;
        }

        public final void setRoutedInputArn(String routedInputArn) {
            this.routedInputArn = routedInputArn;
        }

        @Override
        public final Builder routedInputArn(String routedInputArn) {
            this.routedInputArn = routedInputArn;
            return this;
        }

        public final String getMaintenanceType() {
            return this.maintenanceType;
        }

        public final void setMaintenanceType(String maintenanceType) {
            this.maintenanceType = maintenanceType;
        }

        @Override
        public final Builder maintenanceType(String maintenanceType) {
            this.maintenanceType = maintenanceType;
            return this;
        }

        @Override
        public final Builder maintenanceType(MaintenanceType maintenanceType) {
            this.maintenanceType(maintenanceType == null ? null : maintenanceType.toString());
            return this;
        }

        public final MaintenanceConfiguration.Builder getMaintenanceConfiguration() {
            return this.maintenanceConfiguration != null ? this.maintenanceConfiguration.toBuilder() : null;
        }

        public final void setMaintenanceConfiguration(MaintenanceConfiguration.BuilderImpl maintenanceConfiguration) {
            this.maintenanceConfiguration = maintenanceConfiguration != null ? maintenanceConfiguration.build() : null;
        }

        @Override
        public final Builder maintenanceConfiguration(MaintenanceConfiguration maintenanceConfiguration) {
            this.maintenanceConfiguration = maintenanceConfiguration;
            return this;
        }

        public final String getMaintenanceScheduleType() {
            return this.maintenanceScheduleType;
        }

        public final void setMaintenanceScheduleType(String maintenanceScheduleType) {
            this.maintenanceScheduleType = maintenanceScheduleType;
        }

        @Override
        public final Builder maintenanceScheduleType(String maintenanceScheduleType) {
            this.maintenanceScheduleType = maintenanceScheduleType;
            return this;
        }

        @Override
        public final Builder maintenanceScheduleType(MaintenanceScheduleType maintenanceScheduleType) {
            this.maintenanceScheduleType(maintenanceScheduleType == null ? null : maintenanceScheduleType.toString());
            return this;
        }

        public final MaintenanceSchedule.Builder getMaintenanceSchedule() {
            return this.maintenanceSchedule != null ? this.maintenanceSchedule.toBuilder() : null;
        }

        public final void setMaintenanceSchedule(MaintenanceSchedule.BuilderImpl maintenanceSchedule) {
            this.maintenanceSchedule = maintenanceSchedule != null ? maintenanceSchedule.build() : null;
        }

        @Override
        public final Builder maintenanceSchedule(MaintenanceSchedule maintenanceSchedule) {
            this.maintenanceSchedule = maintenanceSchedule;
            return this;
        }

        public RouterOutput build() {
            return new RouterOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterOutput> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder state(String var1);

        public Builder state(RouterOutputState var1);

        public Builder outputType(String var1);

        public Builder outputType(RouterOutputType var1);

        public Builder configuration(RouterOutputConfiguration var1);

        default public Builder configuration(Consumer<RouterOutputConfiguration.Builder> configuration) {
            return this.configuration((RouterOutputConfiguration)((RouterOutputConfiguration.Builder)RouterOutputConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder routedState(String var1);

        public Builder routedState(RouterOutputRoutedState var1);

        public Builder regionName(String var1);

        public Builder availabilityZone(String var1);

        public Builder maximumBitrate(Long var1);

        public Builder routingScope(String var1);

        public Builder routingScope(RoutingScope var1);

        public Builder tier(String var1);

        public Builder tier(RouterOutputTier var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder messages(Collection<RouterOutputMessage> var1);

        public Builder messages(RouterOutputMessage ... var1);

        public Builder messages(Consumer<RouterOutputMessage.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder streamDetails(RouterOutputStreamDetails var1);

        default public Builder streamDetails(Consumer<RouterOutputStreamDetails.Builder> streamDetails) {
            return this.streamDetails((RouterOutputStreamDetails)((RouterOutputStreamDetails.Builder)RouterOutputStreamDetails.builder().applyMutation(streamDetails)).build());
        }

        public Builder ipAddress(String var1);

        public Builder routedInputArn(String var1);

        public Builder maintenanceType(String var1);

        public Builder maintenanceType(MaintenanceType var1);

        public Builder maintenanceConfiguration(MaintenanceConfiguration var1);

        default public Builder maintenanceConfiguration(Consumer<MaintenanceConfiguration.Builder> maintenanceConfiguration) {
            return this.maintenanceConfiguration((MaintenanceConfiguration)((MaintenanceConfiguration.Builder)MaintenanceConfiguration.builder().applyMutation(maintenanceConfiguration)).build());
        }

        public Builder maintenanceScheduleType(String var1);

        public Builder maintenanceScheduleType(MaintenanceScheduleType var1);

        public Builder maintenanceSchedule(MaintenanceSchedule var1);

        default public Builder maintenanceSchedule(Consumer<MaintenanceSchedule.Builder> maintenanceSchedule) {
            return this.maintenanceSchedule((MaintenanceSchedule)((MaintenanceSchedule.Builder)MaintenanceSchedule.builder().applyMutation(maintenanceSchedule)).build());
        }
    }
}

