/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputMessage;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputMessagesCopier;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterInputSourceMetadataDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterInputSourceMetadataDetails> {
    private static final SdkField<List<RouterInputMessage>> SOURCE_METADATA_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceMetadataMessages").getter(RouterInputSourceMetadataDetails.getter(RouterInputSourceMetadataDetails::sourceMetadataMessages)).setter(RouterInputSourceMetadataDetails.setter(Builder::sourceMetadataMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceMetadataMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouterInputMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(RouterInputSourceMetadataDetails.getter(RouterInputSourceMetadataDetails::timestamp)).setter(RouterInputSourceMetadataDetails.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<RouterInputMetadata> ROUTER_INPUT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RouterInputMetadata").getter(RouterInputSourceMetadataDetails.getter(RouterInputSourceMetadataDetails::routerInputMetadata)).setter(RouterInputSourceMetadataDetails.setter(Builder::routerInputMetadata)).constructor(RouterInputMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerInputMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_METADATA_MESSAGES_FIELD, TIMESTAMP_FIELD, ROUTER_INPUT_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouterInputSourceMetadataDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<RouterInputMessage> sourceMetadataMessages;
    private final Instant timestamp;
    private final RouterInputMetadata routerInputMetadata;

    private RouterInputSourceMetadataDetails(BuilderImpl builder) {
        this.sourceMetadataMessages = builder.sourceMetadataMessages;
        this.timestamp = builder.timestamp;
        this.routerInputMetadata = builder.routerInputMetadata;
    }

    public final boolean hasSourceMetadataMessages() {
        return this.sourceMetadataMessages != null && !(this.sourceMetadataMessages instanceof SdkAutoConstructList);
    }

    public final List<RouterInputMessage> sourceMetadataMessages() {
        return this.sourceMetadataMessages;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final RouterInputMetadata routerInputMetadata() {
        return this.routerInputMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceMetadataMessages() ? this.sourceMetadataMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.routerInputMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterInputSourceMetadataDetails)) {
            return false;
        }
        RouterInputSourceMetadataDetails other = (RouterInputSourceMetadataDetails)obj;
        return this.hasSourceMetadataMessages() == other.hasSourceMetadataMessages() && Objects.equals(this.sourceMetadataMessages(), other.sourceMetadataMessages()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.routerInputMetadata(), other.routerInputMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"RouterInputSourceMetadataDetails").add("SourceMetadataMessages", this.hasSourceMetadataMessages() ? this.sourceMetadataMessages() : null).add("Timestamp", (Object)this.timestamp()).add("RouterInputMetadata", (Object)this.routerInputMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceMetadataMessages": {
                return Optional.ofNullable(clazz.cast(this.sourceMetadataMessages()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "RouterInputMetadata": {
                return Optional.ofNullable(clazz.cast(this.routerInputMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceMetadataMessages", SOURCE_METADATA_MESSAGES_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("routerInputMetadata", ROUTER_INPUT_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterInputSourceMetadataDetails, T> g) {
        return obj -> g.apply((RouterInputSourceMetadataDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RouterInputMessage> sourceMetadataMessages = DefaultSdkAutoConstructList.getInstance();
        private Instant timestamp;
        private RouterInputMetadata routerInputMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(RouterInputSourceMetadataDetails model) {
            this.sourceMetadataMessages(model.sourceMetadataMessages);
            this.timestamp(model.timestamp);
            this.routerInputMetadata(model.routerInputMetadata);
        }

        public final List<RouterInputMessage.Builder> getSourceMetadataMessages() {
            List<RouterInputMessage.Builder> result = RouterInputMessagesCopier.copyToBuilder(this.sourceMetadataMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceMetadataMessages(Collection<RouterInputMessage.BuilderImpl> sourceMetadataMessages) {
            this.sourceMetadataMessages = RouterInputMessagesCopier.copyFromBuilder(sourceMetadataMessages);
        }

        @Override
        public final Builder sourceMetadataMessages(Collection<RouterInputMessage> sourceMetadataMessages) {
            this.sourceMetadataMessages = RouterInputMessagesCopier.copy(sourceMetadataMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceMetadataMessages(RouterInputMessage ... sourceMetadataMessages) {
            this.sourceMetadataMessages(Arrays.asList(sourceMetadataMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceMetadataMessages(Consumer<RouterInputMessage.Builder> ... sourceMetadataMessages) {
            this.sourceMetadataMessages(Stream.of(sourceMetadataMessages).map(c -> (RouterInputMessage)((RouterInputMessage.Builder)RouterInputMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final RouterInputMetadata.Builder getRouterInputMetadata() {
            return this.routerInputMetadata != null ? this.routerInputMetadata.toBuilder() : null;
        }

        public final void setRouterInputMetadata(RouterInputMetadata.BuilderImpl routerInputMetadata) {
            this.routerInputMetadata = routerInputMetadata != null ? routerInputMetadata.build() : null;
        }

        @Override
        public final Builder routerInputMetadata(RouterInputMetadata routerInputMetadata) {
            this.routerInputMetadata = routerInputMetadata;
            return this;
        }

        public RouterInputSourceMetadataDetails build() {
            return new RouterInputSourceMetadataDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterInputSourceMetadataDetails> {
        public Builder sourceMetadataMessages(Collection<RouterInputMessage> var1);

        public Builder sourceMetadataMessages(RouterInputMessage ... var1);

        public Builder sourceMetadataMessages(Consumer<RouterInputMessage.Builder> ... var1);

        public Builder timestamp(Instant var1);

        public Builder routerInputMetadata(RouterInputMetadata var1);

        default public Builder routerInputMetadata(Consumer<RouterInputMetadata.Builder> routerInputMetadata) {
            return this.routerInputMetadata((RouterInputMetadata)((RouterInputMetadata.Builder)RouterInputMetadata.builder().applyMutation(routerInputMetadata)).build());
        }
    }
}

