/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.RistRouterInputConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.RtpRouterInputConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.SrtCallerRouterInputConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.SrtListenerRouterInputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterInputProtocolConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterInputProtocolConfiguration> {
    private static final SdkField<RtpRouterInputConfiguration> RTP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rtp").getter(RouterInputProtocolConfiguration.getter(RouterInputProtocolConfiguration::rtp)).setter(RouterInputProtocolConfiguration.setter(Builder::rtp)).constructor(RtpRouterInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtp").build()}).build();
    private static final SdkField<RistRouterInputConfiguration> RIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rist").getter(RouterInputProtocolConfiguration.getter(RouterInputProtocolConfiguration::rist)).setter(RouterInputProtocolConfiguration.setter(Builder::rist)).constructor(RistRouterInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rist").build()}).build();
    private static final SdkField<SrtListenerRouterInputConfiguration> SRT_LISTENER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SrtListener").getter(RouterInputProtocolConfiguration.getter(RouterInputProtocolConfiguration::srtListener)).setter(RouterInputProtocolConfiguration.setter(Builder::srtListener)).constructor(SrtListenerRouterInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtListener").build()}).build();
    private static final SdkField<SrtCallerRouterInputConfiguration> SRT_CALLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SrtCaller").getter(RouterInputProtocolConfiguration.getter(RouterInputProtocolConfiguration::srtCaller)).setter(RouterInputProtocolConfiguration.setter(Builder::srtCaller)).constructor(SrtCallerRouterInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtCaller").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RTP_FIELD, RIST_FIELD, SRT_LISTENER_FIELD, SRT_CALLER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouterInputProtocolConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RtpRouterInputConfiguration rtp;
    private final RistRouterInputConfiguration rist;
    private final SrtListenerRouterInputConfiguration srtListener;
    private final SrtCallerRouterInputConfiguration srtCaller;
    private final Type type;

    private RouterInputProtocolConfiguration(BuilderImpl builder) {
        this.rtp = builder.rtp;
        this.rist = builder.rist;
        this.srtListener = builder.srtListener;
        this.srtCaller = builder.srtCaller;
        this.type = builder.type;
    }

    public final RtpRouterInputConfiguration rtp() {
        return this.rtp;
    }

    public final RistRouterInputConfiguration rist() {
        return this.rist;
    }

    public final SrtListenerRouterInputConfiguration srtListener() {
        return this.srtListener;
    }

    public final SrtCallerRouterInputConfiguration srtCaller() {
        return this.srtCaller;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rtp());
        hashCode = 31 * hashCode + Objects.hashCode(this.rist());
        hashCode = 31 * hashCode + Objects.hashCode(this.srtListener());
        hashCode = 31 * hashCode + Objects.hashCode(this.srtCaller());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterInputProtocolConfiguration)) {
            return false;
        }
        RouterInputProtocolConfiguration other = (RouterInputProtocolConfiguration)obj;
        return Objects.equals(this.rtp(), other.rtp()) && Objects.equals(this.rist(), other.rist()) && Objects.equals(this.srtListener(), other.srtListener()) && Objects.equals(this.srtCaller(), other.srtCaller());
    }

    public final String toString() {
        return ToString.builder((String)"RouterInputProtocolConfiguration").add("Rtp", (Object)this.rtp()).add("Rist", (Object)this.rist()).add("SrtListener", (Object)this.srtListener()).add("SrtCaller", (Object)this.srtCaller()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rtp": {
                return Optional.ofNullable(clazz.cast(this.rtp()));
            }
            case "Rist": {
                return Optional.ofNullable(clazz.cast(this.rist()));
            }
            case "SrtListener": {
                return Optional.ofNullable(clazz.cast(this.srtListener()));
            }
            case "SrtCaller": {
                return Optional.ofNullable(clazz.cast(this.srtCaller()));
            }
        }
        return Optional.empty();
    }

    public static RouterInputProtocolConfiguration fromRtp(RtpRouterInputConfiguration rtp) {
        return (RouterInputProtocolConfiguration)RouterInputProtocolConfiguration.builder().rtp(rtp).build();
    }

    public static RouterInputProtocolConfiguration fromRtp(Consumer<RtpRouterInputConfiguration.Builder> rtp) {
        RtpRouterInputConfiguration.Builder builder = RtpRouterInputConfiguration.builder();
        rtp.accept(builder);
        return RouterInputProtocolConfiguration.fromRtp((RtpRouterInputConfiguration)builder.build());
    }

    public static RouterInputProtocolConfiguration fromRist(RistRouterInputConfiguration rist) {
        return (RouterInputProtocolConfiguration)RouterInputProtocolConfiguration.builder().rist(rist).build();
    }

    public static RouterInputProtocolConfiguration fromRist(Consumer<RistRouterInputConfiguration.Builder> rist) {
        RistRouterInputConfiguration.Builder builder = RistRouterInputConfiguration.builder();
        rist.accept(builder);
        return RouterInputProtocolConfiguration.fromRist((RistRouterInputConfiguration)builder.build());
    }

    public static RouterInputProtocolConfiguration fromSrtListener(SrtListenerRouterInputConfiguration srtListener) {
        return (RouterInputProtocolConfiguration)RouterInputProtocolConfiguration.builder().srtListener(srtListener).build();
    }

    public static RouterInputProtocolConfiguration fromSrtListener(Consumer<SrtListenerRouterInputConfiguration.Builder> srtListener) {
        SrtListenerRouterInputConfiguration.Builder builder = SrtListenerRouterInputConfiguration.builder();
        srtListener.accept(builder);
        return RouterInputProtocolConfiguration.fromSrtListener((SrtListenerRouterInputConfiguration)builder.build());
    }

    public static RouterInputProtocolConfiguration fromSrtCaller(SrtCallerRouterInputConfiguration srtCaller) {
        return (RouterInputProtocolConfiguration)RouterInputProtocolConfiguration.builder().srtCaller(srtCaller).build();
    }

    public static RouterInputProtocolConfiguration fromSrtCaller(Consumer<SrtCallerRouterInputConfiguration.Builder> srtCaller) {
        SrtCallerRouterInputConfiguration.Builder builder = SrtCallerRouterInputConfiguration.builder();
        srtCaller.accept(builder);
        return RouterInputProtocolConfiguration.fromSrtCaller((SrtCallerRouterInputConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rtp", RTP_FIELD);
        map.put("rist", RIST_FIELD);
        map.put("srtListener", SRT_LISTENER_FIELD);
        map.put("srtCaller", SRT_CALLER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterInputProtocolConfiguration, T> g) {
        return obj -> g.apply((RouterInputProtocolConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        RTP,
        RIST,
        SRT_LISTENER,
        SRT_CALLER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private RtpRouterInputConfiguration rtp;
        private RistRouterInputConfiguration rist;
        private SrtListenerRouterInputConfiguration srtListener;
        private SrtCallerRouterInputConfiguration srtCaller;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterInputProtocolConfiguration model) {
            this.rtp(model.rtp);
            this.rist(model.rist);
            this.srtListener(model.srtListener);
            this.srtCaller(model.srtCaller);
        }

        public final RtpRouterInputConfiguration.Builder getRtp() {
            return this.rtp != null ? this.rtp.toBuilder() : null;
        }

        public final void setRtp(RtpRouterInputConfiguration.BuilderImpl rtp) {
            RtpRouterInputConfiguration oldValue = this.rtp;
            this.rtp = rtp != null ? rtp.build() : null;
            this.handleUnionValueChange(Type.RTP, oldValue, this.rtp);
        }

        @Override
        public final Builder rtp(RtpRouterInputConfiguration rtp) {
            RtpRouterInputConfiguration oldValue = this.rtp;
            this.rtp = rtp;
            this.handleUnionValueChange(Type.RTP, oldValue, this.rtp);
            return this;
        }

        public final RistRouterInputConfiguration.Builder getRist() {
            return this.rist != null ? this.rist.toBuilder() : null;
        }

        public final void setRist(RistRouterInputConfiguration.BuilderImpl rist) {
            RistRouterInputConfiguration oldValue = this.rist;
            this.rist = rist != null ? rist.build() : null;
            this.handleUnionValueChange(Type.RIST, oldValue, this.rist);
        }

        @Override
        public final Builder rist(RistRouterInputConfiguration rist) {
            RistRouterInputConfiguration oldValue = this.rist;
            this.rist = rist;
            this.handleUnionValueChange(Type.RIST, oldValue, this.rist);
            return this;
        }

        public final SrtListenerRouterInputConfiguration.Builder getSrtListener() {
            return this.srtListener != null ? this.srtListener.toBuilder() : null;
        }

        public final void setSrtListener(SrtListenerRouterInputConfiguration.BuilderImpl srtListener) {
            SrtListenerRouterInputConfiguration oldValue = this.srtListener;
            this.srtListener = srtListener != null ? srtListener.build() : null;
            this.handleUnionValueChange(Type.SRT_LISTENER, oldValue, this.srtListener);
        }

        @Override
        public final Builder srtListener(SrtListenerRouterInputConfiguration srtListener) {
            SrtListenerRouterInputConfiguration oldValue = this.srtListener;
            this.srtListener = srtListener;
            this.handleUnionValueChange(Type.SRT_LISTENER, oldValue, this.srtListener);
            return this;
        }

        public final SrtCallerRouterInputConfiguration.Builder getSrtCaller() {
            return this.srtCaller != null ? this.srtCaller.toBuilder() : null;
        }

        public final void setSrtCaller(SrtCallerRouterInputConfiguration.BuilderImpl srtCaller) {
            SrtCallerRouterInputConfiguration oldValue = this.srtCaller;
            this.srtCaller = srtCaller != null ? srtCaller.build() : null;
            this.handleUnionValueChange(Type.SRT_CALLER, oldValue, this.srtCaller);
        }

        @Override
        public final Builder srtCaller(SrtCallerRouterInputConfiguration srtCaller) {
            SrtCallerRouterInputConfiguration oldValue = this.srtCaller;
            this.srtCaller = srtCaller;
            this.handleUnionValueChange(Type.SRT_CALLER, oldValue, this.srtCaller);
            return this;
        }

        public RouterInputProtocolConfiguration build() {
            return new RouterInputProtocolConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterInputProtocolConfiguration> {
        public Builder rtp(RtpRouterInputConfiguration var1);

        default public Builder rtp(Consumer<RtpRouterInputConfiguration.Builder> rtp) {
            return this.rtp((RtpRouterInputConfiguration)((RtpRouterInputConfiguration.Builder)RtpRouterInputConfiguration.builder().applyMutation(rtp)).build());
        }

        public Builder rist(RistRouterInputConfiguration var1);

        default public Builder rist(Consumer<RistRouterInputConfiguration.Builder> rist) {
            return this.rist((RistRouterInputConfiguration)((RistRouterInputConfiguration.Builder)RistRouterInputConfiguration.builder().applyMutation(rist)).build());
        }

        public Builder srtListener(SrtListenerRouterInputConfiguration var1);

        default public Builder srtListener(Consumer<SrtListenerRouterInputConfiguration.Builder> srtListener) {
            return this.srtListener((SrtListenerRouterInputConfiguration)((SrtListenerRouterInputConfiguration.Builder)SrtListenerRouterInputConfiguration.builder().applyMutation(srtListener)).build());
        }

        public Builder srtCaller(SrtCallerRouterInputConfiguration var1);

        default public Builder srtCaller(Consumer<SrtCallerRouterInputConfiguration.Builder> srtCaller) {
            return this.srtCaller((SrtCallerRouterInputConfiguration)((SrtCallerRouterInputConfiguration.Builder)SrtCallerRouterInputConfiguration.builder().applyMutation(srtCaller)).build());
        }
    }
}

