/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.FailoverRouterInputConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectFlowRouterInputConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.MergeRouterInputConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.StandardRouterInputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterInputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterInputConfiguration> {
    private static final SdkField<StandardRouterInputConfiguration> STANDARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Standard").getter(RouterInputConfiguration.getter(RouterInputConfiguration::standard)).setter(RouterInputConfiguration.setter(Builder::standard)).constructor(StandardRouterInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standard").build()}).build();
    private static final SdkField<FailoverRouterInputConfiguration> FAILOVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Failover").getter(RouterInputConfiguration.getter(RouterInputConfiguration::failover)).setter(RouterInputConfiguration.setter(Builder::failover)).constructor(FailoverRouterInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failover").build()}).build();
    private static final SdkField<MergeRouterInputConfiguration> MERGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Merge").getter(RouterInputConfiguration.getter(RouterInputConfiguration::merge)).setter(RouterInputConfiguration.setter(Builder::merge)).constructor(MergeRouterInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("merge").build()}).build();
    private static final SdkField<MediaConnectFlowRouterInputConfiguration> MEDIA_CONNECT_FLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaConnectFlow").getter(RouterInputConfiguration.getter(RouterInputConfiguration::mediaConnectFlow)).setter(RouterInputConfiguration.setter(Builder::mediaConnectFlow)).constructor(MediaConnectFlowRouterInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaConnectFlow").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARD_FIELD, FAILOVER_FIELD, MERGE_FIELD, MEDIA_CONNECT_FLOW_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouterInputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final StandardRouterInputConfiguration standard;
    private final FailoverRouterInputConfiguration failover;
    private final MergeRouterInputConfiguration merge;
    private final MediaConnectFlowRouterInputConfiguration mediaConnectFlow;
    private final Type type;

    private RouterInputConfiguration(BuilderImpl builder) {
        this.standard = builder.standard;
        this.failover = builder.failover;
        this.merge = builder.merge;
        this.mediaConnectFlow = builder.mediaConnectFlow;
        this.type = builder.type;
    }

    public final StandardRouterInputConfiguration standard() {
        return this.standard;
    }

    public final FailoverRouterInputConfiguration failover() {
        return this.failover;
    }

    public final MergeRouterInputConfiguration merge() {
        return this.merge;
    }

    public final MediaConnectFlowRouterInputConfiguration mediaConnectFlow() {
        return this.mediaConnectFlow;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.standard());
        hashCode = 31 * hashCode + Objects.hashCode(this.failover());
        hashCode = 31 * hashCode + Objects.hashCode(this.merge());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaConnectFlow());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterInputConfiguration)) {
            return false;
        }
        RouterInputConfiguration other = (RouterInputConfiguration)obj;
        return Objects.equals(this.standard(), other.standard()) && Objects.equals(this.failover(), other.failover()) && Objects.equals(this.merge(), other.merge()) && Objects.equals(this.mediaConnectFlow(), other.mediaConnectFlow());
    }

    public final String toString() {
        return ToString.builder((String)"RouterInputConfiguration").add("Standard", (Object)this.standard()).add("Failover", (Object)this.failover()).add("Merge", (Object)this.merge()).add("MediaConnectFlow", (Object)this.mediaConnectFlow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Standard": {
                return Optional.ofNullable(clazz.cast(this.standard()));
            }
            case "Failover": {
                return Optional.ofNullable(clazz.cast(this.failover()));
            }
            case "Merge": {
                return Optional.ofNullable(clazz.cast(this.merge()));
            }
            case "MediaConnectFlow": {
                return Optional.ofNullable(clazz.cast(this.mediaConnectFlow()));
            }
        }
        return Optional.empty();
    }

    public static RouterInputConfiguration fromStandard(StandardRouterInputConfiguration standard) {
        return (RouterInputConfiguration)RouterInputConfiguration.builder().standard(standard).build();
    }

    public static RouterInputConfiguration fromStandard(Consumer<StandardRouterInputConfiguration.Builder> standard) {
        StandardRouterInputConfiguration.Builder builder = StandardRouterInputConfiguration.builder();
        standard.accept(builder);
        return RouterInputConfiguration.fromStandard((StandardRouterInputConfiguration)builder.build());
    }

    public static RouterInputConfiguration fromFailover(FailoverRouterInputConfiguration failover) {
        return (RouterInputConfiguration)RouterInputConfiguration.builder().failover(failover).build();
    }

    public static RouterInputConfiguration fromFailover(Consumer<FailoverRouterInputConfiguration.Builder> failover) {
        FailoverRouterInputConfiguration.Builder builder = FailoverRouterInputConfiguration.builder();
        failover.accept(builder);
        return RouterInputConfiguration.fromFailover((FailoverRouterInputConfiguration)builder.build());
    }

    public static RouterInputConfiguration fromMerge(MergeRouterInputConfiguration merge) {
        return (RouterInputConfiguration)RouterInputConfiguration.builder().merge(merge).build();
    }

    public static RouterInputConfiguration fromMerge(Consumer<MergeRouterInputConfiguration.Builder> merge) {
        MergeRouterInputConfiguration.Builder builder = MergeRouterInputConfiguration.builder();
        merge.accept(builder);
        return RouterInputConfiguration.fromMerge((MergeRouterInputConfiguration)builder.build());
    }

    public static RouterInputConfiguration fromMediaConnectFlow(MediaConnectFlowRouterInputConfiguration mediaConnectFlow) {
        return (RouterInputConfiguration)RouterInputConfiguration.builder().mediaConnectFlow(mediaConnectFlow).build();
    }

    public static RouterInputConfiguration fromMediaConnectFlow(Consumer<MediaConnectFlowRouterInputConfiguration.Builder> mediaConnectFlow) {
        MediaConnectFlowRouterInputConfiguration.Builder builder = MediaConnectFlowRouterInputConfiguration.builder();
        mediaConnectFlow.accept(builder);
        return RouterInputConfiguration.fromMediaConnectFlow((MediaConnectFlowRouterInputConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("standard", STANDARD_FIELD);
        map.put("failover", FAILOVER_FIELD);
        map.put("merge", MERGE_FIELD);
        map.put("mediaConnectFlow", MEDIA_CONNECT_FLOW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterInputConfiguration, T> g) {
        return obj -> g.apply((RouterInputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        STANDARD,
        FAILOVER,
        MERGE,
        MEDIA_CONNECT_FLOW,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private StandardRouterInputConfiguration standard;
        private FailoverRouterInputConfiguration failover;
        private MergeRouterInputConfiguration merge;
        private MediaConnectFlowRouterInputConfiguration mediaConnectFlow;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterInputConfiguration model) {
            this.standard(model.standard);
            this.failover(model.failover);
            this.merge(model.merge);
            this.mediaConnectFlow(model.mediaConnectFlow);
        }

        public final StandardRouterInputConfiguration.Builder getStandard() {
            return this.standard != null ? this.standard.toBuilder() : null;
        }

        public final void setStandard(StandardRouterInputConfiguration.BuilderImpl standard) {
            StandardRouterInputConfiguration oldValue = this.standard;
            this.standard = standard != null ? standard.build() : null;
            this.handleUnionValueChange(Type.STANDARD, oldValue, this.standard);
        }

        @Override
        public final Builder standard(StandardRouterInputConfiguration standard) {
            StandardRouterInputConfiguration oldValue = this.standard;
            this.standard = standard;
            this.handleUnionValueChange(Type.STANDARD, oldValue, this.standard);
            return this;
        }

        public final FailoverRouterInputConfiguration.Builder getFailover() {
            return this.failover != null ? this.failover.toBuilder() : null;
        }

        public final void setFailover(FailoverRouterInputConfiguration.BuilderImpl failover) {
            FailoverRouterInputConfiguration oldValue = this.failover;
            this.failover = failover != null ? failover.build() : null;
            this.handleUnionValueChange(Type.FAILOVER, oldValue, this.failover);
        }

        @Override
        public final Builder failover(FailoverRouterInputConfiguration failover) {
            FailoverRouterInputConfiguration oldValue = this.failover;
            this.failover = failover;
            this.handleUnionValueChange(Type.FAILOVER, oldValue, this.failover);
            return this;
        }

        public final MergeRouterInputConfiguration.Builder getMerge() {
            return this.merge != null ? this.merge.toBuilder() : null;
        }

        public final void setMerge(MergeRouterInputConfiguration.BuilderImpl merge) {
            MergeRouterInputConfiguration oldValue = this.merge;
            this.merge = merge != null ? merge.build() : null;
            this.handleUnionValueChange(Type.MERGE, oldValue, this.merge);
        }

        @Override
        public final Builder merge(MergeRouterInputConfiguration merge) {
            MergeRouterInputConfiguration oldValue = this.merge;
            this.merge = merge;
            this.handleUnionValueChange(Type.MERGE, oldValue, this.merge);
            return this;
        }

        public final MediaConnectFlowRouterInputConfiguration.Builder getMediaConnectFlow() {
            return this.mediaConnectFlow != null ? this.mediaConnectFlow.toBuilder() : null;
        }

        public final void setMediaConnectFlow(MediaConnectFlowRouterInputConfiguration.BuilderImpl mediaConnectFlow) {
            MediaConnectFlowRouterInputConfiguration oldValue = this.mediaConnectFlow;
            this.mediaConnectFlow = mediaConnectFlow != null ? mediaConnectFlow.build() : null;
            this.handleUnionValueChange(Type.MEDIA_CONNECT_FLOW, oldValue, this.mediaConnectFlow);
        }

        @Override
        public final Builder mediaConnectFlow(MediaConnectFlowRouterInputConfiguration mediaConnectFlow) {
            MediaConnectFlowRouterInputConfiguration oldValue = this.mediaConnectFlow;
            this.mediaConnectFlow = mediaConnectFlow;
            this.handleUnionValueChange(Type.MEDIA_CONNECT_FLOW, oldValue, this.mediaConnectFlow);
            return this;
        }

        public RouterInputConfiguration build() {
            return new RouterInputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterInputConfiguration> {
        public Builder standard(StandardRouterInputConfiguration var1);

        default public Builder standard(Consumer<StandardRouterInputConfiguration.Builder> standard) {
            return this.standard((StandardRouterInputConfiguration)((StandardRouterInputConfiguration.Builder)StandardRouterInputConfiguration.builder().applyMutation(standard)).build());
        }

        public Builder failover(FailoverRouterInputConfiguration var1);

        default public Builder failover(Consumer<FailoverRouterInputConfiguration.Builder> failover) {
            return this.failover((FailoverRouterInputConfiguration)((FailoverRouterInputConfiguration.Builder)FailoverRouterInputConfiguration.builder().applyMutation(failover)).build());
        }

        public Builder merge(MergeRouterInputConfiguration var1);

        default public Builder merge(Consumer<MergeRouterInputConfiguration.Builder> merge) {
            return this.merge((MergeRouterInputConfiguration)((MergeRouterInputConfiguration.Builder)MergeRouterInputConfiguration.builder().applyMutation(merge)).build());
        }

        public Builder mediaConnectFlow(MediaConnectFlowRouterInputConfiguration var1);

        default public Builder mediaConnectFlow(Consumer<MediaConnectFlowRouterInputConfiguration.Builder> mediaConnectFlow) {
            return this.mediaConnectFlow((MediaConnectFlowRouterInputConfiguration)((MediaConnectFlowRouterInputConfiguration.Builder)MediaConnectFlowRouterInputConfiguration.builder().applyMutation(mediaConnectFlow)).build());
        }
    }
}

