/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.FlowTransitEncryption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaConnectFlowRouterOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaConnectFlowRouterOutputConfiguration> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(MediaConnectFlowRouterOutputConfiguration.getter(MediaConnectFlowRouterOutputConfiguration::flowArn)).setter(MediaConnectFlowRouterOutputConfiguration.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<String> FLOW_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowSourceArn").getter(MediaConnectFlowRouterOutputConfiguration.getter(MediaConnectFlowRouterOutputConfiguration::flowSourceArn)).setter(MediaConnectFlowRouterOutputConfiguration.setter(Builder::flowSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowSourceArn").build()}).build();
    private static final SdkField<FlowTransitEncryption> DESTINATION_TRANSIT_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationTransitEncryption").getter(MediaConnectFlowRouterOutputConfiguration.getter(MediaConnectFlowRouterOutputConfiguration::destinationTransitEncryption)).setter(MediaConnectFlowRouterOutputConfiguration.setter(Builder::destinationTransitEncryption)).constructor(FlowTransitEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationTransitEncryption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, FLOW_SOURCE_ARN_FIELD, DESTINATION_TRANSIT_ENCRYPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaConnectFlowRouterOutputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String flowArn;
    private final String flowSourceArn;
    private final FlowTransitEncryption destinationTransitEncryption;

    private MediaConnectFlowRouterOutputConfiguration(BuilderImpl builder) {
        this.flowArn = builder.flowArn;
        this.flowSourceArn = builder.flowSourceArn;
        this.destinationTransitEncryption = builder.destinationTransitEncryption;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final String flowSourceArn() {
        return this.flowSourceArn;
    }

    public final FlowTransitEncryption destinationTransitEncryption() {
        return this.destinationTransitEncryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTransitEncryption());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaConnectFlowRouterOutputConfiguration)) {
            return false;
        }
        MediaConnectFlowRouterOutputConfiguration other = (MediaConnectFlowRouterOutputConfiguration)obj;
        return Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.flowSourceArn(), other.flowSourceArn()) && Objects.equals(this.destinationTransitEncryption(), other.destinationTransitEncryption());
    }

    public final String toString() {
        return ToString.builder((String)"MediaConnectFlowRouterOutputConfiguration").add("FlowArn", (Object)this.flowArn()).add("FlowSourceArn", (Object)this.flowSourceArn()).add("DestinationTransitEncryption", (Object)this.destinationTransitEncryption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "FlowSourceArn": {
                return Optional.ofNullable(clazz.cast(this.flowSourceArn()));
            }
            case "DestinationTransitEncryption": {
                return Optional.ofNullable(clazz.cast(this.destinationTransitEncryption()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flowArn", FLOW_ARN_FIELD);
        map.put("flowSourceArn", FLOW_SOURCE_ARN_FIELD);
        map.put("destinationTransitEncryption", DESTINATION_TRANSIT_ENCRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaConnectFlowRouterOutputConfiguration, T> g) {
        return obj -> g.apply((MediaConnectFlowRouterOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String flowArn;
        private String flowSourceArn;
        private FlowTransitEncryption destinationTransitEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaConnectFlowRouterOutputConfiguration model) {
            this.flowArn(model.flowArn);
            this.flowSourceArn(model.flowSourceArn);
            this.destinationTransitEncryption(model.destinationTransitEncryption);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getFlowSourceArn() {
            return this.flowSourceArn;
        }

        public final void setFlowSourceArn(String flowSourceArn) {
            this.flowSourceArn = flowSourceArn;
        }

        @Override
        public final Builder flowSourceArn(String flowSourceArn) {
            this.flowSourceArn = flowSourceArn;
            return this;
        }

        public final FlowTransitEncryption.Builder getDestinationTransitEncryption() {
            return this.destinationTransitEncryption != null ? this.destinationTransitEncryption.toBuilder() : null;
        }

        public final void setDestinationTransitEncryption(FlowTransitEncryption.BuilderImpl destinationTransitEncryption) {
            this.destinationTransitEncryption = destinationTransitEncryption != null ? destinationTransitEncryption.build() : null;
        }

        @Override
        public final Builder destinationTransitEncryption(FlowTransitEncryption destinationTransitEncryption) {
            this.destinationTransitEncryption = destinationTransitEncryption;
            return this;
        }

        public MediaConnectFlowRouterOutputConfiguration build() {
            return new MediaConnectFlowRouterOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaConnectFlowRouterOutputConfiguration> {
        public Builder flowArn(String var1);

        public Builder flowSourceArn(String var1);

        public Builder destinationTransitEncryption(FlowTransitEncryption var1);

        default public Builder destinationTransitEncryption(Consumer<FlowTransitEncryption.Builder> destinationTransitEncryption) {
            return this.destinationTransitEncryption((FlowTransitEncryption)((FlowTransitEncryption.Builder)FlowTransitEncryption.builder().applyMutation(destinationTransitEncryption)).build());
        }
    }
}

