/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.ListedRouterInput;
import software.amazon.awssdk.services.mediaconnect.model.ListedRouterInputListCopier;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRouterInputsResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, ListRouterInputsResponse> {
    private static final SdkField<List<ListedRouterInput>> ROUTER_INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouterInputs").getter(ListRouterInputsResponse.getter(ListRouterInputsResponse::routerInputs)).setter(ListRouterInputsResponse.setter(Builder::routerInputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerInputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListedRouterInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRouterInputsResponse.getter(ListRouterInputsResponse::nextToken)).setter(ListRouterInputsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTER_INPUTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRouterInputsResponse.memberNameToFieldInitializer();
    private final List<ListedRouterInput> routerInputs;
    private final String nextToken;

    private ListRouterInputsResponse(BuilderImpl builder) {
        super(builder);
        this.routerInputs = builder.routerInputs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRouterInputs() {
        return this.routerInputs != null && !(this.routerInputs instanceof SdkAutoConstructList);
    }

    public final List<ListedRouterInput> routerInputs() {
        return this.routerInputs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouterInputs() ? this.routerInputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRouterInputsResponse)) {
            return false;
        }
        ListRouterInputsResponse other = (ListRouterInputsResponse)((Object)obj);
        return this.hasRouterInputs() == other.hasRouterInputs() && Objects.equals(this.routerInputs(), other.routerInputs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRouterInputsResponse").add("RouterInputs", this.hasRouterInputs() ? this.routerInputs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouterInputs": {
                return Optional.ofNullable(clazz.cast(this.routerInputs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("routerInputs", ROUTER_INPUTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRouterInputsResponse, T> g) {
        return obj -> g.apply((ListRouterInputsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private List<ListedRouterInput> routerInputs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRouterInputsResponse model) {
            super(model);
            this.routerInputs(model.routerInputs);
            this.nextToken(model.nextToken);
        }

        public final List<ListedRouterInput.Builder> getRouterInputs() {
            List<ListedRouterInput.Builder> result = ListedRouterInputListCopier.copyToBuilder(this.routerInputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouterInputs(Collection<ListedRouterInput.BuilderImpl> routerInputs) {
            this.routerInputs = ListedRouterInputListCopier.copyFromBuilder(routerInputs);
        }

        @Override
        public final Builder routerInputs(Collection<ListedRouterInput> routerInputs) {
            this.routerInputs = ListedRouterInputListCopier.copy(routerInputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routerInputs(ListedRouterInput ... routerInputs) {
            this.routerInputs(Arrays.asList(routerInputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routerInputs(Consumer<ListedRouterInput.Builder> ... routerInputs) {
            this.routerInputs(Stream.of(routerInputs).map(c -> (ListedRouterInput)((ListedRouterInput.Builder)ListedRouterInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRouterInputsResponse build() {
            return new ListRouterInputsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRouterInputsResponse> {
        public Builder routerInputs(Collection<ListedRouterInput> var1);

        public Builder routerInputs(ListedRouterInput ... var1);

        public Builder routerInputs(Consumer<ListedRouterInput.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

