/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.FailoverInputSourcePriorityMode;
import software.amazon.awssdk.services.mediaconnect.model.FailoverRouterInputProtocolConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.FailoverRouterInputProtocolConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailoverRouterInputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailoverRouterInputConfiguration> {
    private static final SdkField<String> NETWORK_INTERFACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceArn").getter(FailoverRouterInputConfiguration.getter(FailoverRouterInputConfiguration::networkInterfaceArn)).setter(FailoverRouterInputConfiguration.setter(Builder::networkInterfaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceArn").build()}).build();
    private static final SdkField<List<FailoverRouterInputProtocolConfiguration>> PROTOCOL_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProtocolConfigurations").getter(FailoverRouterInputConfiguration.getter(FailoverRouterInputConfiguration::protocolConfigurations)).setter(FailoverRouterInputConfiguration.setter(Builder::protocolConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailoverRouterInputProtocolConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_PRIORITY_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourcePriorityMode").getter(FailoverRouterInputConfiguration.getter(FailoverRouterInputConfiguration::sourcePriorityModeAsString)).setter(FailoverRouterInputConfiguration.setter(Builder::sourcePriorityMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePriorityMode").build()}).build();
    private static final SdkField<Integer> PRIMARY_SOURCE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PrimarySourceIndex").getter(FailoverRouterInputConfiguration.getter(FailoverRouterInputConfiguration::primarySourceIndex)).setter(FailoverRouterInputConfiguration.setter(Builder::primarySourceIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primarySourceIndex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ARN_FIELD, PROTOCOL_CONFIGURATIONS_FIELD, SOURCE_PRIORITY_MODE_FIELD, PRIMARY_SOURCE_INDEX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FailoverRouterInputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String networkInterfaceArn;
    private final List<FailoverRouterInputProtocolConfiguration> protocolConfigurations;
    private final String sourcePriorityMode;
    private final Integer primarySourceIndex;

    private FailoverRouterInputConfiguration(BuilderImpl builder) {
        this.networkInterfaceArn = builder.networkInterfaceArn;
        this.protocolConfigurations = builder.protocolConfigurations;
        this.sourcePriorityMode = builder.sourcePriorityMode;
        this.primarySourceIndex = builder.primarySourceIndex;
    }

    public final String networkInterfaceArn() {
        return this.networkInterfaceArn;
    }

    public final boolean hasProtocolConfigurations() {
        return this.protocolConfigurations != null && !(this.protocolConfigurations instanceof SdkAutoConstructList);
    }

    public final List<FailoverRouterInputProtocolConfiguration> protocolConfigurations() {
        return this.protocolConfigurations;
    }

    public final FailoverInputSourcePriorityMode sourcePriorityMode() {
        return FailoverInputSourcePriorityMode.fromValue(this.sourcePriorityMode);
    }

    public final String sourcePriorityModeAsString() {
        return this.sourcePriorityMode;
    }

    public final Integer primarySourceIndex() {
        return this.primarySourceIndex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocolConfigurations() ? this.protocolConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePriorityModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.primarySourceIndex());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverRouterInputConfiguration)) {
            return false;
        }
        FailoverRouterInputConfiguration other = (FailoverRouterInputConfiguration)obj;
        return Objects.equals(this.networkInterfaceArn(), other.networkInterfaceArn()) && this.hasProtocolConfigurations() == other.hasProtocolConfigurations() && Objects.equals(this.protocolConfigurations(), other.protocolConfigurations()) && Objects.equals(this.sourcePriorityModeAsString(), other.sourcePriorityModeAsString()) && Objects.equals(this.primarySourceIndex(), other.primarySourceIndex());
    }

    public final String toString() {
        return ToString.builder((String)"FailoverRouterInputConfiguration").add("NetworkInterfaceArn", (Object)this.networkInterfaceArn()).add("ProtocolConfigurations", this.hasProtocolConfigurations() ? this.protocolConfigurations() : null).add("SourcePriorityMode", (Object)this.sourcePriorityModeAsString()).add("PrimarySourceIndex", (Object)this.primarySourceIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfaceArn": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceArn()));
            }
            case "ProtocolConfigurations": {
                return Optional.ofNullable(clazz.cast(this.protocolConfigurations()));
            }
            case "SourcePriorityMode": {
                return Optional.ofNullable(clazz.cast(this.sourcePriorityModeAsString()));
            }
            case "PrimarySourceIndex": {
                return Optional.ofNullable(clazz.cast(this.primarySourceIndex()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkInterfaceArn", NETWORK_INTERFACE_ARN_FIELD);
        map.put("protocolConfigurations", PROTOCOL_CONFIGURATIONS_FIELD);
        map.put("sourcePriorityMode", SOURCE_PRIORITY_MODE_FIELD);
        map.put("primarySourceIndex", PRIMARY_SOURCE_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailoverRouterInputConfiguration, T> g) {
        return obj -> g.apply((FailoverRouterInputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkInterfaceArn;
        private List<FailoverRouterInputProtocolConfiguration> protocolConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String sourcePriorityMode;
        private Integer primarySourceIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverRouterInputConfiguration model) {
            this.networkInterfaceArn(model.networkInterfaceArn);
            this.protocolConfigurations(model.protocolConfigurations);
            this.sourcePriorityMode(model.sourcePriorityMode);
            this.primarySourceIndex(model.primarySourceIndex);
        }

        public final String getNetworkInterfaceArn() {
            return this.networkInterfaceArn;
        }

        public final void setNetworkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
        }

        @Override
        public final Builder networkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
            return this;
        }

        public final List<FailoverRouterInputProtocolConfiguration.Builder> getProtocolConfigurations() {
            List<FailoverRouterInputProtocolConfiguration.Builder> result = FailoverRouterInputProtocolConfigurationListCopier.copyToBuilder(this.protocolConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProtocolConfigurations(Collection<FailoverRouterInputProtocolConfiguration.BuilderImpl> protocolConfigurations) {
            this.protocolConfigurations = FailoverRouterInputProtocolConfigurationListCopier.copyFromBuilder(protocolConfigurations);
        }

        @Override
        public final Builder protocolConfigurations(Collection<FailoverRouterInputProtocolConfiguration> protocolConfigurations) {
            this.protocolConfigurations = FailoverRouterInputProtocolConfigurationListCopier.copy(protocolConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolConfigurations(FailoverRouterInputProtocolConfiguration ... protocolConfigurations) {
            this.protocolConfigurations(Arrays.asList(protocolConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolConfigurations(Consumer<FailoverRouterInputProtocolConfiguration.Builder> ... protocolConfigurations) {
            this.protocolConfigurations(Stream.of(protocolConfigurations).map(c -> (FailoverRouterInputProtocolConfiguration)((FailoverRouterInputProtocolConfiguration.Builder)FailoverRouterInputProtocolConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourcePriorityMode() {
            return this.sourcePriorityMode;
        }

        public final void setSourcePriorityMode(String sourcePriorityMode) {
            this.sourcePriorityMode = sourcePriorityMode;
        }

        @Override
        public final Builder sourcePriorityMode(String sourcePriorityMode) {
            this.sourcePriorityMode = sourcePriorityMode;
            return this;
        }

        @Override
        public final Builder sourcePriorityMode(FailoverInputSourcePriorityMode sourcePriorityMode) {
            this.sourcePriorityMode(sourcePriorityMode == null ? null : sourcePriorityMode.toString());
            return this;
        }

        public final Integer getPrimarySourceIndex() {
            return this.primarySourceIndex;
        }

        public final void setPrimarySourceIndex(Integer primarySourceIndex) {
            this.primarySourceIndex = primarySourceIndex;
        }

        @Override
        public final Builder primarySourceIndex(Integer primarySourceIndex) {
            this.primarySourceIndex = primarySourceIndex;
            return this;
        }

        public FailoverRouterInputConfiguration build() {
            return new FailoverRouterInputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailoverRouterInputConfiguration> {
        public Builder networkInterfaceArn(String var1);

        public Builder protocolConfigurations(Collection<FailoverRouterInputProtocolConfiguration> var1);

        public Builder protocolConfigurations(FailoverRouterInputProtocolConfiguration ... var1);

        public Builder protocolConfigurations(Consumer<FailoverRouterInputProtocolConfiguration.Builder> ... var1);

        public Builder sourcePriorityMode(String var1);

        public Builder sourcePriorityMode(FailoverInputSourcePriorityMode var1);

        public Builder primarySourceIndex(Integer var1);
    }
}

