/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.RouterNetworkInterfaceConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.___mapOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRouterNetworkInterfaceRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, CreateRouterNetworkInterfaceRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateRouterNetworkInterfaceRequest.getter(CreateRouterNetworkInterfaceRequest::name)).setter(CreateRouterNetworkInterfaceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<RouterNetworkInterfaceConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(CreateRouterNetworkInterfaceRequest.getter(CreateRouterNetworkInterfaceRequest::configuration)).setter(CreateRouterNetworkInterfaceRequest.setter(Builder::configuration)).constructor(RouterNetworkInterfaceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(CreateRouterNetworkInterfaceRequest.getter(CreateRouterNetworkInterfaceRequest::regionName)).setter(CreateRouterNetworkInterfaceRequest.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateRouterNetworkInterfaceRequest.getter(CreateRouterNetworkInterfaceRequest::tags)).setter(CreateRouterNetworkInterfaceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateRouterNetworkInterfaceRequest.getter(CreateRouterNetworkInterfaceRequest::clientToken)).setter(CreateRouterNetworkInterfaceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONFIGURATION_FIELD, REGION_NAME_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRouterNetworkInterfaceRequest.memberNameToFieldInitializer();
    private final String name;
    private final RouterNetworkInterfaceConfiguration configuration;
    private final String regionName;
    private final Map<String, String> tags;
    private final String clientToken;

    private CreateRouterNetworkInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.regionName = builder.regionName;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final RouterNetworkInterfaceConfiguration configuration() {
        return this.configuration;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouterNetworkInterfaceRequest)) {
            return false;
        }
        CreateRouterNetworkInterfaceRequest other = (CreateRouterNetworkInterfaceRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.regionName(), other.regionName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRouterNetworkInterfaceRequest").add("Name", (Object)this.name()).add("Configuration", (Object)this.configuration()).add("RegionName", (Object)this.regionName()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("regionName", REGION_NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRouterNetworkInterfaceRequest, T> g) {
        return obj -> g.apply((CreateRouterNetworkInterfaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private String name;
        private RouterNetworkInterfaceConfiguration configuration;
        private String regionName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouterNetworkInterfaceRequest model) {
            super(model);
            this.name(model.name);
            this.configuration(model.configuration);
            this.regionName(model.regionName);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RouterNetworkInterfaceConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(RouterNetworkInterfaceConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RouterNetworkInterfaceConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOfStringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOfStringCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRouterNetworkInterfaceRequest build() {
            return new CreateRouterNetworkInterfaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRouterNetworkInterfaceRequest> {
        public Builder name(String var1);

        public Builder configuration(RouterNetworkInterfaceConfiguration var1);

        default public Builder configuration(Consumer<RouterNetworkInterfaceConfiguration.Builder> configuration) {
            return this.configuration((RouterNetworkInterfaceConfiguration)((RouterNetworkInterfaceConfiguration.Builder)RouterNetworkInterfaceConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder regionName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

