/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputError;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputErrorListCopier;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutput;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetRouterOutputResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, BatchGetRouterOutputResponse> {
    private static final SdkField<List<RouterOutput>> ROUTER_OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouterOutputs").getter(BatchGetRouterOutputResponse.getter(BatchGetRouterOutputResponse::routerOutputs)).setter(BatchGetRouterOutputResponse.setter(Builder::routerOutputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerOutputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouterOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetRouterOutputError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchGetRouterOutputResponse.getter(BatchGetRouterOutputResponse::errors)).setter(BatchGetRouterOutputResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetRouterOutputError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTER_OUTPUTS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetRouterOutputResponse.memberNameToFieldInitializer();
    private final List<RouterOutput> routerOutputs;
    private final List<BatchGetRouterOutputError> errors;

    private BatchGetRouterOutputResponse(BuilderImpl builder) {
        super(builder);
        this.routerOutputs = builder.routerOutputs;
        this.errors = builder.errors;
    }

    public final boolean hasRouterOutputs() {
        return this.routerOutputs != null && !(this.routerOutputs instanceof SdkAutoConstructList);
    }

    public final List<RouterOutput> routerOutputs() {
        return this.routerOutputs;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetRouterOutputError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouterOutputs() ? this.routerOutputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRouterOutputResponse)) {
            return false;
        }
        BatchGetRouterOutputResponse other = (BatchGetRouterOutputResponse)((Object)obj);
        return this.hasRouterOutputs() == other.hasRouterOutputs() && Objects.equals(this.routerOutputs(), other.routerOutputs()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetRouterOutputResponse").add("RouterOutputs", this.hasRouterOutputs() ? this.routerOutputs() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouterOutputs": {
                return Optional.ofNullable(clazz.cast(this.routerOutputs()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("routerOutputs", ROUTER_OUTPUTS_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRouterOutputResponse, T> g) {
        return obj -> g.apply((BatchGetRouterOutputResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private List<RouterOutput> routerOutputs = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetRouterOutputError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRouterOutputResponse model) {
            super(model);
            this.routerOutputs(model.routerOutputs);
            this.errors(model.errors);
        }

        public final List<RouterOutput.Builder> getRouterOutputs() {
            List<RouterOutput.Builder> result = RouterOutputListCopier.copyToBuilder(this.routerOutputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouterOutputs(Collection<RouterOutput.BuilderImpl> routerOutputs) {
            this.routerOutputs = RouterOutputListCopier.copyFromBuilder(routerOutputs);
        }

        @Override
        public final Builder routerOutputs(Collection<RouterOutput> routerOutputs) {
            this.routerOutputs = RouterOutputListCopier.copy(routerOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routerOutputs(RouterOutput ... routerOutputs) {
            this.routerOutputs(Arrays.asList(routerOutputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routerOutputs(Consumer<RouterOutput.Builder> ... routerOutputs) {
            this.routerOutputs(Stream.of(routerOutputs).map(c -> (RouterOutput)((RouterOutput.Builder)RouterOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetRouterOutputError.Builder> getErrors() {
            List<BatchGetRouterOutputError.Builder> result = BatchGetRouterOutputErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetRouterOutputError.BuilderImpl> errors) {
            this.errors = BatchGetRouterOutputErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetRouterOutputError> errors) {
            this.errors = BatchGetRouterOutputErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetRouterOutputError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetRouterOutputError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetRouterOutputError)((BatchGetRouterOutputError.Builder)BatchGetRouterOutputError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetRouterOutputResponse build() {
            return new BatchGetRouterOutputResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetRouterOutputResponse> {
        public Builder routerOutputs(Collection<RouterOutput> var1);

        public Builder routerOutputs(RouterOutput ... var1);

        public Builder routerOutputs(Consumer<RouterOutput.Builder> ... var1);

        public Builder errors(Collection<BatchGetRouterOutputError> var1);

        public Builder errors(BatchGetRouterOutputError ... var1);

        public Builder errors(Consumer<BatchGetRouterOutputError.Builder> ... var1);
    }
}

