/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a specific time window for maintenance operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WindowMaintenanceSchedule implements SdkPojo, Serializable,
        ToCopyableBuilder<WindowMaintenanceSchedule.Builder, WindowMaintenanceSchedule> {
    private static final SdkField<Instant> START_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Start")
            .getter(getter(WindowMaintenanceSchedule::start))
            .setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("End")
            .getter(getter(WindowMaintenanceSchedule::end))
            .setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> SCHEDULED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ScheduledTime")
            .getter(getter(WindowMaintenanceSchedule::scheduledTime))
            .setter(setter(Builder::scheduledTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_FIELD, END_FIELD,
            SCHEDULED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant start;

    private final Instant end;

    private final Instant scheduledTime;

    private WindowMaintenanceSchedule(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
        this.scheduledTime = builder.scheduledTime;
    }

    /**
     * <p>
     * The start time of the maintenance window.
     * </p>
     * 
     * @return The start time of the maintenance window.
     */
    public final Instant start() {
        return start;
    }

    /**
     * <p>
     * The end time of the maintenance window.
     * </p>
     * 
     * @return The end time of the maintenance window.
     */
    public final Instant end() {
        return end;
    }

    /**
     * <p>
     * The date and time when the maintenance window is scheduled to occur.
     * </p>
     * 
     * @return The date and time when the maintenance window is scheduled to occur.
     */
    public final Instant scheduledTime() {
        return scheduledTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WindowMaintenanceSchedule)) {
            return false;
        }
        WindowMaintenanceSchedule other = (WindowMaintenanceSchedule) obj;
        return Objects.equals(start(), other.start()) && Objects.equals(end(), other.end())
                && Objects.equals(scheduledTime(), other.scheduledTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WindowMaintenanceSchedule").add("Start", start()).add("End", end())
                .add("ScheduledTime", scheduledTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        case "ScheduledTime":
            return Optional.ofNullable(clazz.cast(scheduledTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("start", START_FIELD);
        map.put("end", END_FIELD);
        map.put("scheduledTime", SCHEDULED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WindowMaintenanceSchedule, T> g) {
        return obj -> g.apply((WindowMaintenanceSchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WindowMaintenanceSchedule> {
        /**
         * <p>
         * The start time of the maintenance window.
         * </p>
         * 
         * @param start
         *        The start time of the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Instant start);

        /**
         * <p>
         * The end time of the maintenance window.
         * </p>
         * 
         * @param end
         *        The end time of the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Instant end);

        /**
         * <p>
         * The date and time when the maintenance window is scheduled to occur.
         * </p>
         * 
         * @param scheduledTime
         *        The date and time when the maintenance window is scheduled to occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledTime(Instant scheduledTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant start;

        private Instant end;

        private Instant scheduledTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WindowMaintenanceSchedule model) {
            start(model.start);
            end(model.end);
            scheduledTime(model.scheduledTime);
        }

        public final Instant getStart() {
            return start;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final Instant getEnd() {
            return end;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final Instant getScheduledTime() {
            return scheduledTime;
        }

        public final void setScheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        @Override
        public final Builder scheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
            return this;
        }

        @Override
        public WindowMaintenanceSchedule build() {
            return new WindowMaintenanceSchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
