/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRouterNetworkInterfaceRequest extends MediaConnectRequest implements
        ToCopyableBuilder<UpdateRouterNetworkInterfaceRequest.Builder, UpdateRouterNetworkInterfaceRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateRouterNetworkInterfaceRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateRouterNetworkInterfaceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<RouterNetworkInterfaceConfiguration> CONFIGURATION_FIELD = SdkField
            .<RouterNetworkInterfaceConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(UpdateRouterNetworkInterfaceRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(RouterNetworkInterfaceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final RouterNetworkInterfaceConfiguration configuration;

    private UpdateRouterNetworkInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the router network interface that you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the router network interface that you want to update.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The updated name for the router network interface.
     * </p>
     * 
     * @return The updated name for the router network interface.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The updated configuration settings for the router network interface. Changing the type of the configuration is
     * not supported.
     * </p>
     * 
     * @return The updated configuration settings for the router network interface. Changing the type of the
     *         configuration is not supported.
     */
    public final RouterNetworkInterfaceConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRouterNetworkInterfaceRequest)) {
            return false;
        }
        UpdateRouterNetworkInterfaceRequest other = (UpdateRouterNetworkInterfaceRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRouterNetworkInterfaceRequest").add("Arn", arn()).add("Name", name())
                .add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRouterNetworkInterfaceRequest, T> g) {
        return obj -> g.apply((UpdateRouterNetworkInterfaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRouterNetworkInterfaceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the router network interface that you want to update.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the router network interface that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The updated name for the router network interface.
         * </p>
         * 
         * @param name
         *        The updated name for the router network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated configuration settings for the router network interface. Changing the type of the configuration
         * is not supported.
         * </p>
         * 
         * @param configuration
         *        The updated configuration settings for the router network interface. Changing the type of the
         *        configuration is not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(RouterNetworkInterfaceConfiguration configuration);

        /**
         * <p>
         * The updated configuration settings for the router network interface. Changing the type of the configuration
         * is not supported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RouterNetworkInterfaceConfiguration.Builder} avoiding the need to create one manually via
         * {@link RouterNetworkInterfaceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouterNetworkInterfaceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(RouterNetworkInterfaceConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link RouterNetworkInterfaceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(RouterNetworkInterfaceConfiguration)
         */
        default Builder configuration(Consumer<RouterNetworkInterfaceConfiguration.Builder> configuration) {
            return configuration(RouterNetworkInterfaceConfiguration.builder().applyMutation(configuration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private RouterNetworkInterfaceConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRouterNetworkInterfaceRequest model) {
            super(model);
            arn(model.arn);
            name(model.name);
            configuration(model.configuration);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RouterNetworkInterfaceConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(RouterNetworkInterfaceConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RouterNetworkInterfaceConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRouterNetworkInterfaceRequest build() {
            return new UpdateRouterNetworkInterfaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
