/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFlowRequest extends MediaConnectRequest implements
        ToCopyableBuilder<UpdateFlowRequest.Builder, UpdateFlowRequest> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(UpdateFlowRequest::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FlowArn").build()).build();

    private static final SdkField<UpdateFailoverConfig> SOURCE_FAILOVER_CONFIG_FIELD = SdkField
            .<UpdateFailoverConfig> builder(MarshallingType.SDK_POJO).memberName("SourceFailoverConfig")
            .getter(getter(UpdateFlowRequest::sourceFailoverConfig)).setter(setter(Builder::sourceFailoverConfig))
            .constructor(UpdateFailoverConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFailoverConfig").build())
            .build();

    private static final SdkField<UpdateMaintenance> MAINTENANCE_FIELD = SdkField
            .<UpdateMaintenance> builder(MarshallingType.SDK_POJO).memberName("Maintenance")
            .getter(getter(UpdateFlowRequest::maintenance)).setter(setter(Builder::maintenance))
            .constructor(UpdateMaintenance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenance").build()).build();

    private static final SdkField<MonitoringConfig> SOURCE_MONITORING_CONFIG_FIELD = SdkField
            .<MonitoringConfig> builder(MarshallingType.SDK_POJO).memberName("SourceMonitoringConfig")
            .getter(getter(UpdateFlowRequest::sourceMonitoringConfig)).setter(setter(Builder::sourceMonitoringConfig))
            .constructor(MonitoringConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceMonitoringConfig").build())
            .build();

    private static final SdkField<NdiConfig> NDI_CONFIG_FIELD = SdkField.<NdiConfig> builder(MarshallingType.SDK_POJO)
            .memberName("NdiConfig").getter(getter(UpdateFlowRequest::ndiConfig)).setter(setter(Builder::ndiConfig))
            .constructor(NdiConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ndiConfig").build()).build();

    private static final SdkField<String> FLOW_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowSize").getter(getter(UpdateFlowRequest::flowSizeAsString)).setter(setter(Builder::flowSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            SOURCE_FAILOVER_CONFIG_FIELD, MAINTENANCE_FIELD, SOURCE_MONITORING_CONFIG_FIELD, NDI_CONFIG_FIELD, FLOW_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String flowArn;

    private final UpdateFailoverConfig sourceFailoverConfig;

    private final UpdateMaintenance maintenance;

    private final MonitoringConfig sourceMonitoringConfig;

    private final NdiConfig ndiConfig;

    private final String flowSize;

    private UpdateFlowRequest(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.sourceFailoverConfig = builder.sourceFailoverConfig;
        this.maintenance = builder.maintenance;
        this.sourceMonitoringConfig = builder.sourceMonitoringConfig;
        this.ndiConfig = builder.ndiConfig;
        this.flowSize = builder.flowSize;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow that you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow that you want to update.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * <p>
     * The settings for source failover.
     * </p>
     * 
     * @return The settings for source failover.
     */
    public final UpdateFailoverConfig sourceFailoverConfig() {
        return sourceFailoverConfig;
    }

    /**
     * <p>
     * The maintenance setting of the flow.
     * </p>
     * 
     * @return The maintenance setting of the flow.
     */
    public final UpdateMaintenance maintenance() {
        return maintenance;
    }

    /**
     * <p>
     * The settings for source monitoring.
     * </p>
     * 
     * @return The settings for source monitoring.
     */
    public final MonitoringConfig sourceMonitoringConfig() {
        return sourceMonitoringConfig;
    }

    /**
     * <p>
     * Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
     * </p>
     * 
     * @return Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
     */
    public final NdiConfig ndiConfig() {
        return ndiConfig;
    }

    /**
     * <p>
     * Determines the processing capacity and feature set of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flowSize} will
     * return {@link FlowSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flowSizeAsString}.
     * </p>
     * 
     * @return Determines the processing capacity and feature set of the flow.
     * @see FlowSize
     */
    public final FlowSize flowSize() {
        return FlowSize.fromValue(flowSize);
    }

    /**
     * <p>
     * Determines the processing capacity and feature set of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flowSize} will
     * return {@link FlowSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flowSizeAsString}.
     * </p>
     * 
     * @return Determines the processing capacity and feature set of the flow.
     * @see FlowSize
     */
    public final String flowSizeAsString() {
        return flowSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFailoverConfig());
        hashCode = 31 * hashCode + Objects.hashCode(maintenance());
        hashCode = 31 * hashCode + Objects.hashCode(sourceMonitoringConfig());
        hashCode = 31 * hashCode + Objects.hashCode(ndiConfig());
        hashCode = 31 * hashCode + Objects.hashCode(flowSizeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowRequest)) {
            return false;
        }
        UpdateFlowRequest other = (UpdateFlowRequest) obj;
        return Objects.equals(flowArn(), other.flowArn()) && Objects.equals(sourceFailoverConfig(), other.sourceFailoverConfig())
                && Objects.equals(maintenance(), other.maintenance())
                && Objects.equals(sourceMonitoringConfig(), other.sourceMonitoringConfig())
                && Objects.equals(ndiConfig(), other.ndiConfig()) && Objects.equals(flowSizeAsString(), other.flowSizeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFlowRequest").add("FlowArn", flowArn())
                .add("SourceFailoverConfig", sourceFailoverConfig()).add("Maintenance", maintenance())
                .add("SourceMonitoringConfig", sourceMonitoringConfig()).add("NdiConfig", ndiConfig())
                .add("FlowSize", flowSizeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "SourceFailoverConfig":
            return Optional.ofNullable(clazz.cast(sourceFailoverConfig()));
        case "Maintenance":
            return Optional.ofNullable(clazz.cast(maintenance()));
        case "SourceMonitoringConfig":
            return Optional.ofNullable(clazz.cast(sourceMonitoringConfig()));
        case "NdiConfig":
            return Optional.ofNullable(clazz.cast(ndiConfig()));
        case "FlowSize":
            return Optional.ofNullable(clazz.cast(flowSizeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FlowArn", FLOW_ARN_FIELD);
        map.put("sourceFailoverConfig", SOURCE_FAILOVER_CONFIG_FIELD);
        map.put("maintenance", MAINTENANCE_FIELD);
        map.put("sourceMonitoringConfig", SOURCE_MONITORING_CONFIG_FIELD);
        map.put("ndiConfig", NDI_CONFIG_FIELD);
        map.put("flowSize", FLOW_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowRequest, T> g) {
        return obj -> g.apply((UpdateFlowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFlowRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow that you want to update.
         * </p>
         * 
         * @param flowArn
         *        The Amazon Resource Name (ARN) of the flow that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * <p>
         * The settings for source failover.
         * </p>
         * 
         * @param sourceFailoverConfig
         *        The settings for source failover.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFailoverConfig(UpdateFailoverConfig sourceFailoverConfig);

        /**
         * <p>
         * The settings for source failover.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateFailoverConfig.Builder} avoiding
         * the need to create one manually via {@link UpdateFailoverConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateFailoverConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceFailoverConfig(UpdateFailoverConfig)}.
         * 
         * @param sourceFailoverConfig
         *        a consumer that will call methods on {@link UpdateFailoverConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceFailoverConfig(UpdateFailoverConfig)
         */
        default Builder sourceFailoverConfig(Consumer<UpdateFailoverConfig.Builder> sourceFailoverConfig) {
            return sourceFailoverConfig(UpdateFailoverConfig.builder().applyMutation(sourceFailoverConfig).build());
        }

        /**
         * <p>
         * The maintenance setting of the flow.
         * </p>
         * 
         * @param maintenance
         *        The maintenance setting of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenance(UpdateMaintenance maintenance);

        /**
         * <p>
         * The maintenance setting of the flow.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateMaintenance.Builder} avoiding the
         * need to create one manually via {@link UpdateMaintenance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateMaintenance.Builder#build()} is called immediately and its
         * result is passed to {@link #maintenance(UpdateMaintenance)}.
         * 
         * @param maintenance
         *        a consumer that will call methods on {@link UpdateMaintenance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenance(UpdateMaintenance)
         */
        default Builder maintenance(Consumer<UpdateMaintenance.Builder> maintenance) {
            return maintenance(UpdateMaintenance.builder().applyMutation(maintenance).build());
        }

        /**
         * <p>
         * The settings for source monitoring.
         * </p>
         * 
         * @param sourceMonitoringConfig
         *        The settings for source monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceMonitoringConfig(MonitoringConfig sourceMonitoringConfig);

        /**
         * <p>
         * The settings for source monitoring.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringConfig.Builder} avoiding the
         * need to create one manually via {@link MonitoringConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceMonitoringConfig(MonitoringConfig)}.
         * 
         * @param sourceMonitoringConfig
         *        a consumer that will call methods on {@link MonitoringConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceMonitoringConfig(MonitoringConfig)
         */
        default Builder sourceMonitoringConfig(Consumer<MonitoringConfig.Builder> sourceMonitoringConfig) {
            return sourceMonitoringConfig(MonitoringConfig.builder().applyMutation(sourceMonitoringConfig).build());
        }

        /**
         * <p>
         * Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
         * </p>
         * 
         * @param ndiConfig
         *        Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ndiConfig(NdiConfig ndiConfig);

        /**
         * <p>
         * Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
         * </p>
         * This is a convenience method that creates an instance of the {@link NdiConfig.Builder} avoiding the need to
         * create one manually via {@link NdiConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NdiConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #ndiConfig(NdiConfig)}.
         * 
         * @param ndiConfig
         *        a consumer that will call methods on {@link NdiConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ndiConfig(NdiConfig)
         */
        default Builder ndiConfig(Consumer<NdiConfig.Builder> ndiConfig) {
            return ndiConfig(NdiConfig.builder().applyMutation(ndiConfig).build());
        }

        /**
         * <p>
         * Determines the processing capacity and feature set of the flow.
         * </p>
         * 
         * @param flowSize
         *        Determines the processing capacity and feature set of the flow.
         * @see FlowSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowSize
         */
        Builder flowSize(String flowSize);

        /**
         * <p>
         * Determines the processing capacity and feature set of the flow.
         * </p>
         * 
         * @param flowSize
         *        Determines the processing capacity and feature set of the flow.
         * @see FlowSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowSize
         */
        Builder flowSize(FlowSize flowSize);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private String flowArn;

        private UpdateFailoverConfig sourceFailoverConfig;

        private UpdateMaintenance maintenance;

        private MonitoringConfig sourceMonitoringConfig;

        private NdiConfig ndiConfig;

        private String flowSize;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowRequest model) {
            super(model);
            flowArn(model.flowArn);
            sourceFailoverConfig(model.sourceFailoverConfig);
            maintenance(model.maintenance);
            sourceMonitoringConfig(model.sourceMonitoringConfig);
            ndiConfig(model.ndiConfig);
            flowSize(model.flowSize);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final UpdateFailoverConfig.Builder getSourceFailoverConfig() {
            return sourceFailoverConfig != null ? sourceFailoverConfig.toBuilder() : null;
        }

        public final void setSourceFailoverConfig(UpdateFailoverConfig.BuilderImpl sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig != null ? sourceFailoverConfig.build() : null;
        }

        @Override
        public final Builder sourceFailoverConfig(UpdateFailoverConfig sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        public final UpdateMaintenance.Builder getMaintenance() {
            return maintenance != null ? maintenance.toBuilder() : null;
        }

        public final void setMaintenance(UpdateMaintenance.BuilderImpl maintenance) {
            this.maintenance = maintenance != null ? maintenance.build() : null;
        }

        @Override
        public final Builder maintenance(UpdateMaintenance maintenance) {
            this.maintenance = maintenance;
            return this;
        }

        public final MonitoringConfig.Builder getSourceMonitoringConfig() {
            return sourceMonitoringConfig != null ? sourceMonitoringConfig.toBuilder() : null;
        }

        public final void setSourceMonitoringConfig(MonitoringConfig.BuilderImpl sourceMonitoringConfig) {
            this.sourceMonitoringConfig = sourceMonitoringConfig != null ? sourceMonitoringConfig.build() : null;
        }

        @Override
        public final Builder sourceMonitoringConfig(MonitoringConfig sourceMonitoringConfig) {
            this.sourceMonitoringConfig = sourceMonitoringConfig;
            return this;
        }

        public final NdiConfig.Builder getNdiConfig() {
            return ndiConfig != null ? ndiConfig.toBuilder() : null;
        }

        public final void setNdiConfig(NdiConfig.BuilderImpl ndiConfig) {
            this.ndiConfig = ndiConfig != null ? ndiConfig.build() : null;
        }

        @Override
        public final Builder ndiConfig(NdiConfig ndiConfig) {
            this.ndiConfig = ndiConfig;
            return this;
        }

        public final String getFlowSize() {
            return flowSize;
        }

        public final void setFlowSize(String flowSize) {
            this.flowSize = flowSize;
        }

        @Override
        public final Builder flowSize(String flowSize) {
            this.flowSize = flowSize;
            return this;
        }

        @Override
        public final Builder flowSize(FlowSize flowSize) {
            this.flowSize(flowSize == null ? null : flowSize.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowRequest build() {
            return new UpdateFlowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
