/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for a router output using the RTP (Real-Time Transport Protocol) protocol, including the
 * destination address and port, and forward error correction state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RtpRouterOutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RtpRouterOutputConfiguration.Builder, RtpRouterOutputConfiguration> {
    private static final SdkField<String> DESTINATION_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationAddress").getter(getter(RtpRouterOutputConfiguration::destinationAddress))
            .setter(setter(Builder::destinationAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationAddress").build())
            .build();

    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DestinationPort").getter(getter(RtpRouterOutputConfiguration::destinationPort))
            .setter(setter(Builder::destinationPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPort").build()).build();

    private static final SdkField<String> FORWARD_ERROR_CORRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForwardErrorCorrection").getter(getter(RtpRouterOutputConfiguration::forwardErrorCorrectionAsString))
            .setter(setter(Builder::forwardErrorCorrection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forwardErrorCorrection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_ADDRESS_FIELD,
            DESTINATION_PORT_FIELD, FORWARD_ERROR_CORRECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationAddress;

    private final Integer destinationPort;

    private final String forwardErrorCorrection;

    private RtpRouterOutputConfiguration(BuilderImpl builder) {
        this.destinationAddress = builder.destinationAddress;
        this.destinationPort = builder.destinationPort;
        this.forwardErrorCorrection = builder.forwardErrorCorrection;
    }

    /**
     * <p>
     * The destination IP address for the RTP protocol in the router output configuration.
     * </p>
     * 
     * @return The destination IP address for the RTP protocol in the router output configuration.
     */
    public final String destinationAddress() {
        return destinationAddress;
    }

    /**
     * <p>
     * The destination port number for the RTP protocol in the router output configuration.
     * </p>
     * 
     * @return The destination port number for the RTP protocol in the router output configuration.
     */
    public final Integer destinationPort() {
        return destinationPort;
    }

    /**
     * <p>
     * The state of forward error correction for the RTP protocol in the router output configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #forwardErrorCorrection} will return {@link ForwardErrorCorrectionState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #forwardErrorCorrectionAsString}.
     * </p>
     * 
     * @return The state of forward error correction for the RTP protocol in the router output configuration.
     * @see ForwardErrorCorrectionState
     */
    public final ForwardErrorCorrectionState forwardErrorCorrection() {
        return ForwardErrorCorrectionState.fromValue(forwardErrorCorrection);
    }

    /**
     * <p>
     * The state of forward error correction for the RTP protocol in the router output configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #forwardErrorCorrection} will return {@link ForwardErrorCorrectionState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #forwardErrorCorrectionAsString}.
     * </p>
     * 
     * @return The state of forward error correction for the RTP protocol in the router output configuration.
     * @see ForwardErrorCorrectionState
     */
    public final String forwardErrorCorrectionAsString() {
        return forwardErrorCorrection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationAddress());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(forwardErrorCorrectionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RtpRouterOutputConfiguration)) {
            return false;
        }
        RtpRouterOutputConfiguration other = (RtpRouterOutputConfiguration) obj;
        return Objects.equals(destinationAddress(), other.destinationAddress())
                && Objects.equals(destinationPort(), other.destinationPort())
                && Objects.equals(forwardErrorCorrectionAsString(), other.forwardErrorCorrectionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RtpRouterOutputConfiguration").add("DestinationAddress", destinationAddress())
                .add("DestinationPort", destinationPort()).add("ForwardErrorCorrection", forwardErrorCorrectionAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationAddress":
            return Optional.ofNullable(clazz.cast(destinationAddress()));
        case "DestinationPort":
            return Optional.ofNullable(clazz.cast(destinationPort()));
        case "ForwardErrorCorrection":
            return Optional.ofNullable(clazz.cast(forwardErrorCorrectionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinationAddress", DESTINATION_ADDRESS_FIELD);
        map.put("destinationPort", DESTINATION_PORT_FIELD);
        map.put("forwardErrorCorrection", FORWARD_ERROR_CORRECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RtpRouterOutputConfiguration, T> g) {
        return obj -> g.apply((RtpRouterOutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RtpRouterOutputConfiguration> {
        /**
         * <p>
         * The destination IP address for the RTP protocol in the router output configuration.
         * </p>
         * 
         * @param destinationAddress
         *        The destination IP address for the RTP protocol in the router output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAddress(String destinationAddress);

        /**
         * <p>
         * The destination port number for the RTP protocol in the router output configuration.
         * </p>
         * 
         * @param destinationPort
         *        The destination port number for the RTP protocol in the router output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPort(Integer destinationPort);

        /**
         * <p>
         * The state of forward error correction for the RTP protocol in the router output configuration.
         * </p>
         * 
         * @param forwardErrorCorrection
         *        The state of forward error correction for the RTP protocol in the router output configuration.
         * @see ForwardErrorCorrectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ForwardErrorCorrectionState
         */
        Builder forwardErrorCorrection(String forwardErrorCorrection);

        /**
         * <p>
         * The state of forward error correction for the RTP protocol in the router output configuration.
         * </p>
         * 
         * @param forwardErrorCorrection
         *        The state of forward error correction for the RTP protocol in the router output configuration.
         * @see ForwardErrorCorrectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ForwardErrorCorrectionState
         */
        Builder forwardErrorCorrection(ForwardErrorCorrectionState forwardErrorCorrection);
    }

    static final class BuilderImpl implements Builder {
        private String destinationAddress;

        private Integer destinationPort;

        private String forwardErrorCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(RtpRouterOutputConfiguration model) {
            destinationAddress(model.destinationAddress);
            destinationPort(model.destinationPort);
            forwardErrorCorrection(model.forwardErrorCorrection);
        }

        public final String getDestinationAddress() {
            return destinationAddress;
        }

        public final void setDestinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
        }

        @Override
        public final Builder destinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
            return this;
        }

        public final Integer getDestinationPort() {
            return destinationPort;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final String getForwardErrorCorrection() {
            return forwardErrorCorrection;
        }

        public final void setForwardErrorCorrection(String forwardErrorCorrection) {
            this.forwardErrorCorrection = forwardErrorCorrection;
        }

        @Override
        public final Builder forwardErrorCorrection(String forwardErrorCorrection) {
            this.forwardErrorCorrection = forwardErrorCorrection;
            return this;
        }

        @Override
        public final Builder forwardErrorCorrection(ForwardErrorCorrectionState forwardErrorCorrection) {
            this.forwardErrorCorrection(forwardErrorCorrection == null ? null : forwardErrorCorrection.toString());
            return this;
        }

        @Override
        public RtpRouterOutputConfiguration build() {
            return new RtpRouterOutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
