/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter that can be used to retrieve a list of router outputs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouterOutputFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<RouterOutputFilter.Builder, RouterOutputFilter> {
    private static final SdkField<List<String>> REGION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RegionNames")
            .getter(getter(RouterOutputFilter::regionNames))
            .setter(setter(Builder::regionNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OUTPUT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OutputTypes")
            .getter(getter(RouterOutputFilter::outputTypesAsStrings))
            .setter(setter(Builder::outputTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NAME_CONTAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NameContains")
            .getter(getter(RouterOutputFilter::nameContains))
            .setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nameContains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NETWORK_INTERFACE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NetworkInterfaceArns")
            .getter(getter(RouterOutputFilter::networkInterfaceArns))
            .setter(setter(Builder::networkInterfaceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ROUTED_INPUT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RoutedInputArns")
            .getter(getter(RouterOutputFilter::routedInputArns))
            .setter(setter(Builder::routedInputArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routedInputArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ROUTING_SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RoutingScopes")
            .getter(getter(RouterOutputFilter::routingScopesAsStrings))
            .setter(setter(Builder::routingScopesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingScopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(REGION_NAMES_FIELD, OUTPUT_TYPES_FIELD, NAME_CONTAINS_FIELD,
                    NETWORK_INTERFACE_ARNS_FIELD, ROUTED_INPUT_ARNS_FIELD, ROUTING_SCOPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> regionNames;

    private final List<String> outputTypes;

    private final List<String> nameContains;

    private final List<String> networkInterfaceArns;

    private final List<String> routedInputArns;

    private final List<String> routingScopes;

    private final Type type;

    private RouterOutputFilter(BuilderImpl builder) {
        this.regionNames = builder.regionNames;
        this.outputTypes = builder.outputTypes;
        this.nameContains = builder.nameContains;
        this.networkInterfaceArns = builder.networkInterfaceArns;
        this.routedInputArns = builder.routedInputArns;
        this.routingScopes = builder.routingScopes;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegionNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRegionNames() {
        return regionNames != null && !(regionNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS Regions of the router outputs to include in the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegionNames} method.
     * </p>
     * 
     * @return The AWS Regions of the router outputs to include in the filter.
     */
    public final List<String> regionNames() {
        return regionNames;
    }

    /**
     * <p>
     * The types of router outputs to include in the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputTypes} method.
     * </p>
     * 
     * @return The types of router outputs to include in the filter.
     */
    public final List<RouterOutputType> outputTypes() {
        return RouterOutputTypeListCopier.copyStringToEnum(outputTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputTypes() {
        return outputTypes != null && !(outputTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of router outputs to include in the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputTypes} method.
     * </p>
     * 
     * @return The types of router outputs to include in the filter.
     */
    public final List<String> outputTypesAsStrings() {
        return outputTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the NameContains property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNameContains() {
        return nameContains != null && !(nameContains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the router outputs to include in the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNameContains} method.
     * </p>
     * 
     * @return The names of the router outputs to include in the filter.
     */
    public final List<String> nameContains() {
        return nameContains;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfaceArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkInterfaceArns() {
        return networkInterfaceArns != null && !(networkInterfaceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the network interfaces associated with the router outputs to include in the
     * filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfaceArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the network interfaces associated with the router outputs to include
     *         in the filter.
     */
    public final List<String> networkInterfaceArns() {
        return networkInterfaceArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoutedInputArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoutedInputArns() {
        return routedInputArns != null && !(routedInputArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the router inputs associated with the router outputs to include in the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutedInputArns} method.
     * </p>
     * 
     * @return The ARNs of the router inputs associated with the router outputs to include in the filter.
     */
    public final List<String> routedInputArns() {
        return routedInputArns;
    }

    /**
     * <p>
     * Filter criteria to list router outputs based on their routing scope.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutingScopes} method.
     * </p>
     * 
     * @return Filter criteria to list router outputs based on their routing scope.
     */
    public final List<RoutingScope> routingScopes() {
        return RoutingScopeListCopier.copyStringToEnum(routingScopes);
    }

    /**
     * For responses, this returns true if the service returned a value for the RoutingScopes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoutingScopes() {
        return routingScopes != null && !(routingScopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter criteria to list router outputs based on their routing scope.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutingScopes} method.
     * </p>
     * 
     * @return Filter criteria to list router outputs based on their routing scope.
     */
    public final List<String> routingScopesAsStrings() {
        return routingScopes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionNames() ? regionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputTypes() ? outputTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNameContains() ? nameContains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaceArns() ? networkInterfaceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutedInputArns() ? routedInputArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutingScopes() ? routingScopesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterOutputFilter)) {
            return false;
        }
        RouterOutputFilter other = (RouterOutputFilter) obj;
        return hasRegionNames() == other.hasRegionNames() && Objects.equals(regionNames(), other.regionNames())
                && hasOutputTypes() == other.hasOutputTypes()
                && Objects.equals(outputTypesAsStrings(), other.outputTypesAsStrings())
                && hasNameContains() == other.hasNameContains() && Objects.equals(nameContains(), other.nameContains())
                && hasNetworkInterfaceArns() == other.hasNetworkInterfaceArns()
                && Objects.equals(networkInterfaceArns(), other.networkInterfaceArns())
                && hasRoutedInputArns() == other.hasRoutedInputArns()
                && Objects.equals(routedInputArns(), other.routedInputArns()) && hasRoutingScopes() == other.hasRoutingScopes()
                && Objects.equals(routingScopesAsStrings(), other.routingScopesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouterOutputFilter").add("RegionNames", hasRegionNames() ? regionNames() : null)
                .add("OutputTypes", hasOutputTypes() ? outputTypesAsStrings() : null)
                .add("NameContains", hasNameContains() ? nameContains() : null)
                .add("NetworkInterfaceArns", hasNetworkInterfaceArns() ? networkInterfaceArns() : null)
                .add("RoutedInputArns", hasRoutedInputArns() ? routedInputArns() : null)
                .add("RoutingScopes", hasRoutingScopes() ? routingScopesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionNames":
            return Optional.ofNullable(clazz.cast(regionNames()));
        case "OutputTypes":
            return Optional.ofNullable(clazz.cast(outputTypesAsStrings()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "NetworkInterfaceArns":
            return Optional.ofNullable(clazz.cast(networkInterfaceArns()));
        case "RoutedInputArns":
            return Optional.ofNullable(clazz.cast(routedInputArns()));
        case "RoutingScopes":
            return Optional.ofNullable(clazz.cast(routingScopesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #regionNames()} initialized to the given value.
     *
     * <p>
     * The AWS Regions of the router outputs to include in the filter.
     * </p>
     * 
     * @param regionNames
     *        The AWS Regions of the router outputs to include in the filter.
     */
    public static RouterOutputFilter fromRegionNames(List<String> regionNames) {
        return builder().regionNames(regionNames).build();
    }

    /**
     * Create an instance of this class with {@link #outputTypesAsStrings()} initialized to the given value.
     *
     * <p>
     * The types of router outputs to include in the filter.
     * </p>
     * 
     * @param outputTypes
     *        The types of router outputs to include in the filter.
     */
    public static RouterOutputFilter fromOutputTypesWithStrings(List<String> outputTypesWithStrings) {
        return builder().outputTypesWithStrings(outputTypesWithStrings).build();
    }

    /**
     * Create an instance of this class with {@link #outputTypesAsStrings()} initialized to the given value.
     *
     * <p>
     * The types of router outputs to include in the filter.
     * </p>
     * 
     * @param outputTypes
     *        The types of router outputs to include in the filter.
     */
    public static RouterOutputFilter fromOutputTypes(List<RouterOutputType> outputTypesWithStrings) {
        return builder().outputTypes(outputTypesWithStrings).build();
    }

    /**
     * Create an instance of this class with {@link #nameContains()} initialized to the given value.
     *
     * <p>
     * The names of the router outputs to include in the filter.
     * </p>
     * 
     * @param nameContains
     *        The names of the router outputs to include in the filter.
     */
    public static RouterOutputFilter fromNameContains(List<String> nameContains) {
        return builder().nameContains(nameContains).build();
    }

    /**
     * Create an instance of this class with {@link #networkInterfaceArns()} initialized to the given value.
     *
     * <p>
     * The Amazon Resource Names (ARNs) of the network interfaces associated with the router outputs to include in the
     * filter.
     * </p>
     * 
     * @param networkInterfaceArns
     *        The Amazon Resource Names (ARNs) of the network interfaces associated with the router outputs to include
     *        in the filter.
     */
    public static RouterOutputFilter fromNetworkInterfaceArns(List<String> networkInterfaceArns) {
        return builder().networkInterfaceArns(networkInterfaceArns).build();
    }

    /**
     * Create an instance of this class with {@link #routedInputArns()} initialized to the given value.
     *
     * <p>
     * The ARNs of the router inputs associated with the router outputs to include in the filter.
     * </p>
     * 
     * @param routedInputArns
     *        The ARNs of the router inputs associated with the router outputs to include in the filter.
     */
    public static RouterOutputFilter fromRoutedInputArns(List<String> routedInputArns) {
        return builder().routedInputArns(routedInputArns).build();
    }

    /**
     * Create an instance of this class with {@link #routingScopesAsStrings()} initialized to the given value.
     *
     * <p>
     * Filter criteria to list router outputs based on their routing scope.
     * </p>
     * 
     * @param routingScopes
     *        Filter criteria to list router outputs based on their routing scope.
     */
    public static RouterOutputFilter fromRoutingScopesWithStrings(List<String> routingScopesWithStrings) {
        return builder().routingScopesWithStrings(routingScopesWithStrings).build();
    }

    /**
     * Create an instance of this class with {@link #routingScopesAsStrings()} initialized to the given value.
     *
     * <p>
     * Filter criteria to list router outputs based on their routing scope.
     * </p>
     * 
     * @param routingScopes
     *        Filter criteria to list router outputs based on their routing scope.
     */
    public static RouterOutputFilter fromRoutingScopes(List<RoutingScope> routingScopesWithStrings) {
        return builder().routingScopes(routingScopesWithStrings).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("regionNames", REGION_NAMES_FIELD);
        map.put("outputTypes", OUTPUT_TYPES_FIELD);
        map.put("nameContains", NAME_CONTAINS_FIELD);
        map.put("networkInterfaceArns", NETWORK_INTERFACE_ARNS_FIELD);
        map.put("routedInputArns", ROUTED_INPUT_ARNS_FIELD);
        map.put("routingScopes", ROUTING_SCOPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterOutputFilter, T> g) {
        return obj -> g.apply((RouterOutputFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouterOutputFilter> {
        /**
         * <p>
         * The AWS Regions of the router outputs to include in the filter.
         * </p>
         * 
         * @param regionNames
         *        The AWS Regions of the router outputs to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionNames(Collection<String> regionNames);

        /**
         * <p>
         * The AWS Regions of the router outputs to include in the filter.
         * </p>
         * 
         * @param regionNames
         *        The AWS Regions of the router outputs to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionNames(String... regionNames);

        /**
         * <p>
         * The types of router outputs to include in the filter.
         * </p>
         * 
         * @param outputTypes
         *        The types of router outputs to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputTypesWithStrings(Collection<String> outputTypes);

        /**
         * <p>
         * The types of router outputs to include in the filter.
         * </p>
         * 
         * @param outputTypes
         *        The types of router outputs to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputTypesWithStrings(String... outputTypes);

        /**
         * <p>
         * The types of router outputs to include in the filter.
         * </p>
         * 
         * @param outputTypes
         *        The types of router outputs to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputTypes(Collection<RouterOutputType> outputTypes);

        /**
         * <p>
         * The types of router outputs to include in the filter.
         * </p>
         * 
         * @param outputTypes
         *        The types of router outputs to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputTypes(RouterOutputType... outputTypes);

        /**
         * <p>
         * The names of the router outputs to include in the filter.
         * </p>
         * 
         * @param nameContains
         *        The names of the router outputs to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(Collection<String> nameContains);

        /**
         * <p>
         * The names of the router outputs to include in the filter.
         * </p>
         * 
         * @param nameContains
         *        The names of the router outputs to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String... nameContains);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the network interfaces associated with the router outputs to include in
         * the filter.
         * </p>
         * 
         * @param networkInterfaceArns
         *        The Amazon Resource Names (ARNs) of the network interfaces associated with the router outputs to
         *        include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceArns(Collection<String> networkInterfaceArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the network interfaces associated with the router outputs to include in
         * the filter.
         * </p>
         * 
         * @param networkInterfaceArns
         *        The Amazon Resource Names (ARNs) of the network interfaces associated with the router outputs to
         *        include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceArns(String... networkInterfaceArns);

        /**
         * <p>
         * The ARNs of the router inputs associated with the router outputs to include in the filter.
         * </p>
         * 
         * @param routedInputArns
         *        The ARNs of the router inputs associated with the router outputs to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routedInputArns(Collection<String> routedInputArns);

        /**
         * <p>
         * The ARNs of the router inputs associated with the router outputs to include in the filter.
         * </p>
         * 
         * @param routedInputArns
         *        The ARNs of the router inputs associated with the router outputs to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routedInputArns(String... routedInputArns);

        /**
         * <p>
         * Filter criteria to list router outputs based on their routing scope.
         * </p>
         * 
         * @param routingScopes
         *        Filter criteria to list router outputs based on their routing scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingScopesWithStrings(Collection<String> routingScopes);

        /**
         * <p>
         * Filter criteria to list router outputs based on their routing scope.
         * </p>
         * 
         * @param routingScopes
         *        Filter criteria to list router outputs based on their routing scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingScopesWithStrings(String... routingScopes);

        /**
         * <p>
         * Filter criteria to list router outputs based on their routing scope.
         * </p>
         * 
         * @param routingScopes
         *        Filter criteria to list router outputs based on their routing scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingScopes(Collection<RoutingScope> routingScopes);

        /**
         * <p>
         * Filter criteria to list router outputs based on their routing scope.
         * </p>
         * 
         * @param routingScopes
         *        Filter criteria to list router outputs based on their routing scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingScopes(RoutingScope... routingScopes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> regionNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> outputTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> nameContains = DefaultSdkAutoConstructList.getInstance();

        private List<String> networkInterfaceArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> routedInputArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> routingScopes = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterOutputFilter model) {
            regionNames(model.regionNames);
            outputTypesWithStrings(model.outputTypes);
            nameContains(model.nameContains);
            networkInterfaceArns(model.networkInterfaceArns);
            routedInputArns(model.routedInputArns);
            routingScopesWithStrings(model.routingScopes);
        }

        public final Collection<String> getRegionNames() {
            if (regionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return regionNames;
        }

        public final void setRegionNames(Collection<String> regionNames) {
            Object oldValue = this.regionNames;
            this.regionNames = StringListCopier.copy(regionNames);
            handleUnionValueChange(Type.REGION_NAMES, oldValue, this.regionNames);
        }

        @Override
        public final Builder regionNames(Collection<String> regionNames) {
            Object oldValue = this.regionNames;
            this.regionNames = StringListCopier.copy(regionNames);
            handleUnionValueChange(Type.REGION_NAMES, oldValue, this.regionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionNames(String... regionNames) {
            regionNames(Arrays.asList(regionNames));
            return this;
        }

        public final Collection<String> getOutputTypes() {
            if (outputTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return outputTypes;
        }

        public final void setOutputTypes(Collection<String> outputTypes) {
            Object oldValue = this.outputTypes;
            this.outputTypes = RouterOutputTypeListCopier.copy(outputTypes);
            handleUnionValueChange(Type.OUTPUT_TYPES, oldValue, this.outputTypes);
        }

        @Override
        public final Builder outputTypesWithStrings(Collection<String> outputTypes) {
            Object oldValue = this.outputTypes;
            this.outputTypes = RouterOutputTypeListCopier.copy(outputTypes);
            handleUnionValueChange(Type.OUTPUT_TYPES, oldValue, this.outputTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputTypesWithStrings(String... outputTypes) {
            outputTypesWithStrings(Arrays.asList(outputTypes));
            return this;
        }

        @Override
        public final Builder outputTypes(Collection<RouterOutputType> outputTypes) {
            Object oldValue = this.outputTypes;
            this.outputTypes = RouterOutputTypeListCopier.copyEnumToString(outputTypes);
            handleUnionValueChange(Type.OUTPUT_TYPES, oldValue, this.outputTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputTypes(RouterOutputType... outputTypes) {
            outputTypes(Arrays.asList(outputTypes));
            return this;
        }

        public final Collection<String> getNameContains() {
            if (nameContains instanceof SdkAutoConstructList) {
                return null;
            }
            return nameContains;
        }

        public final void setNameContains(Collection<String> nameContains) {
            Object oldValue = this.nameContains;
            this.nameContains = StringListCopier.copy(nameContains);
            handleUnionValueChange(Type.NAME_CONTAINS, oldValue, this.nameContains);
        }

        @Override
        public final Builder nameContains(Collection<String> nameContains) {
            Object oldValue = this.nameContains;
            this.nameContains = StringListCopier.copy(nameContains);
            handleUnionValueChange(Type.NAME_CONTAINS, oldValue, this.nameContains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameContains(String... nameContains) {
            nameContains(Arrays.asList(nameContains));
            return this;
        }

        public final Collection<String> getNetworkInterfaceArns() {
            if (networkInterfaceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return networkInterfaceArns;
        }

        public final void setNetworkInterfaceArns(Collection<String> networkInterfaceArns) {
            Object oldValue = this.networkInterfaceArns;
            this.networkInterfaceArns = RouterNetworkInterfaceArnListCopier.copy(networkInterfaceArns);
            handleUnionValueChange(Type.NETWORK_INTERFACE_ARNS, oldValue, this.networkInterfaceArns);
        }

        @Override
        public final Builder networkInterfaceArns(Collection<String> networkInterfaceArns) {
            Object oldValue = this.networkInterfaceArns;
            this.networkInterfaceArns = RouterNetworkInterfaceArnListCopier.copy(networkInterfaceArns);
            handleUnionValueChange(Type.NETWORK_INTERFACE_ARNS, oldValue, this.networkInterfaceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceArns(String... networkInterfaceArns) {
            networkInterfaceArns(Arrays.asList(networkInterfaceArns));
            return this;
        }

        public final Collection<String> getRoutedInputArns() {
            if (routedInputArns instanceof SdkAutoConstructList) {
                return null;
            }
            return routedInputArns;
        }

        public final void setRoutedInputArns(Collection<String> routedInputArns) {
            Object oldValue = this.routedInputArns;
            this.routedInputArns = RouterInputArnListCopier.copy(routedInputArns);
            handleUnionValueChange(Type.ROUTED_INPUT_ARNS, oldValue, this.routedInputArns);
        }

        @Override
        public final Builder routedInputArns(Collection<String> routedInputArns) {
            Object oldValue = this.routedInputArns;
            this.routedInputArns = RouterInputArnListCopier.copy(routedInputArns);
            handleUnionValueChange(Type.ROUTED_INPUT_ARNS, oldValue, this.routedInputArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routedInputArns(String... routedInputArns) {
            routedInputArns(Arrays.asList(routedInputArns));
            return this;
        }

        public final Collection<String> getRoutingScopes() {
            if (routingScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return routingScopes;
        }

        public final void setRoutingScopes(Collection<String> routingScopes) {
            Object oldValue = this.routingScopes;
            this.routingScopes = RoutingScopeListCopier.copy(routingScopes);
            handleUnionValueChange(Type.ROUTING_SCOPES, oldValue, this.routingScopes);
        }

        @Override
        public final Builder routingScopesWithStrings(Collection<String> routingScopes) {
            Object oldValue = this.routingScopes;
            this.routingScopes = RoutingScopeListCopier.copy(routingScopes);
            handleUnionValueChange(Type.ROUTING_SCOPES, oldValue, this.routingScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingScopesWithStrings(String... routingScopes) {
            routingScopesWithStrings(Arrays.asList(routingScopes));
            return this;
        }

        @Override
        public final Builder routingScopes(Collection<RoutingScope> routingScopes) {
            Object oldValue = this.routingScopes;
            this.routingScopes = RoutingScopeListCopier.copyEnumToString(routingScopes);
            handleUnionValueChange(Type.ROUTING_SCOPES, oldValue, this.routingScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingScopes(RoutingScope... routingScopes) {
            routingScopes(Arrays.asList(routingScopes));
            return this;
        }

        @Override
        public RouterOutputFilter build() {
            return new RouterOutputFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RouterOutputFilter#type()
     */
    public enum Type {
        REGION_NAMES,

        OUTPUT_TYPES,

        NAME_CONTAINS,

        NETWORK_INTERFACE_ARNS,

        ROUTED_INPUT_ARNS,

        ROUTING_SCOPES,

        UNKNOWN_TO_SDK_VERSION
    }
}
