/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for a router output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouterOutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RouterOutputConfiguration.Builder, RouterOutputConfiguration> {
    private static final SdkField<StandardRouterOutputConfiguration> STANDARD_FIELD = SdkField
            .<StandardRouterOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("Standard")
            .getter(getter(RouterOutputConfiguration::standard)).setter(setter(Builder::standard))
            .constructor(StandardRouterOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standard").build()).build();

    private static final SdkField<MediaConnectFlowRouterOutputConfiguration> MEDIA_CONNECT_FLOW_FIELD = SdkField
            .<MediaConnectFlowRouterOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("MediaConnectFlow")
            .getter(getter(RouterOutputConfiguration::mediaConnectFlow)).setter(setter(Builder::mediaConnectFlow))
            .constructor(MediaConnectFlowRouterOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaConnectFlow").build()).build();

    private static final SdkField<MediaLiveInputRouterOutputConfiguration> MEDIA_LIVE_INPUT_FIELD = SdkField
            .<MediaLiveInputRouterOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("MediaLiveInput")
            .getter(getter(RouterOutputConfiguration::mediaLiveInput)).setter(setter(Builder::mediaLiveInput))
            .constructor(MediaLiveInputRouterOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaLiveInput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARD_FIELD,
            MEDIA_CONNECT_FLOW_FIELD, MEDIA_LIVE_INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StandardRouterOutputConfiguration standard;

    private final MediaConnectFlowRouterOutputConfiguration mediaConnectFlow;

    private final MediaLiveInputRouterOutputConfiguration mediaLiveInput;

    private final Type type;

    private RouterOutputConfiguration(BuilderImpl builder) {
        this.standard = builder.standard;
        this.mediaConnectFlow = builder.mediaConnectFlow;
        this.mediaLiveInput = builder.mediaLiveInput;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Standard property for this object.
     * 
     * @return The value of the Standard property for this object.
     */
    public final StandardRouterOutputConfiguration standard() {
        return standard;
    }

    /**
     * Returns the value of the MediaConnectFlow property for this object.
     * 
     * @return The value of the MediaConnectFlow property for this object.
     */
    public final MediaConnectFlowRouterOutputConfiguration mediaConnectFlow() {
        return mediaConnectFlow;
    }

    /**
     * Returns the value of the MediaLiveInput property for this object.
     * 
     * @return The value of the MediaLiveInput property for this object.
     */
    public final MediaLiveInputRouterOutputConfiguration mediaLiveInput() {
        return mediaLiveInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(standard());
        hashCode = 31 * hashCode + Objects.hashCode(mediaConnectFlow());
        hashCode = 31 * hashCode + Objects.hashCode(mediaLiveInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterOutputConfiguration)) {
            return false;
        }
        RouterOutputConfiguration other = (RouterOutputConfiguration) obj;
        return Objects.equals(standard(), other.standard()) && Objects.equals(mediaConnectFlow(), other.mediaConnectFlow())
                && Objects.equals(mediaLiveInput(), other.mediaLiveInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouterOutputConfiguration").add("Standard", standard())
                .add("MediaConnectFlow", mediaConnectFlow()).add("MediaLiveInput", mediaLiveInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Standard":
            return Optional.ofNullable(clazz.cast(standard()));
        case "MediaConnectFlow":
            return Optional.ofNullable(clazz.cast(mediaConnectFlow()));
        case "MediaLiveInput":
            return Optional.ofNullable(clazz.cast(mediaLiveInput()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #standard()} initialized to the given value.
     *
     * Sets the value of the Standard property for this object.
     *
     * @param standard
     *        The new value for the Standard property for this object.
     */
    public static RouterOutputConfiguration fromStandard(StandardRouterOutputConfiguration standard) {
        return builder().standard(standard).build();
    }

    /**
     * Create an instance of this class with {@link #standard()} initialized to the given value.
     *
     * Sets the value of the Standard property for this object.
     *
     * @param standard
     *        The new value for the Standard property for this object.
     */
    public static RouterOutputConfiguration fromStandard(Consumer<StandardRouterOutputConfiguration.Builder> standard) {
        StandardRouterOutputConfiguration.Builder builder = StandardRouterOutputConfiguration.builder();
        standard.accept(builder);
        return fromStandard(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mediaConnectFlow()} initialized to the given value.
     *
     * Sets the value of the MediaConnectFlow property for this object.
     *
     * @param mediaConnectFlow
     *        The new value for the MediaConnectFlow property for this object.
     */
    public static RouterOutputConfiguration fromMediaConnectFlow(MediaConnectFlowRouterOutputConfiguration mediaConnectFlow) {
        return builder().mediaConnectFlow(mediaConnectFlow).build();
    }

    /**
     * Create an instance of this class with {@link #mediaConnectFlow()} initialized to the given value.
     *
     * Sets the value of the MediaConnectFlow property for this object.
     *
     * @param mediaConnectFlow
     *        The new value for the MediaConnectFlow property for this object.
     */
    public static RouterOutputConfiguration fromMediaConnectFlow(
            Consumer<MediaConnectFlowRouterOutputConfiguration.Builder> mediaConnectFlow) {
        MediaConnectFlowRouterOutputConfiguration.Builder builder = MediaConnectFlowRouterOutputConfiguration.builder();
        mediaConnectFlow.accept(builder);
        return fromMediaConnectFlow(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mediaLiveInput()} initialized to the given value.
     *
     * Sets the value of the MediaLiveInput property for this object.
     *
     * @param mediaLiveInput
     *        The new value for the MediaLiveInput property for this object.
     */
    public static RouterOutputConfiguration fromMediaLiveInput(MediaLiveInputRouterOutputConfiguration mediaLiveInput) {
        return builder().mediaLiveInput(mediaLiveInput).build();
    }

    /**
     * Create an instance of this class with {@link #mediaLiveInput()} initialized to the given value.
     *
     * Sets the value of the MediaLiveInput property for this object.
     *
     * @param mediaLiveInput
     *        The new value for the MediaLiveInput property for this object.
     */
    public static RouterOutputConfiguration fromMediaLiveInput(
            Consumer<MediaLiveInputRouterOutputConfiguration.Builder> mediaLiveInput) {
        MediaLiveInputRouterOutputConfiguration.Builder builder = MediaLiveInputRouterOutputConfiguration.builder();
        mediaLiveInput.accept(builder);
        return fromMediaLiveInput(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("standard", STANDARD_FIELD);
        map.put("mediaConnectFlow", MEDIA_CONNECT_FLOW_FIELD);
        map.put("mediaLiveInput", MEDIA_LIVE_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterOutputConfiguration, T> g) {
        return obj -> g.apply((RouterOutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouterOutputConfiguration> {
        /**
         * Sets the value of the Standard property for this object.
         *
         * @param standard
         *        The new value for the Standard property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standard(StandardRouterOutputConfiguration standard);

        /**
         * Sets the value of the Standard property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link StandardRouterOutputConfiguration.Builder} avoiding the need to create one manually via
         * {@link StandardRouterOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StandardRouterOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #standard(StandardRouterOutputConfiguration)}.
         * 
         * @param standard
         *        a consumer that will call methods on {@link StandardRouterOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standard(StandardRouterOutputConfiguration)
         */
        default Builder standard(Consumer<StandardRouterOutputConfiguration.Builder> standard) {
            return standard(StandardRouterOutputConfiguration.builder().applyMutation(standard).build());
        }

        /**
         * Sets the value of the MediaConnectFlow property for this object.
         *
         * @param mediaConnectFlow
         *        The new value for the MediaConnectFlow property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConnectFlow(MediaConnectFlowRouterOutputConfiguration mediaConnectFlow);

        /**
         * Sets the value of the MediaConnectFlow property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link MediaConnectFlowRouterOutputConfiguration.Builder} avoiding the need to create one manually via
         * {@link MediaConnectFlowRouterOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaConnectFlowRouterOutputConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #mediaConnectFlow(MediaConnectFlowRouterOutputConfiguration)}.
         * 
         * @param mediaConnectFlow
         *        a consumer that will call methods on {@link MediaConnectFlowRouterOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaConnectFlow(MediaConnectFlowRouterOutputConfiguration)
         */
        default Builder mediaConnectFlow(Consumer<MediaConnectFlowRouterOutputConfiguration.Builder> mediaConnectFlow) {
            return mediaConnectFlow(MediaConnectFlowRouterOutputConfiguration.builder().applyMutation(mediaConnectFlow).build());
        }

        /**
         * Sets the value of the MediaLiveInput property for this object.
         *
         * @param mediaLiveInput
         *        The new value for the MediaLiveInput property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaLiveInput(MediaLiveInputRouterOutputConfiguration mediaLiveInput);

        /**
         * Sets the value of the MediaLiveInput property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link MediaLiveInputRouterOutputConfiguration.Builder} avoiding the need to create one manually via
         * {@link MediaLiveInputRouterOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaLiveInputRouterOutputConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #mediaLiveInput(MediaLiveInputRouterOutputConfiguration)}.
         * 
         * @param mediaLiveInput
         *        a consumer that will call methods on {@link MediaLiveInputRouterOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaLiveInput(MediaLiveInputRouterOutputConfiguration)
         */
        default Builder mediaLiveInput(Consumer<MediaLiveInputRouterOutputConfiguration.Builder> mediaLiveInput) {
            return mediaLiveInput(MediaLiveInputRouterOutputConfiguration.builder().applyMutation(mediaLiveInput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StandardRouterOutputConfiguration standard;

        private MediaConnectFlowRouterOutputConfiguration mediaConnectFlow;

        private MediaLiveInputRouterOutputConfiguration mediaLiveInput;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterOutputConfiguration model) {
            standard(model.standard);
            mediaConnectFlow(model.mediaConnectFlow);
            mediaLiveInput(model.mediaLiveInput);
        }

        public final StandardRouterOutputConfiguration.Builder getStandard() {
            return standard != null ? standard.toBuilder() : null;
        }

        public final void setStandard(StandardRouterOutputConfiguration.BuilderImpl standard) {
            Object oldValue = this.standard;
            this.standard = standard != null ? standard.build() : null;
            handleUnionValueChange(Type.STANDARD, oldValue, this.standard);
        }

        @Override
        public final Builder standard(StandardRouterOutputConfiguration standard) {
            Object oldValue = this.standard;
            this.standard = standard;
            handleUnionValueChange(Type.STANDARD, oldValue, this.standard);
            return this;
        }

        public final MediaConnectFlowRouterOutputConfiguration.Builder getMediaConnectFlow() {
            return mediaConnectFlow != null ? mediaConnectFlow.toBuilder() : null;
        }

        public final void setMediaConnectFlow(MediaConnectFlowRouterOutputConfiguration.BuilderImpl mediaConnectFlow) {
            Object oldValue = this.mediaConnectFlow;
            this.mediaConnectFlow = mediaConnectFlow != null ? mediaConnectFlow.build() : null;
            handleUnionValueChange(Type.MEDIA_CONNECT_FLOW, oldValue, this.mediaConnectFlow);
        }

        @Override
        public final Builder mediaConnectFlow(MediaConnectFlowRouterOutputConfiguration mediaConnectFlow) {
            Object oldValue = this.mediaConnectFlow;
            this.mediaConnectFlow = mediaConnectFlow;
            handleUnionValueChange(Type.MEDIA_CONNECT_FLOW, oldValue, this.mediaConnectFlow);
            return this;
        }

        public final MediaLiveInputRouterOutputConfiguration.Builder getMediaLiveInput() {
            return mediaLiveInput != null ? mediaLiveInput.toBuilder() : null;
        }

        public final void setMediaLiveInput(MediaLiveInputRouterOutputConfiguration.BuilderImpl mediaLiveInput) {
            Object oldValue = this.mediaLiveInput;
            this.mediaLiveInput = mediaLiveInput != null ? mediaLiveInput.build() : null;
            handleUnionValueChange(Type.MEDIA_LIVE_INPUT, oldValue, this.mediaLiveInput);
        }

        @Override
        public final Builder mediaLiveInput(MediaLiveInputRouterOutputConfiguration mediaLiveInput) {
            Object oldValue = this.mediaLiveInput;
            this.mediaLiveInput = mediaLiveInput;
            handleUnionValueChange(Type.MEDIA_LIVE_INPUT, oldValue, this.mediaLiveInput);
            return this;
        }

        @Override
        public RouterOutputConfiguration build() {
            return new RouterOutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RouterOutputConfiguration#type()
     */
    public enum Type {
        STANDARD,

        MEDIA_CONNECT_FLOW,

        MEDIA_LIVE_INPUT,

        UNKNOWN_TO_SDK_VERSION
    }
}
