/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for a router network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouterNetworkInterfaceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RouterNetworkInterfaceConfiguration.Builder, RouterNetworkInterfaceConfiguration> {
    private static final SdkField<PublicRouterNetworkInterfaceConfiguration> PUBLIC_FIELD = SdkField
            .<PublicRouterNetworkInterfaceConfiguration> builder(MarshallingType.SDK_POJO).memberName("Public")
            .getter(getter(RouterNetworkInterfaceConfiguration::publicValue)).setter(setter(Builder::publicValue))
            .constructor(PublicRouterNetworkInterfaceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("public").build()).build();

    private static final SdkField<VpcRouterNetworkInterfaceConfiguration> VPC_FIELD = SdkField
            .<VpcRouterNetworkInterfaceConfiguration> builder(MarshallingType.SDK_POJO).memberName("Vpc")
            .getter(getter(RouterNetworkInterfaceConfiguration::vpc)).setter(setter(Builder::vpc))
            .constructor(VpcRouterNetworkInterfaceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_FIELD, VPC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PublicRouterNetworkInterfaceConfiguration publicValue;

    private final VpcRouterNetworkInterfaceConfiguration vpc;

    private final Type type;

    private RouterNetworkInterfaceConfiguration(BuilderImpl builder) {
        this.publicValue = builder.publicValue;
        this.vpc = builder.vpc;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Public property for this object.
     * 
     * @return The value of the Public property for this object.
     */
    public final PublicRouterNetworkInterfaceConfiguration publicValue() {
        return publicValue;
    }

    /**
     * Returns the value of the Vpc property for this object.
     * 
     * @return The value of the Vpc property for this object.
     */
    public final VpcRouterNetworkInterfaceConfiguration vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(publicValue());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterNetworkInterfaceConfiguration)) {
            return false;
        }
        RouterNetworkInterfaceConfiguration other = (RouterNetworkInterfaceConfiguration) obj;
        return Objects.equals(publicValue(), other.publicValue()) && Objects.equals(vpc(), other.vpc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouterNetworkInterfaceConfiguration").add("Public", publicValue()).add("Vpc", vpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Public":
            return Optional.ofNullable(clazz.cast(publicValue()));
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #publicValue()} initialized to the given value.
     *
     * Sets the value of the Public property for this object.
     *
     * @param publicValue
     *        The new value for the Public property for this object.
     */
    public static RouterNetworkInterfaceConfiguration fromPublicValue(PublicRouterNetworkInterfaceConfiguration publicValue) {
        return builder().publicValue(publicValue).build();
    }

    /**
     * Create an instance of this class with {@link #publicValue()} initialized to the given value.
     *
     * Sets the value of the Public property for this object.
     *
     * @param publicValue
     *        The new value for the Public property for this object.
     */
    public static RouterNetworkInterfaceConfiguration fromPublicValue(
            Consumer<PublicRouterNetworkInterfaceConfiguration.Builder> publicValue) {
        PublicRouterNetworkInterfaceConfiguration.Builder builder = PublicRouterNetworkInterfaceConfiguration.builder();
        publicValue.accept(builder);
        return fromPublicValue(builder.build());
    }

    /**
     * Create an instance of this class with {@link #vpc()} initialized to the given value.
     *
     * Sets the value of the Vpc property for this object.
     *
     * @param vpc
     *        The new value for the Vpc property for this object.
     */
    public static RouterNetworkInterfaceConfiguration fromVpc(VpcRouterNetworkInterfaceConfiguration vpc) {
        return builder().vpc(vpc).build();
    }

    /**
     * Create an instance of this class with {@link #vpc()} initialized to the given value.
     *
     * Sets the value of the Vpc property for this object.
     *
     * @param vpc
     *        The new value for the Vpc property for this object.
     */
    public static RouterNetworkInterfaceConfiguration fromVpc(Consumer<VpcRouterNetworkInterfaceConfiguration.Builder> vpc) {
        VpcRouterNetworkInterfaceConfiguration.Builder builder = VpcRouterNetworkInterfaceConfiguration.builder();
        vpc.accept(builder);
        return fromVpc(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("public", PUBLIC_FIELD);
        map.put("vpc", VPC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterNetworkInterfaceConfiguration, T> g) {
        return obj -> g.apply((RouterNetworkInterfaceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouterNetworkInterfaceConfiguration> {
        /**
         * Sets the value of the Public property for this object.
         *
         * @param publicValue
         *        The new value for the Public property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicValue(PublicRouterNetworkInterfaceConfiguration publicValue);

        /**
         * Sets the value of the Public property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link PublicRouterNetworkInterfaceConfiguration.Builder} avoiding the need to create one manually via
         * {@link PublicRouterNetworkInterfaceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PublicRouterNetworkInterfaceConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #publicValue(PublicRouterNetworkInterfaceConfiguration)}.
         * 
         * @param publicValue
         *        a consumer that will call methods on {@link PublicRouterNetworkInterfaceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicValue(PublicRouterNetworkInterfaceConfiguration)
         */
        default Builder publicValue(Consumer<PublicRouterNetworkInterfaceConfiguration.Builder> publicValue) {
            return publicValue(PublicRouterNetworkInterfaceConfiguration.builder().applyMutation(publicValue).build());
        }

        /**
         * Sets the value of the Vpc property for this object.
         *
         * @param vpc
         *        The new value for the Vpc property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(VpcRouterNetworkInterfaceConfiguration vpc);

        /**
         * Sets the value of the Vpc property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link VpcRouterNetworkInterfaceConfiguration.Builder} avoiding the need to create one manually via
         * {@link VpcRouterNetworkInterfaceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcRouterNetworkInterfaceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #vpc(VpcRouterNetworkInterfaceConfiguration)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link VpcRouterNetworkInterfaceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(VpcRouterNetworkInterfaceConfiguration)
         */
        default Builder vpc(Consumer<VpcRouterNetworkInterfaceConfiguration.Builder> vpc) {
            return vpc(VpcRouterNetworkInterfaceConfiguration.builder().applyMutation(vpc).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PublicRouterNetworkInterfaceConfiguration publicValue;

        private VpcRouterNetworkInterfaceConfiguration vpc;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterNetworkInterfaceConfiguration model) {
            publicValue(model.publicValue);
            vpc(model.vpc);
        }

        public final PublicRouterNetworkInterfaceConfiguration.Builder getPublicValue() {
            return publicValue != null ? publicValue.toBuilder() : null;
        }

        public final void setPublicValue(PublicRouterNetworkInterfaceConfiguration.BuilderImpl publicValue) {
            Object oldValue = this.publicValue;
            this.publicValue = publicValue != null ? publicValue.build() : null;
            handleUnionValueChange(Type.PUBLIC, oldValue, this.publicValue);
        }

        @Override
        public final Builder publicValue(PublicRouterNetworkInterfaceConfiguration publicValue) {
            Object oldValue = this.publicValue;
            this.publicValue = publicValue;
            handleUnionValueChange(Type.PUBLIC, oldValue, this.publicValue);
            return this;
        }

        public final VpcRouterNetworkInterfaceConfiguration.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        public final void setVpc(VpcRouterNetworkInterfaceConfiguration.BuilderImpl vpc) {
            Object oldValue = this.vpc;
            this.vpc = vpc != null ? vpc.build() : null;
            handleUnionValueChange(Type.VPC, oldValue, this.vpc);
        }

        @Override
        public final Builder vpc(VpcRouterNetworkInterfaceConfiguration vpc) {
            Object oldValue = this.vpc;
            this.vpc = vpc;
            handleUnionValueChange(Type.VPC, oldValue, this.vpc);
            return this;
        }

        @Override
        public RouterNetworkInterfaceConfiguration build() {
            return new RouterNetworkInterfaceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RouterNetworkInterfaceConfiguration#type()
     */
    public enum Type {
        PUBLIC,

        VPC,

        UNKNOWN_TO_SDK_VERSION
    }
}
