/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration details for the router input stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouterInputStreamDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RouterInputStreamDetails.Builder, RouterInputStreamDetails> {
    private static final SdkField<StandardRouterInputStreamDetails> STANDARD_FIELD = SdkField
            .<StandardRouterInputStreamDetails> builder(MarshallingType.SDK_POJO).memberName("Standard")
            .getter(getter(RouterInputStreamDetails::standard)).setter(setter(Builder::standard))
            .constructor(StandardRouterInputStreamDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standard").build()).build();

    private static final SdkField<FailoverRouterInputStreamDetails> FAILOVER_FIELD = SdkField
            .<FailoverRouterInputStreamDetails> builder(MarshallingType.SDK_POJO).memberName("Failover")
            .getter(getter(RouterInputStreamDetails::failover)).setter(setter(Builder::failover))
            .constructor(FailoverRouterInputStreamDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failover").build()).build();

    private static final SdkField<MergeRouterInputStreamDetails> MERGE_FIELD = SdkField
            .<MergeRouterInputStreamDetails> builder(MarshallingType.SDK_POJO).memberName("Merge")
            .getter(getter(RouterInputStreamDetails::merge)).setter(setter(Builder::merge))
            .constructor(MergeRouterInputStreamDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("merge").build()).build();

    private static final SdkField<MediaConnectFlowRouterInputStreamDetails> MEDIA_CONNECT_FLOW_FIELD = SdkField
            .<MediaConnectFlowRouterInputStreamDetails> builder(MarshallingType.SDK_POJO).memberName("MediaConnectFlow")
            .getter(getter(RouterInputStreamDetails::mediaConnectFlow)).setter(setter(Builder::mediaConnectFlow))
            .constructor(MediaConnectFlowRouterInputStreamDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaConnectFlow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARD_FIELD,
            FAILOVER_FIELD, MERGE_FIELD, MEDIA_CONNECT_FLOW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StandardRouterInputStreamDetails standard;

    private final FailoverRouterInputStreamDetails failover;

    private final MergeRouterInputStreamDetails merge;

    private final MediaConnectFlowRouterInputStreamDetails mediaConnectFlow;

    private final Type type;

    private RouterInputStreamDetails(BuilderImpl builder) {
        this.standard = builder.standard;
        this.failover = builder.failover;
        this.merge = builder.merge;
        this.mediaConnectFlow = builder.mediaConnectFlow;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Standard property for this object.
     * 
     * @return The value of the Standard property for this object.
     */
    public final StandardRouterInputStreamDetails standard() {
        return standard;
    }

    /**
     * Returns the value of the Failover property for this object.
     * 
     * @return The value of the Failover property for this object.
     */
    public final FailoverRouterInputStreamDetails failover() {
        return failover;
    }

    /**
     * Returns the value of the Merge property for this object.
     * 
     * @return The value of the Merge property for this object.
     */
    public final MergeRouterInputStreamDetails merge() {
        return merge;
    }

    /**
     * Returns the value of the MediaConnectFlow property for this object.
     * 
     * @return The value of the MediaConnectFlow property for this object.
     */
    public final MediaConnectFlowRouterInputStreamDetails mediaConnectFlow() {
        return mediaConnectFlow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(standard());
        hashCode = 31 * hashCode + Objects.hashCode(failover());
        hashCode = 31 * hashCode + Objects.hashCode(merge());
        hashCode = 31 * hashCode + Objects.hashCode(mediaConnectFlow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterInputStreamDetails)) {
            return false;
        }
        RouterInputStreamDetails other = (RouterInputStreamDetails) obj;
        return Objects.equals(standard(), other.standard()) && Objects.equals(failover(), other.failover())
                && Objects.equals(merge(), other.merge()) && Objects.equals(mediaConnectFlow(), other.mediaConnectFlow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouterInputStreamDetails").add("Standard", standard()).add("Failover", failover())
                .add("Merge", merge()).add("MediaConnectFlow", mediaConnectFlow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Standard":
            return Optional.ofNullable(clazz.cast(standard()));
        case "Failover":
            return Optional.ofNullable(clazz.cast(failover()));
        case "Merge":
            return Optional.ofNullable(clazz.cast(merge()));
        case "MediaConnectFlow":
            return Optional.ofNullable(clazz.cast(mediaConnectFlow()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #standard()} initialized to the given value.
     *
     * Sets the value of the Standard property for this object.
     *
     * @param standard
     *        The new value for the Standard property for this object.
     */
    public static RouterInputStreamDetails fromStandard(StandardRouterInputStreamDetails standard) {
        return builder().standard(standard).build();
    }

    /**
     * Create an instance of this class with {@link #standard()} initialized to the given value.
     *
     * Sets the value of the Standard property for this object.
     *
     * @param standard
     *        The new value for the Standard property for this object.
     */
    public static RouterInputStreamDetails fromStandard(Consumer<StandardRouterInputStreamDetails.Builder> standard) {
        StandardRouterInputStreamDetails.Builder builder = StandardRouterInputStreamDetails.builder();
        standard.accept(builder);
        return fromStandard(builder.build());
    }

    /**
     * Create an instance of this class with {@link #failover()} initialized to the given value.
     *
     * Sets the value of the Failover property for this object.
     *
     * @param failover
     *        The new value for the Failover property for this object.
     */
    public static RouterInputStreamDetails fromFailover(FailoverRouterInputStreamDetails failover) {
        return builder().failover(failover).build();
    }

    /**
     * Create an instance of this class with {@link #failover()} initialized to the given value.
     *
     * Sets the value of the Failover property for this object.
     *
     * @param failover
     *        The new value for the Failover property for this object.
     */
    public static RouterInputStreamDetails fromFailover(Consumer<FailoverRouterInputStreamDetails.Builder> failover) {
        FailoverRouterInputStreamDetails.Builder builder = FailoverRouterInputStreamDetails.builder();
        failover.accept(builder);
        return fromFailover(builder.build());
    }

    /**
     * Create an instance of this class with {@link #merge()} initialized to the given value.
     *
     * Sets the value of the Merge property for this object.
     *
     * @param merge
     *        The new value for the Merge property for this object.
     */
    public static RouterInputStreamDetails fromMerge(MergeRouterInputStreamDetails merge) {
        return builder().merge(merge).build();
    }

    /**
     * Create an instance of this class with {@link #merge()} initialized to the given value.
     *
     * Sets the value of the Merge property for this object.
     *
     * @param merge
     *        The new value for the Merge property for this object.
     */
    public static RouterInputStreamDetails fromMerge(Consumer<MergeRouterInputStreamDetails.Builder> merge) {
        MergeRouterInputStreamDetails.Builder builder = MergeRouterInputStreamDetails.builder();
        merge.accept(builder);
        return fromMerge(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mediaConnectFlow()} initialized to the given value.
     *
     * Sets the value of the MediaConnectFlow property for this object.
     *
     * @param mediaConnectFlow
     *        The new value for the MediaConnectFlow property for this object.
     */
    public static RouterInputStreamDetails fromMediaConnectFlow(MediaConnectFlowRouterInputStreamDetails mediaConnectFlow) {
        return builder().mediaConnectFlow(mediaConnectFlow).build();
    }

    /**
     * Create an instance of this class with {@link #mediaConnectFlow()} initialized to the given value.
     *
     * Sets the value of the MediaConnectFlow property for this object.
     *
     * @param mediaConnectFlow
     *        The new value for the MediaConnectFlow property for this object.
     */
    public static RouterInputStreamDetails fromMediaConnectFlow(
            Consumer<MediaConnectFlowRouterInputStreamDetails.Builder> mediaConnectFlow) {
        MediaConnectFlowRouterInputStreamDetails.Builder builder = MediaConnectFlowRouterInputStreamDetails.builder();
        mediaConnectFlow.accept(builder);
        return fromMediaConnectFlow(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("standard", STANDARD_FIELD);
        map.put("failover", FAILOVER_FIELD);
        map.put("merge", MERGE_FIELD);
        map.put("mediaConnectFlow", MEDIA_CONNECT_FLOW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterInputStreamDetails, T> g) {
        return obj -> g.apply((RouterInputStreamDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouterInputStreamDetails> {
        /**
         * Sets the value of the Standard property for this object.
         *
         * @param standard
         *        The new value for the Standard property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standard(StandardRouterInputStreamDetails standard);

        /**
         * Sets the value of the Standard property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StandardRouterInputStreamDetails.Builder}
         * avoiding the need to create one manually via {@link StandardRouterInputStreamDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StandardRouterInputStreamDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #standard(StandardRouterInputStreamDetails)}.
         * 
         * @param standard
         *        a consumer that will call methods on {@link StandardRouterInputStreamDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standard(StandardRouterInputStreamDetails)
         */
        default Builder standard(Consumer<StandardRouterInputStreamDetails.Builder> standard) {
            return standard(StandardRouterInputStreamDetails.builder().applyMutation(standard).build());
        }

        /**
         * Sets the value of the Failover property for this object.
         *
         * @param failover
         *        The new value for the Failover property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failover(FailoverRouterInputStreamDetails failover);

        /**
         * Sets the value of the Failover property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FailoverRouterInputStreamDetails.Builder}
         * avoiding the need to create one manually via {@link FailoverRouterInputStreamDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailoverRouterInputStreamDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #failover(FailoverRouterInputStreamDetails)}.
         * 
         * @param failover
         *        a consumer that will call methods on {@link FailoverRouterInputStreamDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failover(FailoverRouterInputStreamDetails)
         */
        default Builder failover(Consumer<FailoverRouterInputStreamDetails.Builder> failover) {
            return failover(FailoverRouterInputStreamDetails.builder().applyMutation(failover).build());
        }

        /**
         * Sets the value of the Merge property for this object.
         *
         * @param merge
         *        The new value for the Merge property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder merge(MergeRouterInputStreamDetails merge);

        /**
         * Sets the value of the Merge property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MergeRouterInputStreamDetails.Builder}
         * avoiding the need to create one manually via {@link MergeRouterInputStreamDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MergeRouterInputStreamDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #merge(MergeRouterInputStreamDetails)}.
         * 
         * @param merge
         *        a consumer that will call methods on {@link MergeRouterInputStreamDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #merge(MergeRouterInputStreamDetails)
         */
        default Builder merge(Consumer<MergeRouterInputStreamDetails.Builder> merge) {
            return merge(MergeRouterInputStreamDetails.builder().applyMutation(merge).build());
        }

        /**
         * Sets the value of the MediaConnectFlow property for this object.
         *
         * @param mediaConnectFlow
         *        The new value for the MediaConnectFlow property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConnectFlow(MediaConnectFlowRouterInputStreamDetails mediaConnectFlow);

        /**
         * Sets the value of the MediaConnectFlow property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link MediaConnectFlowRouterInputStreamDetails.Builder} avoiding the need to create one manually via
         * {@link MediaConnectFlowRouterInputStreamDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaConnectFlowRouterInputStreamDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #mediaConnectFlow(MediaConnectFlowRouterInputStreamDetails)}.
         * 
         * @param mediaConnectFlow
         *        a consumer that will call methods on {@link MediaConnectFlowRouterInputStreamDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaConnectFlow(MediaConnectFlowRouterInputStreamDetails)
         */
        default Builder mediaConnectFlow(Consumer<MediaConnectFlowRouterInputStreamDetails.Builder> mediaConnectFlow) {
            return mediaConnectFlow(MediaConnectFlowRouterInputStreamDetails.builder().applyMutation(mediaConnectFlow).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StandardRouterInputStreamDetails standard;

        private FailoverRouterInputStreamDetails failover;

        private MergeRouterInputStreamDetails merge;

        private MediaConnectFlowRouterInputStreamDetails mediaConnectFlow;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterInputStreamDetails model) {
            standard(model.standard);
            failover(model.failover);
            merge(model.merge);
            mediaConnectFlow(model.mediaConnectFlow);
        }

        public final StandardRouterInputStreamDetails.Builder getStandard() {
            return standard != null ? standard.toBuilder() : null;
        }

        public final void setStandard(StandardRouterInputStreamDetails.BuilderImpl standard) {
            Object oldValue = this.standard;
            this.standard = standard != null ? standard.build() : null;
            handleUnionValueChange(Type.STANDARD, oldValue, this.standard);
        }

        @Override
        public final Builder standard(StandardRouterInputStreamDetails standard) {
            Object oldValue = this.standard;
            this.standard = standard;
            handleUnionValueChange(Type.STANDARD, oldValue, this.standard);
            return this;
        }

        public final FailoverRouterInputStreamDetails.Builder getFailover() {
            return failover != null ? failover.toBuilder() : null;
        }

        public final void setFailover(FailoverRouterInputStreamDetails.BuilderImpl failover) {
            Object oldValue = this.failover;
            this.failover = failover != null ? failover.build() : null;
            handleUnionValueChange(Type.FAILOVER, oldValue, this.failover);
        }

        @Override
        public final Builder failover(FailoverRouterInputStreamDetails failover) {
            Object oldValue = this.failover;
            this.failover = failover;
            handleUnionValueChange(Type.FAILOVER, oldValue, this.failover);
            return this;
        }

        public final MergeRouterInputStreamDetails.Builder getMerge() {
            return merge != null ? merge.toBuilder() : null;
        }

        public final void setMerge(MergeRouterInputStreamDetails.BuilderImpl merge) {
            Object oldValue = this.merge;
            this.merge = merge != null ? merge.build() : null;
            handleUnionValueChange(Type.MERGE, oldValue, this.merge);
        }

        @Override
        public final Builder merge(MergeRouterInputStreamDetails merge) {
            Object oldValue = this.merge;
            this.merge = merge;
            handleUnionValueChange(Type.MERGE, oldValue, this.merge);
            return this;
        }

        public final MediaConnectFlowRouterInputStreamDetails.Builder getMediaConnectFlow() {
            return mediaConnectFlow != null ? mediaConnectFlow.toBuilder() : null;
        }

        public final void setMediaConnectFlow(MediaConnectFlowRouterInputStreamDetails.BuilderImpl mediaConnectFlow) {
            Object oldValue = this.mediaConnectFlow;
            this.mediaConnectFlow = mediaConnectFlow != null ? mediaConnectFlow.build() : null;
            handleUnionValueChange(Type.MEDIA_CONNECT_FLOW, oldValue, this.mediaConnectFlow);
        }

        @Override
        public final Builder mediaConnectFlow(MediaConnectFlowRouterInputStreamDetails mediaConnectFlow) {
            Object oldValue = this.mediaConnectFlow;
            this.mediaConnectFlow = mediaConnectFlow;
            handleUnionValueChange(Type.MEDIA_CONNECT_FLOW, oldValue, this.mediaConnectFlow);
            return this;
        }

        @Override
        public RouterInputStreamDetails build() {
            return new RouterInputStreamDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RouterInputStreamDetails#type()
     */
    public enum Type {
        STANDARD,

        FAILOVER,

        MERGE,

        MEDIA_CONNECT_FLOW,

        UNKNOWN_TO_SDK_VERSION
    }
}
