/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for a router input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouterInputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RouterInputConfiguration.Builder, RouterInputConfiguration> {
    private static final SdkField<StandardRouterInputConfiguration> STANDARD_FIELD = SdkField
            .<StandardRouterInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("Standard")
            .getter(getter(RouterInputConfiguration::standard)).setter(setter(Builder::standard))
            .constructor(StandardRouterInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standard").build()).build();

    private static final SdkField<FailoverRouterInputConfiguration> FAILOVER_FIELD = SdkField
            .<FailoverRouterInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("Failover")
            .getter(getter(RouterInputConfiguration::failover)).setter(setter(Builder::failover))
            .constructor(FailoverRouterInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failover").build()).build();

    private static final SdkField<MergeRouterInputConfiguration> MERGE_FIELD = SdkField
            .<MergeRouterInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("Merge")
            .getter(getter(RouterInputConfiguration::merge)).setter(setter(Builder::merge))
            .constructor(MergeRouterInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("merge").build()).build();

    private static final SdkField<MediaConnectFlowRouterInputConfiguration> MEDIA_CONNECT_FLOW_FIELD = SdkField
            .<MediaConnectFlowRouterInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("MediaConnectFlow")
            .getter(getter(RouterInputConfiguration::mediaConnectFlow)).setter(setter(Builder::mediaConnectFlow))
            .constructor(MediaConnectFlowRouterInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaConnectFlow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARD_FIELD,
            FAILOVER_FIELD, MERGE_FIELD, MEDIA_CONNECT_FLOW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StandardRouterInputConfiguration standard;

    private final FailoverRouterInputConfiguration failover;

    private final MergeRouterInputConfiguration merge;

    private final MediaConnectFlowRouterInputConfiguration mediaConnectFlow;

    private final Type type;

    private RouterInputConfiguration(BuilderImpl builder) {
        this.standard = builder.standard;
        this.failover = builder.failover;
        this.merge = builder.merge;
        this.mediaConnectFlow = builder.mediaConnectFlow;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Standard property for this object.
     * 
     * @return The value of the Standard property for this object.
     */
    public final StandardRouterInputConfiguration standard() {
        return standard;
    }

    /**
     * Returns the value of the Failover property for this object.
     * 
     * @return The value of the Failover property for this object.
     */
    public final FailoverRouterInputConfiguration failover() {
        return failover;
    }

    /**
     * Returns the value of the Merge property for this object.
     * 
     * @return The value of the Merge property for this object.
     */
    public final MergeRouterInputConfiguration merge() {
        return merge;
    }

    /**
     * Returns the value of the MediaConnectFlow property for this object.
     * 
     * @return The value of the MediaConnectFlow property for this object.
     */
    public final MediaConnectFlowRouterInputConfiguration mediaConnectFlow() {
        return mediaConnectFlow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(standard());
        hashCode = 31 * hashCode + Objects.hashCode(failover());
        hashCode = 31 * hashCode + Objects.hashCode(merge());
        hashCode = 31 * hashCode + Objects.hashCode(mediaConnectFlow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterInputConfiguration)) {
            return false;
        }
        RouterInputConfiguration other = (RouterInputConfiguration) obj;
        return Objects.equals(standard(), other.standard()) && Objects.equals(failover(), other.failover())
                && Objects.equals(merge(), other.merge()) && Objects.equals(mediaConnectFlow(), other.mediaConnectFlow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouterInputConfiguration").add("Standard", standard()).add("Failover", failover())
                .add("Merge", merge()).add("MediaConnectFlow", mediaConnectFlow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Standard":
            return Optional.ofNullable(clazz.cast(standard()));
        case "Failover":
            return Optional.ofNullable(clazz.cast(failover()));
        case "Merge":
            return Optional.ofNullable(clazz.cast(merge()));
        case "MediaConnectFlow":
            return Optional.ofNullable(clazz.cast(mediaConnectFlow()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #standard()} initialized to the given value.
     *
     * Sets the value of the Standard property for this object.
     *
     * @param standard
     *        The new value for the Standard property for this object.
     */
    public static RouterInputConfiguration fromStandard(StandardRouterInputConfiguration standard) {
        return builder().standard(standard).build();
    }

    /**
     * Create an instance of this class with {@link #standard()} initialized to the given value.
     *
     * Sets the value of the Standard property for this object.
     *
     * @param standard
     *        The new value for the Standard property for this object.
     */
    public static RouterInputConfiguration fromStandard(Consumer<StandardRouterInputConfiguration.Builder> standard) {
        StandardRouterInputConfiguration.Builder builder = StandardRouterInputConfiguration.builder();
        standard.accept(builder);
        return fromStandard(builder.build());
    }

    /**
     * Create an instance of this class with {@link #failover()} initialized to the given value.
     *
     * Sets the value of the Failover property for this object.
     *
     * @param failover
     *        The new value for the Failover property for this object.
     */
    public static RouterInputConfiguration fromFailover(FailoverRouterInputConfiguration failover) {
        return builder().failover(failover).build();
    }

    /**
     * Create an instance of this class with {@link #failover()} initialized to the given value.
     *
     * Sets the value of the Failover property for this object.
     *
     * @param failover
     *        The new value for the Failover property for this object.
     */
    public static RouterInputConfiguration fromFailover(Consumer<FailoverRouterInputConfiguration.Builder> failover) {
        FailoverRouterInputConfiguration.Builder builder = FailoverRouterInputConfiguration.builder();
        failover.accept(builder);
        return fromFailover(builder.build());
    }

    /**
     * Create an instance of this class with {@link #merge()} initialized to the given value.
     *
     * Sets the value of the Merge property for this object.
     *
     * @param merge
     *        The new value for the Merge property for this object.
     */
    public static RouterInputConfiguration fromMerge(MergeRouterInputConfiguration merge) {
        return builder().merge(merge).build();
    }

    /**
     * Create an instance of this class with {@link #merge()} initialized to the given value.
     *
     * Sets the value of the Merge property for this object.
     *
     * @param merge
     *        The new value for the Merge property for this object.
     */
    public static RouterInputConfiguration fromMerge(Consumer<MergeRouterInputConfiguration.Builder> merge) {
        MergeRouterInputConfiguration.Builder builder = MergeRouterInputConfiguration.builder();
        merge.accept(builder);
        return fromMerge(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mediaConnectFlow()} initialized to the given value.
     *
     * Sets the value of the MediaConnectFlow property for this object.
     *
     * @param mediaConnectFlow
     *        The new value for the MediaConnectFlow property for this object.
     */
    public static RouterInputConfiguration fromMediaConnectFlow(MediaConnectFlowRouterInputConfiguration mediaConnectFlow) {
        return builder().mediaConnectFlow(mediaConnectFlow).build();
    }

    /**
     * Create an instance of this class with {@link #mediaConnectFlow()} initialized to the given value.
     *
     * Sets the value of the MediaConnectFlow property for this object.
     *
     * @param mediaConnectFlow
     *        The new value for the MediaConnectFlow property for this object.
     */
    public static RouterInputConfiguration fromMediaConnectFlow(
            Consumer<MediaConnectFlowRouterInputConfiguration.Builder> mediaConnectFlow) {
        MediaConnectFlowRouterInputConfiguration.Builder builder = MediaConnectFlowRouterInputConfiguration.builder();
        mediaConnectFlow.accept(builder);
        return fromMediaConnectFlow(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("standard", STANDARD_FIELD);
        map.put("failover", FAILOVER_FIELD);
        map.put("merge", MERGE_FIELD);
        map.put("mediaConnectFlow", MEDIA_CONNECT_FLOW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterInputConfiguration, T> g) {
        return obj -> g.apply((RouterInputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouterInputConfiguration> {
        /**
         * Sets the value of the Standard property for this object.
         *
         * @param standard
         *        The new value for the Standard property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standard(StandardRouterInputConfiguration standard);

        /**
         * Sets the value of the Standard property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StandardRouterInputConfiguration.Builder}
         * avoiding the need to create one manually via {@link StandardRouterInputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StandardRouterInputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #standard(StandardRouterInputConfiguration)}.
         * 
         * @param standard
         *        a consumer that will call methods on {@link StandardRouterInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standard(StandardRouterInputConfiguration)
         */
        default Builder standard(Consumer<StandardRouterInputConfiguration.Builder> standard) {
            return standard(StandardRouterInputConfiguration.builder().applyMutation(standard).build());
        }

        /**
         * Sets the value of the Failover property for this object.
         *
         * @param failover
         *        The new value for the Failover property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failover(FailoverRouterInputConfiguration failover);

        /**
         * Sets the value of the Failover property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FailoverRouterInputConfiguration.Builder}
         * avoiding the need to create one manually via {@link FailoverRouterInputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailoverRouterInputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #failover(FailoverRouterInputConfiguration)}.
         * 
         * @param failover
         *        a consumer that will call methods on {@link FailoverRouterInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failover(FailoverRouterInputConfiguration)
         */
        default Builder failover(Consumer<FailoverRouterInputConfiguration.Builder> failover) {
            return failover(FailoverRouterInputConfiguration.builder().applyMutation(failover).build());
        }

        /**
         * Sets the value of the Merge property for this object.
         *
         * @param merge
         *        The new value for the Merge property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder merge(MergeRouterInputConfiguration merge);

        /**
         * Sets the value of the Merge property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MergeRouterInputConfiguration.Builder}
         * avoiding the need to create one manually via {@link MergeRouterInputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MergeRouterInputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #merge(MergeRouterInputConfiguration)}.
         * 
         * @param merge
         *        a consumer that will call methods on {@link MergeRouterInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #merge(MergeRouterInputConfiguration)
         */
        default Builder merge(Consumer<MergeRouterInputConfiguration.Builder> merge) {
            return merge(MergeRouterInputConfiguration.builder().applyMutation(merge).build());
        }

        /**
         * Sets the value of the MediaConnectFlow property for this object.
         *
         * @param mediaConnectFlow
         *        The new value for the MediaConnectFlow property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConnectFlow(MediaConnectFlowRouterInputConfiguration mediaConnectFlow);

        /**
         * Sets the value of the MediaConnectFlow property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link MediaConnectFlowRouterInputConfiguration.Builder} avoiding the need to create one manually via
         * {@link MediaConnectFlowRouterInputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaConnectFlowRouterInputConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #mediaConnectFlow(MediaConnectFlowRouterInputConfiguration)}.
         * 
         * @param mediaConnectFlow
         *        a consumer that will call methods on {@link MediaConnectFlowRouterInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaConnectFlow(MediaConnectFlowRouterInputConfiguration)
         */
        default Builder mediaConnectFlow(Consumer<MediaConnectFlowRouterInputConfiguration.Builder> mediaConnectFlow) {
            return mediaConnectFlow(MediaConnectFlowRouterInputConfiguration.builder().applyMutation(mediaConnectFlow).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StandardRouterInputConfiguration standard;

        private FailoverRouterInputConfiguration failover;

        private MergeRouterInputConfiguration merge;

        private MediaConnectFlowRouterInputConfiguration mediaConnectFlow;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterInputConfiguration model) {
            standard(model.standard);
            failover(model.failover);
            merge(model.merge);
            mediaConnectFlow(model.mediaConnectFlow);
        }

        public final StandardRouterInputConfiguration.Builder getStandard() {
            return standard != null ? standard.toBuilder() : null;
        }

        public final void setStandard(StandardRouterInputConfiguration.BuilderImpl standard) {
            Object oldValue = this.standard;
            this.standard = standard != null ? standard.build() : null;
            handleUnionValueChange(Type.STANDARD, oldValue, this.standard);
        }

        @Override
        public final Builder standard(StandardRouterInputConfiguration standard) {
            Object oldValue = this.standard;
            this.standard = standard;
            handleUnionValueChange(Type.STANDARD, oldValue, this.standard);
            return this;
        }

        public final FailoverRouterInputConfiguration.Builder getFailover() {
            return failover != null ? failover.toBuilder() : null;
        }

        public final void setFailover(FailoverRouterInputConfiguration.BuilderImpl failover) {
            Object oldValue = this.failover;
            this.failover = failover != null ? failover.build() : null;
            handleUnionValueChange(Type.FAILOVER, oldValue, this.failover);
        }

        @Override
        public final Builder failover(FailoverRouterInputConfiguration failover) {
            Object oldValue = this.failover;
            this.failover = failover;
            handleUnionValueChange(Type.FAILOVER, oldValue, this.failover);
            return this;
        }

        public final MergeRouterInputConfiguration.Builder getMerge() {
            return merge != null ? merge.toBuilder() : null;
        }

        public final void setMerge(MergeRouterInputConfiguration.BuilderImpl merge) {
            Object oldValue = this.merge;
            this.merge = merge != null ? merge.build() : null;
            handleUnionValueChange(Type.MERGE, oldValue, this.merge);
        }

        @Override
        public final Builder merge(MergeRouterInputConfiguration merge) {
            Object oldValue = this.merge;
            this.merge = merge;
            handleUnionValueChange(Type.MERGE, oldValue, this.merge);
            return this;
        }

        public final MediaConnectFlowRouterInputConfiguration.Builder getMediaConnectFlow() {
            return mediaConnectFlow != null ? mediaConnectFlow.toBuilder() : null;
        }

        public final void setMediaConnectFlow(MediaConnectFlowRouterInputConfiguration.BuilderImpl mediaConnectFlow) {
            Object oldValue = this.mediaConnectFlow;
            this.mediaConnectFlow = mediaConnectFlow != null ? mediaConnectFlow.build() : null;
            handleUnionValueChange(Type.MEDIA_CONNECT_FLOW, oldValue, this.mediaConnectFlow);
        }

        @Override
        public final Builder mediaConnectFlow(MediaConnectFlowRouterInputConfiguration mediaConnectFlow) {
            Object oldValue = this.mediaConnectFlow;
            this.mediaConnectFlow = mediaConnectFlow;
            handleUnionValueChange(Type.MEDIA_CONNECT_FLOW, oldValue, this.mediaConnectFlow);
            return this;
        }

        @Override
        public RouterInputConfiguration build() {
            return new RouterInputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RouterInputConfiguration#type()
     */
    public enum Type {
        STANDARD,

        FAILOVER,

        MERGE,

        MEDIA_CONNECT_FLOW,

        UNKNOWN_TO_SDK_VERSION
    }
}
