/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A savings plan that reserves a certain amount of outbound bandwidth usage at a discounted rate each month over a
 * period of time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Offering implements SdkPojo, Serializable, ToCopyableBuilder<Offering.Builder, Offering> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(Offering::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration").getter(getter(Offering::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()).build();

    private static final SdkField<String> DURATION_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurationUnits").getter(getter(Offering::durationUnitsAsString)).setter(setter(Builder::durationUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationUnits").build()).build();

    private static final SdkField<String> OFFERING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingArn").getter(getter(Offering::offeringArn)).setter(setter(Builder::offeringArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringArn").build()).build();

    private static final SdkField<String> OFFERING_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingDescription").getter(getter(Offering::offeringDescription))
            .setter(setter(Builder::offeringDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringDescription").build())
            .build();

    private static final SdkField<String> PRICE_PER_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricePerUnit").getter(getter(Offering::pricePerUnit)).setter(setter(Builder::pricePerUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricePerUnit").build()).build();

    private static final SdkField<String> PRICE_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PriceUnits").getter(getter(Offering::priceUnitsAsString)).setter(setter(Builder::priceUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priceUnits").build()).build();

    private static final SdkField<ResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField
            .<ResourceSpecification> builder(MarshallingType.SDK_POJO).memberName("ResourceSpecification")
            .getter(getter(Offering::resourceSpecification)).setter(setter(Builder::resourceSpecification))
            .constructor(ResourceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD,
            DURATION_FIELD, DURATION_UNITS_FIELD, OFFERING_ARN_FIELD, OFFERING_DESCRIPTION_FIELD, PRICE_PER_UNIT_FIELD,
            PRICE_UNITS_FIELD, RESOURCE_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String currencyCode;

    private final Integer duration;

    private final String durationUnits;

    private final String offeringArn;

    private final String offeringDescription;

    private final String pricePerUnit;

    private final String priceUnits;

    private final ResourceSpecification resourceSpecification;

    private Offering(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.durationUnits = builder.durationUnits;
        this.offeringArn = builder.offeringArn;
        this.offeringDescription = builder.offeringDescription;
        this.pricePerUnit = builder.pricePerUnit;
        this.priceUnits = builder.priceUnits;
        this.resourceSpecification = builder.resourceSpecification;
    }

    /**
     * <p>
     * The type of currency that is used for billing. The currencyCode used for all reservations is US dollars.
     * </p>
     * 
     * @return The type of currency that is used for billing. The currencyCode used for all reservations is US dollars.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The length of time that your reservation would be active.
     * </p>
     * 
     * @return The length of time that your reservation would be active.
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The unit of measurement for the duration of the offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #durationUnits}
     * will return {@link DurationUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #durationUnitsAsString}.
     * </p>
     * 
     * @return The unit of measurement for the duration of the offering.
     * @see DurationUnits
     */
    public final DurationUnits durationUnits() {
        return DurationUnits.fromValue(durationUnits);
    }

    /**
     * <p>
     * The unit of measurement for the duration of the offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #durationUnits}
     * will return {@link DurationUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #durationUnitsAsString}.
     * </p>
     * 
     * @return The unit of measurement for the duration of the offering.
     * @see DurationUnits
     */
    public final String durationUnitsAsString() {
        return durationUnits;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
     */
    public final String offeringArn() {
        return offeringArn;
    }

    /**
     * <p>
     * A description of the offering.
     * </p>
     * 
     * @return A description of the offering.
     */
    public final String offeringDescription() {
        return offeringDescription;
    }

    /**
     * <p>
     * The cost of a single unit. This value, in combination with priceUnits, makes up the rate.
     * </p>
     * 
     * @return The cost of a single unit. This value, in combination with priceUnits, makes up the rate.
     */
    public final String pricePerUnit() {
        return pricePerUnit;
    }

    /**
     * <p>
     * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the
     * rate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceUnits} will
     * return {@link PriceUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceUnitsAsString}.
     * </p>
     * 
     * @return The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up
     *         the rate.
     * @see PriceUnits
     */
    public final PriceUnits priceUnits() {
        return PriceUnits.fromValue(priceUnits);
    }

    /**
     * <p>
     * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the
     * rate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceUnits} will
     * return {@link PriceUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceUnitsAsString}.
     * </p>
     * 
     * @return The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up
     *         the rate.
     * @see PriceUnits
     */
    public final String priceUnitsAsString() {
        return priceUnits;
    }

    /**
     * <p>
     * A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering.
     * </p>
     * 
     * @return A definition of the amount of outbound bandwidth that you would be reserving if you purchase the
     *         offering.
     */
    public final ResourceSpecification resourceSpecification() {
        return resourceSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(durationUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offeringArn());
        hashCode = 31 * hashCode + Objects.hashCode(offeringDescription());
        hashCode = 31 * hashCode + Objects.hashCode(pricePerUnit());
        hashCode = 31 * hashCode + Objects.hashCode(priceUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Offering)) {
            return false;
        }
        Offering other = (Offering) obj;
        return Objects.equals(currencyCode(), other.currencyCode()) && Objects.equals(duration(), other.duration())
                && Objects.equals(durationUnitsAsString(), other.durationUnitsAsString())
                && Objects.equals(offeringArn(), other.offeringArn())
                && Objects.equals(offeringDescription(), other.offeringDescription())
                && Objects.equals(pricePerUnit(), other.pricePerUnit())
                && Objects.equals(priceUnitsAsString(), other.priceUnitsAsString())
                && Objects.equals(resourceSpecification(), other.resourceSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Offering").add("CurrencyCode", currencyCode()).add("Duration", duration())
                .add("DurationUnits", durationUnitsAsString()).add("OfferingArn", offeringArn())
                .add("OfferingDescription", offeringDescription()).add("PricePerUnit", pricePerUnit())
                .add("PriceUnits", priceUnitsAsString()).add("ResourceSpecification", resourceSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "DurationUnits":
            return Optional.ofNullable(clazz.cast(durationUnitsAsString()));
        case "OfferingArn":
            return Optional.ofNullable(clazz.cast(offeringArn()));
        case "OfferingDescription":
            return Optional.ofNullable(clazz.cast(offeringDescription()));
        case "PricePerUnit":
            return Optional.ofNullable(clazz.cast(pricePerUnit()));
        case "PriceUnits":
            return Optional.ofNullable(clazz.cast(priceUnitsAsString()));
        case "ResourceSpecification":
            return Optional.ofNullable(clazz.cast(resourceSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("currencyCode", CURRENCY_CODE_FIELD);
        map.put("duration", DURATION_FIELD);
        map.put("durationUnits", DURATION_UNITS_FIELD);
        map.put("offeringArn", OFFERING_ARN_FIELD);
        map.put("offeringDescription", OFFERING_DESCRIPTION_FIELD);
        map.put("pricePerUnit", PRICE_PER_UNIT_FIELD);
        map.put("priceUnits", PRICE_UNITS_FIELD);
        map.put("resourceSpecification", RESOURCE_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Offering, T> g) {
        return obj -> g.apply((Offering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Offering> {
        /**
         * <p>
         * The type of currency that is used for billing. The currencyCode used for all reservations is US dollars.
         * </p>
         * 
         * @param currencyCode
         *        The type of currency that is used for billing. The currencyCode used for all reservations is US
         *        dollars.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The length of time that your reservation would be active.
         * </p>
         * 
         * @param duration
         *        The length of time that your reservation would be active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The unit of measurement for the duration of the offering.
         * </p>
         * 
         * @param durationUnits
         *        The unit of measurement for the duration of the offering.
         * @see DurationUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DurationUnits
         */
        Builder durationUnits(String durationUnits);

        /**
         * <p>
         * The unit of measurement for the duration of the offering.
         * </p>
         * 
         * @param durationUnits
         *        The unit of measurement for the duration of the offering.
         * @see DurationUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DurationUnits
         */
        Builder durationUnits(DurationUnits durationUnits);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
         * </p>
         * 
         * @param offeringArn
         *        The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringArn(String offeringArn);

        /**
         * <p>
         * A description of the offering.
         * </p>
         * 
         * @param offeringDescription
         *        A description of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringDescription(String offeringDescription);

        /**
         * <p>
         * The cost of a single unit. This value, in combination with priceUnits, makes up the rate.
         * </p>
         * 
         * @param pricePerUnit
         *        The cost of a single unit. This value, in combination with priceUnits, makes up the rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricePerUnit(String pricePerUnit);

        /**
         * <p>
         * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the
         * rate.
         * </p>
         * 
         * @param priceUnits
         *        The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes
         *        up the rate.
         * @see PriceUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceUnits
         */
        Builder priceUnits(String priceUnits);

        /**
         * <p>
         * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the
         * rate.
         * </p>
         * 
         * @param priceUnits
         *        The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes
         *        up the rate.
         * @see PriceUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceUnits
         */
        Builder priceUnits(PriceUnits priceUnits);

        /**
         * <p>
         * A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering.
         * </p>
         * 
         * @param resourceSpecification
         *        A definition of the amount of outbound bandwidth that you would be reserving if you purchase the
         *        offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSpecification(ResourceSpecification resourceSpecification);

        /**
         * <p>
         * A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceSpecification.Builder} avoiding
         * the need to create one manually via {@link ResourceSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceSpecification(ResourceSpecification)}.
         * 
         * @param resourceSpecification
         *        a consumer that will call methods on {@link ResourceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSpecification(ResourceSpecification)
         */
        default Builder resourceSpecification(Consumer<ResourceSpecification.Builder> resourceSpecification) {
            return resourceSpecification(ResourceSpecification.builder().applyMutation(resourceSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String currencyCode;

        private Integer duration;

        private String durationUnits;

        private String offeringArn;

        private String offeringDescription;

        private String pricePerUnit;

        private String priceUnits;

        private ResourceSpecification resourceSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(Offering model) {
            currencyCode(model.currencyCode);
            duration(model.duration);
            durationUnits(model.durationUnits);
            offeringArn(model.offeringArn);
            offeringDescription(model.offeringDescription);
            pricePerUnit(model.pricePerUnit);
            priceUnits(model.priceUnits);
            resourceSpecification(model.resourceSpecification);
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final String getDurationUnits() {
            return durationUnits;
        }

        public final void setDurationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
        }

        @Override
        public final Builder durationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
            return this;
        }

        @Override
        public final Builder durationUnits(DurationUnits durationUnits) {
            this.durationUnits(durationUnits == null ? null : durationUnits.toString());
            return this;
        }

        public final String getOfferingArn() {
            return offeringArn;
        }

        public final void setOfferingArn(String offeringArn) {
            this.offeringArn = offeringArn;
        }

        @Override
        public final Builder offeringArn(String offeringArn) {
            this.offeringArn = offeringArn;
            return this;
        }

        public final String getOfferingDescription() {
            return offeringDescription;
        }

        public final void setOfferingDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
        }

        @Override
        public final Builder offeringDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
            return this;
        }

        public final String getPricePerUnit() {
            return pricePerUnit;
        }

        public final void setPricePerUnit(String pricePerUnit) {
            this.pricePerUnit = pricePerUnit;
        }

        @Override
        public final Builder pricePerUnit(String pricePerUnit) {
            this.pricePerUnit = pricePerUnit;
            return this;
        }

        public final String getPriceUnits() {
            return priceUnits;
        }

        public final void setPriceUnits(String priceUnits) {
            this.priceUnits = priceUnits;
        }

        @Override
        public final Builder priceUnits(String priceUnits) {
            this.priceUnits = priceUnits;
            return this;
        }

        @Override
        public final Builder priceUnits(PriceUnits priceUnits) {
            this.priceUnits(priceUnits == null ? null : priceUnits.toString());
            return this;
        }

        public final ResourceSpecification.Builder getResourceSpecification() {
            return resourceSpecification != null ? resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        public final Builder resourceSpecification(ResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        @Override
        public Offering build() {
            return new Offering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
