/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings related to the multicast source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MulticastSourceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MulticastSourceSettings.Builder, MulticastSourceSettings> {
    private static final SdkField<String> MULTICAST_SOURCE_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MulticastSourceIp").getter(getter(MulticastSourceSettings::multicastSourceIp))
            .setter(setter(Builder::multicastSourceIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multicastSourceIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTICAST_SOURCE_IP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String multicastSourceIp;

    private MulticastSourceSettings(BuilderImpl builder) {
        this.multicastSourceIp = builder.multicastSourceIp;
    }

    /**
     * <p>
     * The IP address of the source for source-specific multicast (SSM).
     * </p>
     * 
     * @return The IP address of the source for source-specific multicast (SSM).
     */
    public final String multicastSourceIp() {
        return multicastSourceIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(multicastSourceIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MulticastSourceSettings)) {
            return false;
        }
        MulticastSourceSettings other = (MulticastSourceSettings) obj;
        return Objects.equals(multicastSourceIp(), other.multicastSourceIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MulticastSourceSettings").add("MulticastSourceIp", multicastSourceIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MulticastSourceIp":
            return Optional.ofNullable(clazz.cast(multicastSourceIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("multicastSourceIp", MULTICAST_SOURCE_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MulticastSourceSettings, T> g) {
        return obj -> g.apply((MulticastSourceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MulticastSourceSettings> {
        /**
         * <p>
         * The IP address of the source for source-specific multicast (SSM).
         * </p>
         * 
         * @param multicastSourceIp
         *        The IP address of the source for source-specific multicast (SSM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicastSourceIp(String multicastSourceIp);
    }

    static final class BuilderImpl implements Builder {
        private String multicastSourceIp;

        private BuilderImpl() {
        }

        private BuilderImpl(MulticastSourceSettings model) {
            multicastSourceIp(model.multicastSourceIp);
        }

        public final String getMulticastSourceIp() {
            return multicastSourceIp;
        }

        public final void setMulticastSourceIp(String multicastSourceIp) {
            this.multicastSourceIp = multicastSourceIp;
        }

        @Override
        public final Builder multicastSourceIp(String multicastSourceIp) {
            this.multicastSourceIp = multicastSourceIp;
            return this;
        }

        @Override
        public MulticastSourceSettings build() {
            return new MulticastSourceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
