/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Protocol configuration settings for merge router inputs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MergeRouterInputProtocolConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MergeRouterInputProtocolConfiguration.Builder, MergeRouterInputProtocolConfiguration> {
    private static final SdkField<RtpRouterInputConfiguration> RTP_FIELD = SdkField
            .<RtpRouterInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("Rtp")
            .getter(getter(MergeRouterInputProtocolConfiguration::rtp)).setter(setter(Builder::rtp))
            .constructor(RtpRouterInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtp").build()).build();

    private static final SdkField<RistRouterInputConfiguration> RIST_FIELD = SdkField
            .<RistRouterInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("Rist")
            .getter(getter(MergeRouterInputProtocolConfiguration::rist)).setter(setter(Builder::rist))
            .constructor(RistRouterInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rist").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RTP_FIELD, RIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RtpRouterInputConfiguration rtp;

    private final RistRouterInputConfiguration rist;

    private final Type type;

    private MergeRouterInputProtocolConfiguration(BuilderImpl builder) {
        this.rtp = builder.rtp;
        this.rist = builder.rist;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Rtp property for this object.
     * 
     * @return The value of the Rtp property for this object.
     */
    public final RtpRouterInputConfiguration rtp() {
        return rtp;
    }

    /**
     * Returns the value of the Rist property for this object.
     * 
     * @return The value of the Rist property for this object.
     */
    public final RistRouterInputConfiguration rist() {
        return rist;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rtp());
        hashCode = 31 * hashCode + Objects.hashCode(rist());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeRouterInputProtocolConfiguration)) {
            return false;
        }
        MergeRouterInputProtocolConfiguration other = (MergeRouterInputProtocolConfiguration) obj;
        return Objects.equals(rtp(), other.rtp()) && Objects.equals(rist(), other.rist());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MergeRouterInputProtocolConfiguration").add("Rtp", rtp()).add("Rist", rist()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rtp":
            return Optional.ofNullable(clazz.cast(rtp()));
        case "Rist":
            return Optional.ofNullable(clazz.cast(rist()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #rtp()} initialized to the given value.
     *
     * Sets the value of the Rtp property for this object.
     *
     * @param rtp
     *        The new value for the Rtp property for this object.
     */
    public static MergeRouterInputProtocolConfiguration fromRtp(RtpRouterInputConfiguration rtp) {
        return builder().rtp(rtp).build();
    }

    /**
     * Create an instance of this class with {@link #rtp()} initialized to the given value.
     *
     * Sets the value of the Rtp property for this object.
     *
     * @param rtp
     *        The new value for the Rtp property for this object.
     */
    public static MergeRouterInputProtocolConfiguration fromRtp(Consumer<RtpRouterInputConfiguration.Builder> rtp) {
        RtpRouterInputConfiguration.Builder builder = RtpRouterInputConfiguration.builder();
        rtp.accept(builder);
        return fromRtp(builder.build());
    }

    /**
     * Create an instance of this class with {@link #rist()} initialized to the given value.
     *
     * Sets the value of the Rist property for this object.
     *
     * @param rist
     *        The new value for the Rist property for this object.
     */
    public static MergeRouterInputProtocolConfiguration fromRist(RistRouterInputConfiguration rist) {
        return builder().rist(rist).build();
    }

    /**
     * Create an instance of this class with {@link #rist()} initialized to the given value.
     *
     * Sets the value of the Rist property for this object.
     *
     * @param rist
     *        The new value for the Rist property for this object.
     */
    public static MergeRouterInputProtocolConfiguration fromRist(Consumer<RistRouterInputConfiguration.Builder> rist) {
        RistRouterInputConfiguration.Builder builder = RistRouterInputConfiguration.builder();
        rist.accept(builder);
        return fromRist(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("rtp", RTP_FIELD);
        map.put("rist", RIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MergeRouterInputProtocolConfiguration, T> g) {
        return obj -> g.apply((MergeRouterInputProtocolConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MergeRouterInputProtocolConfiguration> {
        /**
         * Sets the value of the Rtp property for this object.
         *
         * @param rtp
         *        The new value for the Rtp property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rtp(RtpRouterInputConfiguration rtp);

        /**
         * Sets the value of the Rtp property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RtpRouterInputConfiguration.Builder}
         * avoiding the need to create one manually via {@link RtpRouterInputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RtpRouterInputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #rtp(RtpRouterInputConfiguration)}.
         * 
         * @param rtp
         *        a consumer that will call methods on {@link RtpRouterInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rtp(RtpRouterInputConfiguration)
         */
        default Builder rtp(Consumer<RtpRouterInputConfiguration.Builder> rtp) {
            return rtp(RtpRouterInputConfiguration.builder().applyMutation(rtp).build());
        }

        /**
         * Sets the value of the Rist property for this object.
         *
         * @param rist
         *        The new value for the Rist property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rist(RistRouterInputConfiguration rist);

        /**
         * Sets the value of the Rist property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RistRouterInputConfiguration.Builder}
         * avoiding the need to create one manually via {@link RistRouterInputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RistRouterInputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #rist(RistRouterInputConfiguration)}.
         * 
         * @param rist
         *        a consumer that will call methods on {@link RistRouterInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rist(RistRouterInputConfiguration)
         */
        default Builder rist(Consumer<RistRouterInputConfiguration.Builder> rist) {
            return rist(RistRouterInputConfiguration.builder().applyMutation(rist).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RtpRouterInputConfiguration rtp;

        private RistRouterInputConfiguration rist;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MergeRouterInputProtocolConfiguration model) {
            rtp(model.rtp);
            rist(model.rist);
        }

        public final RtpRouterInputConfiguration.Builder getRtp() {
            return rtp != null ? rtp.toBuilder() : null;
        }

        public final void setRtp(RtpRouterInputConfiguration.BuilderImpl rtp) {
            Object oldValue = this.rtp;
            this.rtp = rtp != null ? rtp.build() : null;
            handleUnionValueChange(Type.RTP, oldValue, this.rtp);
        }

        @Override
        public final Builder rtp(RtpRouterInputConfiguration rtp) {
            Object oldValue = this.rtp;
            this.rtp = rtp;
            handleUnionValueChange(Type.RTP, oldValue, this.rtp);
            return this;
        }

        public final RistRouterInputConfiguration.Builder getRist() {
            return rist != null ? rist.toBuilder() : null;
        }

        public final void setRist(RistRouterInputConfiguration.BuilderImpl rist) {
            Object oldValue = this.rist;
            this.rist = rist != null ? rist.build() : null;
            handleUnionValueChange(Type.RIST, oldValue, this.rist);
        }

        @Override
        public final Builder rist(RistRouterInputConfiguration rist) {
            Object oldValue = this.rist;
            this.rist = rist;
            handleUnionValueChange(Type.RIST, oldValue, this.rist);
            return this;
        }

        @Override
        public MergeRouterInputProtocolConfiguration build() {
            return new MergeRouterInputProtocolConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see MergeRouterInputProtocolConfiguration#type()
     */
    public enum Type {
        RTP,

        RIST,

        UNKNOWN_TO_SDK_VERSION
    }
}
