/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration details for an indexed stream in a merge router input setup.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MergeRouterInputIndexedStreamDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<MergeRouterInputIndexedStreamDetails.Builder, MergeRouterInputIndexedStreamDetails> {
    private static final SdkField<Integer> SOURCE_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SourceIndex").getter(getter(MergeRouterInputIndexedStreamDetails::sourceIndex))
            .setter(setter(Builder::sourceIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIndex").build()).build();

    private static final SdkField<String> SOURCE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceIpAddress").getter(getter(MergeRouterInputIndexedStreamDetails::sourceIpAddress))
            .setter(setter(Builder::sourceIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIpAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_INDEX_FIELD,
            SOURCE_IP_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer sourceIndex;

    private final String sourceIpAddress;

    private MergeRouterInputIndexedStreamDetails(BuilderImpl builder) {
        this.sourceIndex = builder.sourceIndex;
        this.sourceIpAddress = builder.sourceIpAddress;
    }

    /**
     * <p>
     * The index number (0 or 1) assigned to this source in the merge configuration.
     * </p>
     * 
     * @return The index number (0 or 1) assigned to this source in the merge configuration.
     */
    public final Integer sourceIndex() {
        return sourceIndex;
    }

    /**
     * <p>
     * The IP address of the source for this indexed stream in the merge setup.
     * </p>
     * 
     * @return The IP address of the source for this indexed stream in the merge setup.
     */
    public final String sourceIpAddress() {
        return sourceIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIpAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeRouterInputIndexedStreamDetails)) {
            return false;
        }
        MergeRouterInputIndexedStreamDetails other = (MergeRouterInputIndexedStreamDetails) obj;
        return Objects.equals(sourceIndex(), other.sourceIndex()) && Objects.equals(sourceIpAddress(), other.sourceIpAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MergeRouterInputIndexedStreamDetails").add("SourceIndex", sourceIndex())
                .add("SourceIpAddress", sourceIpAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceIndex":
            return Optional.ofNullable(clazz.cast(sourceIndex()));
        case "SourceIpAddress":
            return Optional.ofNullable(clazz.cast(sourceIpAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceIndex", SOURCE_INDEX_FIELD);
        map.put("sourceIpAddress", SOURCE_IP_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MergeRouterInputIndexedStreamDetails, T> g) {
        return obj -> g.apply((MergeRouterInputIndexedStreamDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MergeRouterInputIndexedStreamDetails> {
        /**
         * <p>
         * The index number (0 or 1) assigned to this source in the merge configuration.
         * </p>
         * 
         * @param sourceIndex
         *        The index number (0 or 1) assigned to this source in the merge configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIndex(Integer sourceIndex);

        /**
         * <p>
         * The IP address of the source for this indexed stream in the merge setup.
         * </p>
         * 
         * @param sourceIpAddress
         *        The IP address of the source for this indexed stream in the merge setup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIpAddress(String sourceIpAddress);
    }

    static final class BuilderImpl implements Builder {
        private Integer sourceIndex;

        private String sourceIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeRouterInputIndexedStreamDetails model) {
            sourceIndex(model.sourceIndex);
            sourceIpAddress(model.sourceIpAddress);
        }

        public final Integer getSourceIndex() {
            return sourceIndex;
        }

        public final void setSourceIndex(Integer sourceIndex) {
            this.sourceIndex = sourceIndex;
        }

        @Override
        public final Builder sourceIndex(Integer sourceIndex) {
            this.sourceIndex = sourceIndex;
            return this;
        }

        public final String getSourceIpAddress() {
            return sourceIpAddress;
        }

        public final void setSourceIpAddress(String sourceIpAddress) {
            this.sourceIpAddress = sourceIpAddress;
        }

        @Override
        public final Builder sourceIpAddress(String sourceIpAddress) {
            this.sourceIpAddress = sourceIpAddress;
            return this;
        }

        @Override
        public MergeRouterInputIndexedStreamDetails build() {
            return new MergeRouterInputIndexedStreamDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
