/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The media stream that you want to associate with the output, and the parameters for that association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaStreamOutputConfigurationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaStreamOutputConfigurationRequest.Builder, MediaStreamOutputConfigurationRequest> {
    private static final SdkField<List<DestinationConfigurationRequest>> DESTINATION_CONFIGURATIONS_FIELD = SdkField
            .<List<DestinationConfigurationRequest>> builder(MarshallingType.LIST)
            .memberName("DestinationConfigurations")
            .getter(getter(MediaStreamOutputConfigurationRequest::destinationConfigurations))
            .setter(setter(Builder::destinationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DestinationConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(DestinationConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENCODING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncodingName").getter(getter(MediaStreamOutputConfigurationRequest::encodingNameAsString))
            .setter(setter(Builder::encodingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encodingName").build()).build();

    private static final SdkField<EncodingParametersRequest> ENCODING_PARAMETERS_FIELD = SdkField
            .<EncodingParametersRequest> builder(MarshallingType.SDK_POJO).memberName("EncodingParameters")
            .getter(getter(MediaStreamOutputConfigurationRequest::encodingParameters))
            .setter(setter(Builder::encodingParameters)).constructor(EncodingParametersRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encodingParameters").build())
            .build();

    private static final SdkField<String> MEDIA_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaStreamName").getter(getter(MediaStreamOutputConfigurationRequest::mediaStreamName))
            .setter(setter(Builder::mediaStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DESTINATION_CONFIGURATIONS_FIELD, ENCODING_NAME_FIELD, ENCODING_PARAMETERS_FIELD, MEDIA_STREAM_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DestinationConfigurationRequest> destinationConfigurations;

    private final String encodingName;

    private final EncodingParametersRequest encodingParameters;

    private final String mediaStreamName;

    private MediaStreamOutputConfigurationRequest(BuilderImpl builder) {
        this.destinationConfigurations = builder.destinationConfigurations;
        this.encodingName = builder.encodingName;
        this.encodingParameters = builder.encodingParameters;
        this.mediaStreamName = builder.mediaStreamName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDestinationConfigurations() {
        return destinationConfigurations != null && !(destinationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The media streams that you want to associate with the output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationConfigurations} method.
     * </p>
     * 
     * @return The media streams that you want to associate with the output.
     */
    public final List<DestinationConfigurationRequest> destinationConfigurations() {
        return destinationConfigurations;
    }

    /**
     * <p>
     * The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291.
     * For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For
     * video, JPEG XS streams, set the encoding name to jxsv.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encodingName} will
     * return {@link EncodingName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encodingNameAsString}.
     * </p>
     * 
     * @return The format that will be used to encode the data. For ancillary data streams, set the encoding name to
     *         smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name
     *         to raw. For video, JPEG XS streams, set the encoding name to jxsv.
     * @see EncodingName
     */
    public final EncodingName encodingName() {
        return EncodingName.fromValue(encodingName);
    }

    /**
     * <p>
     * The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291.
     * For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For
     * video, JPEG XS streams, set the encoding name to jxsv.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encodingName} will
     * return {@link EncodingName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encodingNameAsString}.
     * </p>
     * 
     * @return The format that will be used to encode the data. For ancillary data streams, set the encoding name to
     *         smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name
     *         to raw. For video, JPEG XS streams, set the encoding name to jxsv.
     * @see EncodingName
     */
    public final String encodingNameAsString() {
        return encodingName;
    }

    /**
     * <p>
     * A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to
     * outputs on flows that have a CDI source.
     * </p>
     * 
     * @return A collection of parameters that determine how MediaConnect will convert the content. These fields only
     *         apply to outputs on flows that have a CDI source.
     */
    public final EncodingParametersRequest encodingParameters() {
        return encodingParameters;
    }

    /**
     * <p>
     * The name of the media stream that is associated with the output.
     * </p>
     * 
     * @return The name of the media stream that is associated with the output.
     */
    public final String mediaStreamName() {
        return mediaStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationConfigurations() ? destinationConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encodingNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encodingParameters());
        hashCode = 31 * hashCode + Objects.hashCode(mediaStreamName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaStreamOutputConfigurationRequest)) {
            return false;
        }
        MediaStreamOutputConfigurationRequest other = (MediaStreamOutputConfigurationRequest) obj;
        return hasDestinationConfigurations() == other.hasDestinationConfigurations()
                && Objects.equals(destinationConfigurations(), other.destinationConfigurations())
                && Objects.equals(encodingNameAsString(), other.encodingNameAsString())
                && Objects.equals(encodingParameters(), other.encodingParameters())
                && Objects.equals(mediaStreamName(), other.mediaStreamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaStreamOutputConfigurationRequest")
                .add("DestinationConfigurations", hasDestinationConfigurations() ? destinationConfigurations() : null)
                .add("EncodingName", encodingNameAsString()).add("EncodingParameters", encodingParameters())
                .add("MediaStreamName", mediaStreamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationConfigurations":
            return Optional.ofNullable(clazz.cast(destinationConfigurations()));
        case "EncodingName":
            return Optional.ofNullable(clazz.cast(encodingNameAsString()));
        case "EncodingParameters":
            return Optional.ofNullable(clazz.cast(encodingParameters()));
        case "MediaStreamName":
            return Optional.ofNullable(clazz.cast(mediaStreamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinationConfigurations", DESTINATION_CONFIGURATIONS_FIELD);
        map.put("encodingName", ENCODING_NAME_FIELD);
        map.put("encodingParameters", ENCODING_PARAMETERS_FIELD);
        map.put("mediaStreamName", MEDIA_STREAM_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaStreamOutputConfigurationRequest, T> g) {
        return obj -> g.apply((MediaStreamOutputConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaStreamOutputConfigurationRequest> {
        /**
         * <p>
         * The media streams that you want to associate with the output.
         * </p>
         * 
         * @param destinationConfigurations
         *        The media streams that you want to associate with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfigurations(Collection<DestinationConfigurationRequest> destinationConfigurations);

        /**
         * <p>
         * The media streams that you want to associate with the output.
         * </p>
         * 
         * @param destinationConfigurations
         *        The media streams that you want to associate with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfigurations(DestinationConfigurationRequest... destinationConfigurations);

        /**
         * <p>
         * The media streams that you want to associate with the output.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.DestinationConfigurationRequest.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.DestinationConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.DestinationConfigurationRequest.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #destinationConfigurations(List<DestinationConfigurationRequest>)}.
         * 
         * @param destinationConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.DestinationConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfigurations(java.util.Collection<DestinationConfigurationRequest>)
         */
        Builder destinationConfigurations(Consumer<DestinationConfigurationRequest.Builder>... destinationConfigurations);

        /**
         * <p>
         * The format that will be used to encode the data. For ancillary data streams, set the encoding name to
         * smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to
         * raw. For video, JPEG XS streams, set the encoding name to jxsv.
         * </p>
         * 
         * @param encodingName
         *        The format that will be used to encode the data. For ancillary data streams, set the encoding name to
         *        smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding
         *        name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         * @see EncodingName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingName
         */
        Builder encodingName(String encodingName);

        /**
         * <p>
         * The format that will be used to encode the data. For ancillary data streams, set the encoding name to
         * smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to
         * raw. For video, JPEG XS streams, set the encoding name to jxsv.
         * </p>
         * 
         * @param encodingName
         *        The format that will be used to encode the data. For ancillary data streams, set the encoding name to
         *        smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding
         *        name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         * @see EncodingName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingName
         */
        Builder encodingName(EncodingName encodingName);

        /**
         * <p>
         * A collection of parameters that determine how MediaConnect will convert the content. These fields only apply
         * to outputs on flows that have a CDI source.
         * </p>
         * 
         * @param encodingParameters
         *        A collection of parameters that determine how MediaConnect will convert the content. These fields only
         *        apply to outputs on flows that have a CDI source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encodingParameters(EncodingParametersRequest encodingParameters);

        /**
         * <p>
         * A collection of parameters that determine how MediaConnect will convert the content. These fields only apply
         * to outputs on flows that have a CDI source.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncodingParametersRequest.Builder}
         * avoiding the need to create one manually via {@link EncodingParametersRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncodingParametersRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #encodingParameters(EncodingParametersRequest)}.
         * 
         * @param encodingParameters
         *        a consumer that will call methods on {@link EncodingParametersRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encodingParameters(EncodingParametersRequest)
         */
        default Builder encodingParameters(Consumer<EncodingParametersRequest.Builder> encodingParameters) {
            return encodingParameters(EncodingParametersRequest.builder().applyMutation(encodingParameters).build());
        }

        /**
         * <p>
         * The name of the media stream that is associated with the output.
         * </p>
         * 
         * @param mediaStreamName
         *        The name of the media stream that is associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreamName(String mediaStreamName);
    }

    static final class BuilderImpl implements Builder {
        private List<DestinationConfigurationRequest> destinationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String encodingName;

        private EncodingParametersRequest encodingParameters;

        private String mediaStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaStreamOutputConfigurationRequest model) {
            destinationConfigurations(model.destinationConfigurations);
            encodingName(model.encodingName);
            encodingParameters(model.encodingParameters);
            mediaStreamName(model.mediaStreamName);
        }

        public final List<DestinationConfigurationRequest.Builder> getDestinationConfigurations() {
            List<DestinationConfigurationRequest.Builder> result = ___listOfDestinationConfigurationRequestCopier
                    .copyToBuilder(this.destinationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationConfigurations(
                Collection<DestinationConfigurationRequest.BuilderImpl> destinationConfigurations) {
            this.destinationConfigurations = ___listOfDestinationConfigurationRequestCopier
                    .copyFromBuilder(destinationConfigurations);
        }

        @Override
        public final Builder destinationConfigurations(Collection<DestinationConfigurationRequest> destinationConfigurations) {
            this.destinationConfigurations = ___listOfDestinationConfigurationRequestCopier.copy(destinationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationConfigurations(DestinationConfigurationRequest... destinationConfigurations) {
            destinationConfigurations(Arrays.asList(destinationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationConfigurations(
                Consumer<DestinationConfigurationRequest.Builder>... destinationConfigurations) {
            destinationConfigurations(Stream.of(destinationConfigurations)
                    .map(c -> DestinationConfigurationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEncodingName() {
            return encodingName;
        }

        public final void setEncodingName(String encodingName) {
            this.encodingName = encodingName;
        }

        @Override
        public final Builder encodingName(String encodingName) {
            this.encodingName = encodingName;
            return this;
        }

        @Override
        public final Builder encodingName(EncodingName encodingName) {
            this.encodingName(encodingName == null ? null : encodingName.toString());
            return this;
        }

        public final EncodingParametersRequest.Builder getEncodingParameters() {
            return encodingParameters != null ? encodingParameters.toBuilder() : null;
        }

        public final void setEncodingParameters(EncodingParametersRequest.BuilderImpl encodingParameters) {
            this.encodingParameters = encodingParameters != null ? encodingParameters.build() : null;
        }

        @Override
        public final Builder encodingParameters(EncodingParametersRequest encodingParameters) {
            this.encodingParameters = encodingParameters;
            return this;
        }

        public final String getMediaStreamName() {
            return mediaStreamName;
        }

        public final void setMediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
        }

        @Override
        public final Builder mediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
            return this;
        }

        @Override
        public MediaStreamOutputConfigurationRequest build() {
            return new MediaStreamOutputConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
