/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for maintenance operations, including preferred maintenance windows and schedules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MaintenanceConfiguration.Builder, MaintenanceConfiguration> {
    private static final SdkField<PreferredDayTimeMaintenanceConfiguration> PREFERRED_DAY_TIME_FIELD = SdkField
            .<PreferredDayTimeMaintenanceConfiguration> builder(MarshallingType.SDK_POJO).memberName("PreferredDayTime")
            .getter(getter(MaintenanceConfiguration::preferredDayTime)).setter(setter(Builder::preferredDayTime))
            .constructor(PreferredDayTimeMaintenanceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredDayTime").build()).build();

    private static final SdkField<DefaultMaintenanceConfiguration> DEFAULT_FIELD = SdkField
            .<DefaultMaintenanceConfiguration> builder(MarshallingType.SDK_POJO).memberName("Default")
            .getter(getter(MaintenanceConfiguration::defaultValue)).setter(setter(Builder::defaultValue))
            .constructor(DefaultMaintenanceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("default").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFERRED_DAY_TIME_FIELD,
            DEFAULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PreferredDayTimeMaintenanceConfiguration preferredDayTime;

    private final DefaultMaintenanceConfiguration defaultValue;

    private final Type type;

    private MaintenanceConfiguration(BuilderImpl builder) {
        this.preferredDayTime = builder.preferredDayTime;
        this.defaultValue = builder.defaultValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * Preferred day and time maintenance configuration settings.
     * </p>
     * 
     * @return Preferred day and time maintenance configuration settings.
     */
    public final PreferredDayTimeMaintenanceConfiguration preferredDayTime() {
        return preferredDayTime;
    }

    /**
     * <p>
     * Default maintenance configuration settings.
     * </p>
     * 
     * @return Default maintenance configuration settings.
     */
    public final DefaultMaintenanceConfiguration defaultValue() {
        return defaultValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(preferredDayTime());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceConfiguration)) {
            return false;
        }
        MaintenanceConfiguration other = (MaintenanceConfiguration) obj;
        return Objects.equals(preferredDayTime(), other.preferredDayTime())
                && Objects.equals(defaultValue(), other.defaultValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MaintenanceConfiguration").add("PreferredDayTime", preferredDayTime())
                .add("Default", defaultValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PreferredDayTime":
            return Optional.ofNullable(clazz.cast(preferredDayTime()));
        case "Default":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #preferredDayTime()} initialized to the given value.
     *
     * <p>
     * Preferred day and time maintenance configuration settings.
     * </p>
     * 
     * @param preferredDayTime
     *        Preferred day and time maintenance configuration settings.
     */
    public static MaintenanceConfiguration fromPreferredDayTime(PreferredDayTimeMaintenanceConfiguration preferredDayTime) {
        return builder().preferredDayTime(preferredDayTime).build();
    }

    /**
     * Create an instance of this class with {@link #preferredDayTime()} initialized to the given value.
     *
     * <p>
     * Preferred day and time maintenance configuration settings.
     * </p>
     * 
     * @param preferredDayTime
     *        Preferred day and time maintenance configuration settings.
     */
    public static MaintenanceConfiguration fromPreferredDayTime(
            Consumer<PreferredDayTimeMaintenanceConfiguration.Builder> preferredDayTime) {
        PreferredDayTimeMaintenanceConfiguration.Builder builder = PreferredDayTimeMaintenanceConfiguration.builder();
        preferredDayTime.accept(builder);
        return fromPreferredDayTime(builder.build());
    }

    /**
     * Create an instance of this class with {@link #defaultValue()} initialized to the given value.
     *
     * <p>
     * Default maintenance configuration settings.
     * </p>
     * 
     * @param defaultValue
     *        Default maintenance configuration settings.
     */
    public static MaintenanceConfiguration fromDefaultValue(DefaultMaintenanceConfiguration defaultValue) {
        return builder().defaultValue(defaultValue).build();
    }

    /**
     * Create an instance of this class with {@link #defaultValue()} initialized to the given value.
     *
     * <p>
     * Default maintenance configuration settings.
     * </p>
     * 
     * @param defaultValue
     *        Default maintenance configuration settings.
     */
    public static MaintenanceConfiguration fromDefaultValue(Consumer<DefaultMaintenanceConfiguration.Builder> defaultValue) {
        DefaultMaintenanceConfiguration.Builder builder = DefaultMaintenanceConfiguration.builder();
        defaultValue.accept(builder);
        return fromDefaultValue(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("preferredDayTime", PREFERRED_DAY_TIME_FIELD);
        map.put("default", DEFAULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceConfiguration, T> g) {
        return obj -> g.apply((MaintenanceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaintenanceConfiguration> {
        /**
         * <p>
         * Preferred day and time maintenance configuration settings.
         * </p>
         * 
         * @param preferredDayTime
         *        Preferred day and time maintenance configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredDayTime(PreferredDayTimeMaintenanceConfiguration preferredDayTime);

        /**
         * <p>
         * Preferred day and time maintenance configuration settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PreferredDayTimeMaintenanceConfiguration.Builder} avoiding the need to create one manually via
         * {@link PreferredDayTimeMaintenanceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PreferredDayTimeMaintenanceConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #preferredDayTime(PreferredDayTimeMaintenanceConfiguration)}.
         * 
         * @param preferredDayTime
         *        a consumer that will call methods on {@link PreferredDayTimeMaintenanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preferredDayTime(PreferredDayTimeMaintenanceConfiguration)
         */
        default Builder preferredDayTime(Consumer<PreferredDayTimeMaintenanceConfiguration.Builder> preferredDayTime) {
            return preferredDayTime(PreferredDayTimeMaintenanceConfiguration.builder().applyMutation(preferredDayTime).build());
        }

        /**
         * <p>
         * Default maintenance configuration settings.
         * </p>
         * 
         * @param defaultValue
         *        Default maintenance configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(DefaultMaintenanceConfiguration defaultValue);

        /**
         * <p>
         * Default maintenance configuration settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultMaintenanceConfiguration.Builder}
         * avoiding the need to create one manually via {@link DefaultMaintenanceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultMaintenanceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultValue(DefaultMaintenanceConfiguration)}.
         * 
         * @param defaultValue
         *        a consumer that will call methods on {@link DefaultMaintenanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultValue(DefaultMaintenanceConfiguration)
         */
        default Builder defaultValue(Consumer<DefaultMaintenanceConfiguration.Builder> defaultValue) {
            return defaultValue(DefaultMaintenanceConfiguration.builder().applyMutation(defaultValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PreferredDayTimeMaintenanceConfiguration preferredDayTime;

        private DefaultMaintenanceConfiguration defaultValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceConfiguration model) {
            preferredDayTime(model.preferredDayTime);
            defaultValue(model.defaultValue);
        }

        public final PreferredDayTimeMaintenanceConfiguration.Builder getPreferredDayTime() {
            return preferredDayTime != null ? preferredDayTime.toBuilder() : null;
        }

        public final void setPreferredDayTime(PreferredDayTimeMaintenanceConfiguration.BuilderImpl preferredDayTime) {
            Object oldValue = this.preferredDayTime;
            this.preferredDayTime = preferredDayTime != null ? preferredDayTime.build() : null;
            handleUnionValueChange(Type.PREFERRED_DAY_TIME, oldValue, this.preferredDayTime);
        }

        @Override
        public final Builder preferredDayTime(PreferredDayTimeMaintenanceConfiguration preferredDayTime) {
            Object oldValue = this.preferredDayTime;
            this.preferredDayTime = preferredDayTime;
            handleUnionValueChange(Type.PREFERRED_DAY_TIME, oldValue, this.preferredDayTime);
            return this;
        }

        public final DefaultMaintenanceConfiguration.Builder getDefaultValue() {
            return defaultValue != null ? defaultValue.toBuilder() : null;
        }

        public final void setDefaultValue(DefaultMaintenanceConfiguration.BuilderImpl defaultValue) {
            Object oldValue = this.defaultValue;
            this.defaultValue = defaultValue != null ? defaultValue.build() : null;
            handleUnionValueChange(Type.DEFAULT, oldValue, this.defaultValue);
        }

        @Override
        public final Builder defaultValue(DefaultMaintenanceConfiguration defaultValue) {
            Object oldValue = this.defaultValue;
            this.defaultValue = defaultValue;
            handleUnionValueChange(Type.DEFAULT, oldValue, this.defaultValue);
            return this;
        }

        @Override
        public MaintenanceConfiguration build() {
            return new MaintenanceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see MaintenanceConfiguration#type()
     */
    public enum Type {
        PREFERRED_DAY_TIME,

        DEFAULT,

        UNKNOWN_TO_SDK_VERSION
    }
}
