/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a router network interface, including its name, type, ARN, ID, associated input/output counts, state,
 * and other key details. This structure is used in the response of the ListRouterNetworkInterfaces operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListedRouterNetworkInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<ListedRouterNetworkInterface.Builder, ListedRouterNetworkInterface> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ListedRouterNetworkInterface::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ListedRouterNetworkInterface::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ListedRouterNetworkInterface::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceType").getter(getter(ListedRouterNetworkInterface::networkInterfaceTypeAsString))
            .setter(setter(Builder::networkInterfaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceType").build())
            .build();

    private static final SdkField<Integer> ASSOCIATED_OUTPUT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AssociatedOutputCount").getter(getter(ListedRouterNetworkInterface::associatedOutputCount))
            .setter(setter(Builder::associatedOutputCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedOutputCount").build())
            .build();

    private static final SdkField<Integer> ASSOCIATED_INPUT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AssociatedInputCount").getter(getter(ListedRouterNetworkInterface::associatedInputCount))
            .setter(setter(Builder::associatedInputCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedInputCount").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ListedRouterNetworkInterface::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(ListedRouterNetworkInterface::regionName))
            .setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(ListedRouterNetworkInterface::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt")
            .getter(getter(ListedRouterNetworkInterface::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            ID_FIELD, NETWORK_INTERFACE_TYPE_FIELD, ASSOCIATED_OUTPUT_COUNT_FIELD, ASSOCIATED_INPUT_COUNT_FIELD, STATE_FIELD,
            REGION_NAME_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String id;

    private final String networkInterfaceType;

    private final Integer associatedOutputCount;

    private final Integer associatedInputCount;

    private final String state;

    private final String regionName;

    private final Instant createdAt;

    private final Instant updatedAt;

    private ListedRouterNetworkInterface(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.id = builder.id;
        this.networkInterfaceType = builder.networkInterfaceType;
        this.associatedOutputCount = builder.associatedOutputCount;
        this.associatedInputCount = builder.associatedInputCount;
        this.state = builder.state;
        this.regionName = builder.regionName;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The name of the router network interface.
     * </p>
     * 
     * @return The name of the router network interface.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the router network interface.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the router network interface.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier of the router network interface.
     * </p>
     * 
     * @return The unique identifier of the router network interface.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of the router network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #networkInterfaceType} will return {@link RouterNetworkInterfaceType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #networkInterfaceTypeAsString}.
     * </p>
     * 
     * @return The type of the router network interface.
     * @see RouterNetworkInterfaceType
     */
    public final RouterNetworkInterfaceType networkInterfaceType() {
        return RouterNetworkInterfaceType.fromValue(networkInterfaceType);
    }

    /**
     * <p>
     * The type of the router network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #networkInterfaceType} will return {@link RouterNetworkInterfaceType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #networkInterfaceTypeAsString}.
     * </p>
     * 
     * @return The type of the router network interface.
     * @see RouterNetworkInterfaceType
     */
    public final String networkInterfaceTypeAsString() {
        return networkInterfaceType;
    }

    /**
     * <p>
     * The number of router outputs associated with the network interface.
     * </p>
     * 
     * @return The number of router outputs associated with the network interface.
     */
    public final Integer associatedOutputCount() {
        return associatedOutputCount;
    }

    /**
     * <p>
     * The number of router inputs associated with the network interface.
     * </p>
     * 
     * @return The number of router inputs associated with the network interface.
     */
    public final Integer associatedInputCount() {
        return associatedInputCount;
    }

    /**
     * <p>
     * The current state of the router network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RouterNetworkInterfaceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the router network interface.
     * @see RouterNetworkInterfaceState
     */
    public final RouterNetworkInterfaceState state() {
        return RouterNetworkInterfaceState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the router network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RouterNetworkInterfaceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the router network interface.
     * @see RouterNetworkInterfaceState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The AWS Region where the router network interface is located.
     * </p>
     * 
     * @return The AWS Region where the router network interface is located.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The timestamp when the network interface was created.
     * </p>
     * 
     * @return The timestamp when the network interface was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the router network interface was last updated.
     * </p>
     * 
     * @return The timestamp when the router network interface was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associatedOutputCount());
        hashCode = 31 * hashCode + Objects.hashCode(associatedInputCount());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedRouterNetworkInterface)) {
            return false;
        }
        ListedRouterNetworkInterface other = (ListedRouterNetworkInterface) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(networkInterfaceTypeAsString(), other.networkInterfaceTypeAsString())
                && Objects.equals(associatedOutputCount(), other.associatedOutputCount())
                && Objects.equals(associatedInputCount(), other.associatedInputCount())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(regionName(), other.regionName())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListedRouterNetworkInterface").add("Name", name()).add("Arn", arn()).add("Id", id())
                .add("NetworkInterfaceType", networkInterfaceTypeAsString())
                .add("AssociatedOutputCount", associatedOutputCount()).add("AssociatedInputCount", associatedInputCount())
                .add("State", stateAsString()).add("RegionName", regionName()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "NetworkInterfaceType":
            return Optional.ofNullable(clazz.cast(networkInterfaceTypeAsString()));
        case "AssociatedOutputCount":
            return Optional.ofNullable(clazz.cast(associatedOutputCount()));
        case "AssociatedInputCount":
            return Optional.ofNullable(clazz.cast(associatedInputCount()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("networkInterfaceType", NETWORK_INTERFACE_TYPE_FIELD);
        map.put("associatedOutputCount", ASSOCIATED_OUTPUT_COUNT_FIELD);
        map.put("associatedInputCount", ASSOCIATED_INPUT_COUNT_FIELD);
        map.put("state", STATE_FIELD);
        map.put("regionName", REGION_NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListedRouterNetworkInterface, T> g) {
        return obj -> g.apply((ListedRouterNetworkInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListedRouterNetworkInterface> {
        /**
         * <p>
         * The name of the router network interface.
         * </p>
         * 
         * @param name
         *        The name of the router network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the router network interface.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the router network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier of the router network interface.
         * </p>
         * 
         * @param id
         *        The unique identifier of the router network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of the router network interface.
         * </p>
         * 
         * @param networkInterfaceType
         *        The type of the router network interface.
         * @see RouterNetworkInterfaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterNetworkInterfaceType
         */
        Builder networkInterfaceType(String networkInterfaceType);

        /**
         * <p>
         * The type of the router network interface.
         * </p>
         * 
         * @param networkInterfaceType
         *        The type of the router network interface.
         * @see RouterNetworkInterfaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterNetworkInterfaceType
         */
        Builder networkInterfaceType(RouterNetworkInterfaceType networkInterfaceType);

        /**
         * <p>
         * The number of router outputs associated with the network interface.
         * </p>
         * 
         * @param associatedOutputCount
         *        The number of router outputs associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedOutputCount(Integer associatedOutputCount);

        /**
         * <p>
         * The number of router inputs associated with the network interface.
         * </p>
         * 
         * @param associatedInputCount
         *        The number of router inputs associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedInputCount(Integer associatedInputCount);

        /**
         * <p>
         * The current state of the router network interface.
         * </p>
         * 
         * @param state
         *        The current state of the router network interface.
         * @see RouterNetworkInterfaceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterNetworkInterfaceState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the router network interface.
         * </p>
         * 
         * @param state
         *        The current state of the router network interface.
         * @see RouterNetworkInterfaceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterNetworkInterfaceState
         */
        Builder state(RouterNetworkInterfaceState state);

        /**
         * <p>
         * The AWS Region where the router network interface is located.
         * </p>
         * 
         * @param regionName
         *        The AWS Region where the router network interface is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The timestamp when the network interface was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the network interface was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the router network interface was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the router network interface was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String id;

        private String networkInterfaceType;

        private Integer associatedOutputCount;

        private Integer associatedInputCount;

        private String state;

        private String regionName;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedRouterNetworkInterface model) {
            name(model.name);
            arn(model.arn);
            id(model.id);
            networkInterfaceType(model.networkInterfaceType);
            associatedOutputCount(model.associatedOutputCount);
            associatedInputCount(model.associatedInputCount);
            state(model.state);
            regionName(model.regionName);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getNetworkInterfaceType() {
            return networkInterfaceType;
        }

        public final void setNetworkInterfaceType(String networkInterfaceType) {
            this.networkInterfaceType = networkInterfaceType;
        }

        @Override
        public final Builder networkInterfaceType(String networkInterfaceType) {
            this.networkInterfaceType = networkInterfaceType;
            return this;
        }

        @Override
        public final Builder networkInterfaceType(RouterNetworkInterfaceType networkInterfaceType) {
            this.networkInterfaceType(networkInterfaceType == null ? null : networkInterfaceType.toString());
            return this;
        }

        public final Integer getAssociatedOutputCount() {
            return associatedOutputCount;
        }

        public final void setAssociatedOutputCount(Integer associatedOutputCount) {
            this.associatedOutputCount = associatedOutputCount;
        }

        @Override
        public final Builder associatedOutputCount(Integer associatedOutputCount) {
            this.associatedOutputCount = associatedOutputCount;
            return this;
        }

        public final Integer getAssociatedInputCount() {
            return associatedInputCount;
        }

        public final void setAssociatedInputCount(Integer associatedInputCount) {
            this.associatedInputCount = associatedInputCount;
        }

        @Override
        public final Builder associatedInputCount(Integer associatedInputCount) {
            this.associatedInputCount = associatedInputCount;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouterNetworkInterfaceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public ListedRouterNetworkInterface build() {
            return new ListedRouterNetworkInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
