/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for a failover router input that allows switching between two input sources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailoverRouterInputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FailoverRouterInputConfiguration.Builder, FailoverRouterInputConfiguration> {
    private static final SdkField<String> NETWORK_INTERFACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceArn").getter(getter(FailoverRouterInputConfiguration::networkInterfaceArn))
            .setter(setter(Builder::networkInterfaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceArn").build())
            .build();

    private static final SdkField<List<FailoverRouterInputProtocolConfiguration>> PROTOCOL_CONFIGURATIONS_FIELD = SdkField
            .<List<FailoverRouterInputProtocolConfiguration>> builder(MarshallingType.LIST)
            .memberName("ProtocolConfigurations")
            .getter(getter(FailoverRouterInputConfiguration::protocolConfigurations))
            .setter(setter(Builder::protocolConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailoverRouterInputProtocolConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailoverRouterInputProtocolConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_PRIORITY_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourcePriorityMode").getter(getter(FailoverRouterInputConfiguration::sourcePriorityModeAsString))
            .setter(setter(Builder::sourcePriorityMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePriorityMode").build())
            .build();

    private static final SdkField<Integer> PRIMARY_SOURCE_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PrimarySourceIndex").getter(getter(FailoverRouterInputConfiguration::primarySourceIndex))
            .setter(setter(Builder::primarySourceIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primarySourceIndex").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ARN_FIELD,
            PROTOCOL_CONFIGURATIONS_FIELD, SOURCE_PRIORITY_MODE_FIELD, PRIMARY_SOURCE_INDEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String networkInterfaceArn;

    private final List<FailoverRouterInputProtocolConfiguration> protocolConfigurations;

    private final String sourcePriorityMode;

    private final Integer primarySourceIndex;

    private FailoverRouterInputConfiguration(BuilderImpl builder) {
        this.networkInterfaceArn = builder.networkInterfaceArn;
        this.protocolConfigurations = builder.protocolConfigurations;
        this.sourcePriorityMode = builder.sourcePriorityMode;
        this.primarySourceIndex = builder.primarySourceIndex;
    }

    /**
     * <p>
     * The ARN of the network interface to use for this failover router input.
     * </p>
     * 
     * @return The ARN of the network interface to use for this failover router input.
     */
    public final String networkInterfaceArn() {
        return networkInterfaceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProtocolConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProtocolConfigurations() {
        return protocolConfigurations != null && !(protocolConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of exactly two protocol configurations for the failover input sources. Both must use the same protocol
     * type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtocolConfigurations} method.
     * </p>
     * 
     * @return A list of exactly two protocol configurations for the failover input sources. Both must use the same
     *         protocol type.
     */
    public final List<FailoverRouterInputProtocolConfiguration> protocolConfigurations() {
        return protocolConfigurations;
    }

    /**
     * <p>
     * The mode for determining source priority in failover configurations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourcePriorityMode} will return {@link FailoverInputSourcePriorityMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #sourcePriorityModeAsString}.
     * </p>
     * 
     * @return The mode for determining source priority in failover configurations.
     * @see FailoverInputSourcePriorityMode
     */
    public final FailoverInputSourcePriorityMode sourcePriorityMode() {
        return FailoverInputSourcePriorityMode.fromValue(sourcePriorityMode);
    }

    /**
     * <p>
     * The mode for determining source priority in failover configurations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourcePriorityMode} will return {@link FailoverInputSourcePriorityMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #sourcePriorityModeAsString}.
     * </p>
     * 
     * @return The mode for determining source priority in failover configurations.
     * @see FailoverInputSourcePriorityMode
     */
    public final String sourcePriorityModeAsString() {
        return sourcePriorityMode;
    }

    /**
     * <p>
     * The index (0 or 1) that specifies which source in the protocol configurations list is currently active. Used to
     * control which of the two failover sources is currently selected. This field is ignored when sourcePriorityMode is
     * set to NO_PRIORITY
     * </p>
     * 
     * @return The index (0 or 1) that specifies which source in the protocol configurations list is currently active.
     *         Used to control which of the two failover sources is currently selected. This field is ignored when
     *         sourcePriorityMode is set to NO_PRIORITY
     */
    public final Integer primarySourceIndex() {
        return primarySourceIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasProtocolConfigurations() ? protocolConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourcePriorityModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(primarySourceIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverRouterInputConfiguration)) {
            return false;
        }
        FailoverRouterInputConfiguration other = (FailoverRouterInputConfiguration) obj;
        return Objects.equals(networkInterfaceArn(), other.networkInterfaceArn())
                && hasProtocolConfigurations() == other.hasProtocolConfigurations()
                && Objects.equals(protocolConfigurations(), other.protocolConfigurations())
                && Objects.equals(sourcePriorityModeAsString(), other.sourcePriorityModeAsString())
                && Objects.equals(primarySourceIndex(), other.primarySourceIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailoverRouterInputConfiguration").add("NetworkInterfaceArn", networkInterfaceArn())
                .add("ProtocolConfigurations", hasProtocolConfigurations() ? protocolConfigurations() : null)
                .add("SourcePriorityMode", sourcePriorityModeAsString()).add("PrimarySourceIndex", primarySourceIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfaceArn":
            return Optional.ofNullable(clazz.cast(networkInterfaceArn()));
        case "ProtocolConfigurations":
            return Optional.ofNullable(clazz.cast(protocolConfigurations()));
        case "SourcePriorityMode":
            return Optional.ofNullable(clazz.cast(sourcePriorityModeAsString()));
        case "PrimarySourceIndex":
            return Optional.ofNullable(clazz.cast(primarySourceIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("networkInterfaceArn", NETWORK_INTERFACE_ARN_FIELD);
        map.put("protocolConfigurations", PROTOCOL_CONFIGURATIONS_FIELD);
        map.put("sourcePriorityMode", SOURCE_PRIORITY_MODE_FIELD);
        map.put("primarySourceIndex", PRIMARY_SOURCE_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailoverRouterInputConfiguration, T> g) {
        return obj -> g.apply((FailoverRouterInputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailoverRouterInputConfiguration> {
        /**
         * <p>
         * The ARN of the network interface to use for this failover router input.
         * </p>
         * 
         * @param networkInterfaceArn
         *        The ARN of the network interface to use for this failover router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceArn(String networkInterfaceArn);

        /**
         * <p>
         * A list of exactly two protocol configurations for the failover input sources. Both must use the same protocol
         * type.
         * </p>
         * 
         * @param protocolConfigurations
         *        A list of exactly two protocol configurations for the failover input sources. Both must use the same
         *        protocol type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolConfigurations(Collection<FailoverRouterInputProtocolConfiguration> protocolConfigurations);

        /**
         * <p>
         * A list of exactly two protocol configurations for the failover input sources. Both must use the same protocol
         * type.
         * </p>
         * 
         * @param protocolConfigurations
         *        A list of exactly two protocol configurations for the failover input sources. Both must use the same
         *        protocol type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolConfigurations(FailoverRouterInputProtocolConfiguration... protocolConfigurations);

        /**
         * <p>
         * A list of exactly two protocol configurations for the failover input sources. Both must use the same protocol
         * type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.FailoverRouterInputProtocolConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.FailoverRouterInputProtocolConfiguration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.FailoverRouterInputProtocolConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #protocolConfigurations(List<FailoverRouterInputProtocolConfiguration>)}.
         * 
         * @param protocolConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.FailoverRouterInputProtocolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protocolConfigurations(java.util.Collection<FailoverRouterInputProtocolConfiguration>)
         */
        Builder protocolConfigurations(Consumer<FailoverRouterInputProtocolConfiguration.Builder>... protocolConfigurations);

        /**
         * <p>
         * The mode for determining source priority in failover configurations.
         * </p>
         * 
         * @param sourcePriorityMode
         *        The mode for determining source priority in failover configurations.
         * @see FailoverInputSourcePriorityMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailoverInputSourcePriorityMode
         */
        Builder sourcePriorityMode(String sourcePriorityMode);

        /**
         * <p>
         * The mode for determining source priority in failover configurations.
         * </p>
         * 
         * @param sourcePriorityMode
         *        The mode for determining source priority in failover configurations.
         * @see FailoverInputSourcePriorityMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailoverInputSourcePriorityMode
         */
        Builder sourcePriorityMode(FailoverInputSourcePriorityMode sourcePriorityMode);

        /**
         * <p>
         * The index (0 or 1) that specifies which source in the protocol configurations list is currently active. Used
         * to control which of the two failover sources is currently selected. This field is ignored when
         * sourcePriorityMode is set to NO_PRIORITY
         * </p>
         * 
         * @param primarySourceIndex
         *        The index (0 or 1) that specifies which source in the protocol configurations list is currently
         *        active. Used to control which of the two failover sources is currently selected. This field is ignored
         *        when sourcePriorityMode is set to NO_PRIORITY
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primarySourceIndex(Integer primarySourceIndex);
    }

    static final class BuilderImpl implements Builder {
        private String networkInterfaceArn;

        private List<FailoverRouterInputProtocolConfiguration> protocolConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String sourcePriorityMode;

        private Integer primarySourceIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverRouterInputConfiguration model) {
            networkInterfaceArn(model.networkInterfaceArn);
            protocolConfigurations(model.protocolConfigurations);
            sourcePriorityMode(model.sourcePriorityMode);
            primarySourceIndex(model.primarySourceIndex);
        }

        public final String getNetworkInterfaceArn() {
            return networkInterfaceArn;
        }

        public final void setNetworkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
        }

        @Override
        public final Builder networkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
            return this;
        }

        public final List<FailoverRouterInputProtocolConfiguration.Builder> getProtocolConfigurations() {
            List<FailoverRouterInputProtocolConfiguration.Builder> result = FailoverRouterInputProtocolConfigurationListCopier
                    .copyToBuilder(this.protocolConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProtocolConfigurations(
                Collection<FailoverRouterInputProtocolConfiguration.BuilderImpl> protocolConfigurations) {
            this.protocolConfigurations = FailoverRouterInputProtocolConfigurationListCopier
                    .copyFromBuilder(protocolConfigurations);
        }

        @Override
        public final Builder protocolConfigurations(Collection<FailoverRouterInputProtocolConfiguration> protocolConfigurations) {
            this.protocolConfigurations = FailoverRouterInputProtocolConfigurationListCopier.copy(protocolConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolConfigurations(FailoverRouterInputProtocolConfiguration... protocolConfigurations) {
            protocolConfigurations(Arrays.asList(protocolConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolConfigurations(
                Consumer<FailoverRouterInputProtocolConfiguration.Builder>... protocolConfigurations) {
            protocolConfigurations(Stream.of(protocolConfigurations)
                    .map(c -> FailoverRouterInputProtocolConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSourcePriorityMode() {
            return sourcePriorityMode;
        }

        public final void setSourcePriorityMode(String sourcePriorityMode) {
            this.sourcePriorityMode = sourcePriorityMode;
        }

        @Override
        public final Builder sourcePriorityMode(String sourcePriorityMode) {
            this.sourcePriorityMode = sourcePriorityMode;
            return this;
        }

        @Override
        public final Builder sourcePriorityMode(FailoverInputSourcePriorityMode sourcePriorityMode) {
            this.sourcePriorityMode(sourcePriorityMode == null ? null : sourcePriorityMode.toString());
            return this;
        }

        public final Integer getPrimarySourceIndex() {
            return primarySourceIndex;
        }

        public final void setPrimarySourceIndex(Integer primarySourceIndex) {
            this.primarySourceIndex = primarySourceIndex;
        }

        @Override
        public final Builder primarySourceIndex(Integer primarySourceIndex) {
            this.primarySourceIndex = primarySourceIndex;
            return this;
        }

        @Override
        public FailoverRouterInputConfiguration build() {
            return new FailoverRouterInputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
