/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The bridge's source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BridgeSource implements SdkPojo, Serializable, ToCopyableBuilder<BridgeSource.Builder, BridgeSource> {
    private static final SdkField<BridgeFlowSource> FLOW_SOURCE_FIELD = SdkField
            .<BridgeFlowSource> builder(MarshallingType.SDK_POJO).memberName("FlowSource")
            .getter(getter(BridgeSource::flowSource)).setter(setter(Builder::flowSource)).constructor(BridgeFlowSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowSource").build()).build();

    private static final SdkField<BridgeNetworkSource> NETWORK_SOURCE_FIELD = SdkField
            .<BridgeNetworkSource> builder(MarshallingType.SDK_POJO).memberName("NetworkSource")
            .getter(getter(BridgeSource::networkSource)).setter(setter(Builder::networkSource))
            .constructor(BridgeNetworkSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_SOURCE_FIELD,
            NETWORK_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BridgeFlowSource flowSource;

    private final BridgeNetworkSource networkSource;

    private BridgeSource(BuilderImpl builder) {
        this.flowSource = builder.flowSource;
        this.networkSource = builder.networkSource;
    }

    /**
     * <p>
     * The source of the associated flow.
     * </p>
     * 
     * @return The source of the associated flow.
     */
    public final BridgeFlowSource flowSource() {
        return flowSource;
    }

    /**
     * <p>
     * The network source for the bridge.
     * </p>
     * 
     * @return The network source for the bridge.
     */
    public final BridgeNetworkSource networkSource() {
        return networkSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowSource());
        hashCode = 31 * hashCode + Objects.hashCode(networkSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BridgeSource)) {
            return false;
        }
        BridgeSource other = (BridgeSource) obj;
        return Objects.equals(flowSource(), other.flowSource()) && Objects.equals(networkSource(), other.networkSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BridgeSource").add("FlowSource", flowSource()).add("NetworkSource", networkSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowSource":
            return Optional.ofNullable(clazz.cast(flowSource()));
        case "NetworkSource":
            return Optional.ofNullable(clazz.cast(networkSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("flowSource", FLOW_SOURCE_FIELD);
        map.put("networkSource", NETWORK_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BridgeSource, T> g) {
        return obj -> g.apply((BridgeSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BridgeSource> {
        /**
         * <p>
         * The source of the associated flow.
         * </p>
         * 
         * @param flowSource
         *        The source of the associated flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowSource(BridgeFlowSource flowSource);

        /**
         * <p>
         * The source of the associated flow.
         * </p>
         * This is a convenience method that creates an instance of the {@link BridgeFlowSource.Builder} avoiding the
         * need to create one manually via {@link BridgeFlowSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BridgeFlowSource.Builder#build()} is called immediately and its
         * result is passed to {@link #flowSource(BridgeFlowSource)}.
         * 
         * @param flowSource
         *        a consumer that will call methods on {@link BridgeFlowSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowSource(BridgeFlowSource)
         */
        default Builder flowSource(Consumer<BridgeFlowSource.Builder> flowSource) {
            return flowSource(BridgeFlowSource.builder().applyMutation(flowSource).build());
        }

        /**
         * <p>
         * The network source for the bridge.
         * </p>
         * 
         * @param networkSource
         *        The network source for the bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSource(BridgeNetworkSource networkSource);

        /**
         * <p>
         * The network source for the bridge.
         * </p>
         * This is a convenience method that creates an instance of the {@link BridgeNetworkSource.Builder} avoiding the
         * need to create one manually via {@link BridgeNetworkSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BridgeNetworkSource.Builder#build()} is called immediately and
         * its result is passed to {@link #networkSource(BridgeNetworkSource)}.
         * 
         * @param networkSource
         *        a consumer that will call methods on {@link BridgeNetworkSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkSource(BridgeNetworkSource)
         */
        default Builder networkSource(Consumer<BridgeNetworkSource.Builder> networkSource) {
            return networkSource(BridgeNetworkSource.builder().applyMutation(networkSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BridgeFlowSource flowSource;

        private BridgeNetworkSource networkSource;

        private BuilderImpl() {
        }

        private BuilderImpl(BridgeSource model) {
            flowSource(model.flowSource);
            networkSource(model.networkSource);
        }

        public final BridgeFlowSource.Builder getFlowSource() {
            return flowSource != null ? flowSource.toBuilder() : null;
        }

        public final void setFlowSource(BridgeFlowSource.BuilderImpl flowSource) {
            this.flowSource = flowSource != null ? flowSource.build() : null;
        }

        @Override
        public final Builder flowSource(BridgeFlowSource flowSource) {
            this.flowSource = flowSource;
            return this;
        }

        public final BridgeNetworkSource.Builder getNetworkSource() {
            return networkSource != null ? networkSource.toBuilder() : null;
        }

        public final void setNetworkSource(BridgeNetworkSource.BuilderImpl networkSource) {
            this.networkSource = networkSource != null ? networkSource.build() : null;
        }

        @Override
        public final Builder networkSource(BridgeNetworkSource networkSource) {
            this.networkSource = networkSource;
            return this;
        }

        @Override
        public BridgeSource build() {
            return new BridgeSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
