/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.mediaconnect.internal.MediaConnectServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.mediaconnect.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourcesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourcesResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowMediaStreamsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowMediaStreamsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputs420Exception;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowSourcesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowSourcesResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowVpcInterfacesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowVpcInterfacesResponse;
import software.amazon.awssdk.services.mediaconnect.model.BadRequestException;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.ConflictException;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridge420Exception;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlow420Exception;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateGateway420Exception;
import software.amazon.awssdk.services.mediaconnect.model.CreateGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeregisterGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeregisterGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceMetadataRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceMetadataResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceThumbnailRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceThumbnailResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeOfferingRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeOfferingResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeReservationRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeReservationResponse;
import software.amazon.awssdk.services.mediaconnect.model.ForbiddenException;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputSourceMetadataRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputSourceMetadataResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputThumbnailRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputThumbnailResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlements420Exception;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlementsRequest;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlementsResponse;
import software.amazon.awssdk.services.mediaconnect.model.InternalServerErrorException;
import software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListBridgesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewaysResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListOfferingsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListReservationsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForGlobalResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForGlobalResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectException;
import software.amazon.awssdk.services.mediaconnect.model.NotFoundException;
import software.amazon.awssdk.services.mediaconnect.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.mediaconnect.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowMediaStreamRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowMediaStreamResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowVpcInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowVpcInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RevokeFlowEntitlementRequest;
import software.amazon.awssdk.services.mediaconnect.model.RevokeFlowEntitlementResponse;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputServiceQuotaExceededException;
import software.amazon.awssdk.services.mediaconnect.model.RouterNetworkInterfaceServiceQuotaExceededException;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputServiceQuotaExceededException;
import software.amazon.awssdk.services.mediaconnect.model.ServiceUnavailableException;
import software.amazon.awssdk.services.mediaconnect.model.StartFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.StartFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.StopFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.StopFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.TagGlobalResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.TagGlobalResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.TagResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.TagResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.TakeRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.TakeRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.TooManyRequestsException;
import software.amazon.awssdk.services.mediaconnect.model.UntagGlobalResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UntagGlobalResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UntagResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UntagResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeStateRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeStateResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowEntitlementRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowEntitlementResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowMediaStreamRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowMediaStreamResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.transform.AddBridgeOutputsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddBridgeSourcesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddFlowMediaStreamsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddFlowOutputsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddFlowSourcesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddFlowVpcInterfacesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.BatchGetRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.BatchGetRouterNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.BatchGetRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateBridgeRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateGatewayRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateRouterNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteBridgeRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteGatewayRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteRouterNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeregisterGatewayInstanceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeBridgeRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeFlowSourceMetadataRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeFlowSourceThumbnailRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeGatewayInstanceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeGatewayRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeOfferingRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeReservationRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GetRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GetRouterInputSourceMetadataRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GetRouterInputThumbnailRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GetRouterNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GetRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GrantFlowEntitlementsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListBridgesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListEntitlementsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListFlowsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListGatewayInstancesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListGatewaysRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListOfferingsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListReservationsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListRouterInputsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListRouterNetworkInterfacesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListRouterOutputsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListTagsForGlobalResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.PurchaseOfferingRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveBridgeOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveBridgeSourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveFlowMediaStreamRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveFlowOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveFlowSourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveFlowVpcInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RestartRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RestartRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RevokeFlowEntitlementRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StartFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StartRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StartRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StopFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StopRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StopRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.TagGlobalResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.TakeRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UntagGlobalResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateBridgeOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateBridgeRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateBridgeSourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateBridgeStateRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowEntitlementRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowMediaStreamRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowSourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateGatewayInstanceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateRouterNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.waiters.MediaConnectAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link MediaConnectAsyncClient}.
 *
 * @see MediaConnectAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultMediaConnectAsyncClient implements MediaConnectAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultMediaConnectAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultMediaConnectAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "MediaConnect" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * <p>
     * Adds outputs to an existing bridge.
     * </p>
     *
     * @param addBridgeOutputsRequest
     * @return A Java Future containing the result of the AddBridgeOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddBridgeOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddBridgeOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AddBridgeOutputsResponse> addBridgeOutputs(AddBridgeOutputsRequest addBridgeOutputsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addBridgeOutputsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addBridgeOutputsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddBridgeOutputs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddBridgeOutputsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddBridgeOutputsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AddBridgeOutputsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddBridgeOutputsRequest, AddBridgeOutputsResponse>()
                            .withOperationName("AddBridgeOutputs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddBridgeOutputsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addBridgeOutputsRequest));
            CompletableFuture<AddBridgeOutputsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds sources to an existing bridge.
     * </p>
     *
     * @param addBridgeSourcesRequest
     * @return A Java Future containing the result of the AddBridgeSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddBridgeSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddBridgeSources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AddBridgeSourcesResponse> addBridgeSources(AddBridgeSourcesRequest addBridgeSourcesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addBridgeSourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addBridgeSourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddBridgeSources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddBridgeSourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddBridgeSourcesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AddBridgeSourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddBridgeSourcesRequest, AddBridgeSourcesResponse>()
                            .withOperationName("AddBridgeSources").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddBridgeSourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addBridgeSourcesRequest));
            CompletableFuture<AddBridgeSourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a
     * source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
     * </p>
     *
     * @param addFlowMediaStreamsRequest
     * @return A Java Future containing the result of the AddFlowMediaStreams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddFlowMediaStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowMediaStreams"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddFlowMediaStreamsResponse> addFlowMediaStreams(
            AddFlowMediaStreamsRequest addFlowMediaStreamsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addFlowMediaStreamsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addFlowMediaStreamsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddFlowMediaStreams");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddFlowMediaStreamsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddFlowMediaStreamsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AddFlowMediaStreamsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddFlowMediaStreamsRequest, AddFlowMediaStreamsResponse>()
                            .withOperationName("AddFlowMediaStreams").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddFlowMediaStreamsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addFlowMediaStreamsRequest));
            CompletableFuture<AddFlowMediaStreamsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds outputs to an existing flow. You can create up to 50 outputs per flow.
     * </p>
     *
     * @param addFlowOutputsRequest
     * @return A Java Future containing the result of the AddFlowOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>AddFlowOutputs420Exception Exception raised by Elemental MediaConnect when adding the flow output.
     *         See the error message for the operation for more information on the cause of this exception.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddFlowOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AddFlowOutputsResponse> addFlowOutputs(AddFlowOutputsRequest addFlowOutputsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addFlowOutputsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addFlowOutputsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddFlowOutputs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddFlowOutputsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddFlowOutputsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AddFlowOutputsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddFlowOutputsRequest, AddFlowOutputsResponse>()
                            .withOperationName("AddFlowOutputs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddFlowOutputsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addFlowOutputsRequest));
            CompletableFuture<AddFlowOutputsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds sources to a flow.
     * </p>
     *
     * @param addFlowSourcesRequest
     * @return A Java Future containing the result of the AddFlowSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddFlowSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowSources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AddFlowSourcesResponse> addFlowSources(AddFlowSourcesRequest addFlowSourcesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addFlowSourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addFlowSourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddFlowSources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddFlowSourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddFlowSourcesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AddFlowSourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddFlowSourcesRequest, AddFlowSourcesResponse>()
                            .withOperationName("AddFlowSources").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddFlowSourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addFlowSourcesRequest));
            CompletableFuture<AddFlowSourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds VPC interfaces to a flow.
     * </p>
     *
     * @param addFlowVpcInterfacesRequest
     * @return A Java Future containing the result of the AddFlowVpcInterfaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddFlowVpcInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowVpcInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddFlowVpcInterfacesResponse> addFlowVpcInterfaces(
            AddFlowVpcInterfacesRequest addFlowVpcInterfacesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addFlowVpcInterfacesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addFlowVpcInterfacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddFlowVpcInterfaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddFlowVpcInterfacesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddFlowVpcInterfacesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AddFlowVpcInterfacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddFlowVpcInterfacesRequest, AddFlowVpcInterfacesResponse>()
                            .withOperationName("AddFlowVpcInterfaces").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddFlowVpcInterfacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addFlowVpcInterfacesRequest));
            CompletableFuture<AddFlowVpcInterfacesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about multiple router inputs in AWS Elemental MediaConnect.
     * </p>
     *
     * @param batchGetRouterInputRequest
     * @return A Java Future containing the result of the BatchGetRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.BatchGetRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetRouterInputResponse> batchGetRouterInput(
            BatchGetRouterInputRequest batchGetRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetRouterInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetRouterInputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetRouterInputRequest, BatchGetRouterInputResponse>()
                            .withOperationName("BatchGetRouterInput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetRouterInputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetRouterInputRequest));
            CompletableFuture<BatchGetRouterInputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about multiple router network interfaces in AWS Elemental MediaConnect.
     * </p>
     *
     * @param batchGetRouterNetworkInterfaceRequest
     * @return A Java Future containing the result of the BatchGetRouterNetworkInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.BatchGetRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetRouterNetworkInterfaceResponse> batchGetRouterNetworkInterface(
            BatchGetRouterNetworkInterfaceRequest batchGetRouterNetworkInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetRouterNetworkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchGetRouterNetworkInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetRouterNetworkInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetRouterNetworkInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetRouterNetworkInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetRouterNetworkInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetRouterNetworkInterfaceRequest, BatchGetRouterNetworkInterfaceResponse>()
                            .withOperationName("BatchGetRouterNetworkInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetRouterNetworkInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetRouterNetworkInterfaceRequest));
            CompletableFuture<BatchGetRouterNetworkInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about multiple router outputs in AWS Elemental MediaConnect.
     * </p>
     *
     * @param batchGetRouterOutputRequest
     * @return A Java Future containing the result of the BatchGetRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.BatchGetRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetRouterOutputResponse> batchGetRouterOutput(
            BatchGetRouterOutputRequest batchGetRouterOutputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetRouterOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetRouterOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetRouterOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetRouterOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetRouterOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetRouterOutputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetRouterOutputRequest, BatchGetRouterOutputResponse>()
                            .withOperationName("BatchGetRouterOutput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetRouterOutputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetRouterOutputRequest));
            CompletableFuture<BatchGetRouterOutputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new bridge. The request must include one source.
     * </p>
     *
     * @param createBridgeRequest
     * @return A Java Future containing the result of the CreateBridge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>CreateBridge420Exception Exception raised by Elemental MediaConnect when creating the bridge. See the
     *         error message for the operation for more information on the cause of this exception.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateBridge" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBridgeResponse> createBridge(CreateBridgeRequest createBridgeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBridgeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBridgeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBridge");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBridgeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateBridgeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateBridgeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBridgeRequest, CreateBridgeResponse>()
                            .withOperationName("CreateBridge").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBridgeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createBridgeRequest));
            CompletableFuture<CreateBridgeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50)
     * and entitlements (up to 50).
     * </p>
     *
     * @param createFlowRequest
     * @return A Java Future containing the result of the CreateFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>CreateFlow420Exception Exception raised by Elemental MediaConnect when creating the flow. See the
     *         error message for the operation for more information on the cause of this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFlowResponse> createFlow(CreateFlowRequest createFlowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFlowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFlow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFlowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateFlowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateFlowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFlowRequest, CreateFlowResponse>().withOperationName("CreateFlow")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFlowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFlowRequest));
            CompletableFuture<CreateFlowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new gateway. The request must include at least one network (up to four).
     * </p>
     *
     * @param createGatewayRequest
     * @return A Java Future containing the result of the CreateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>CreateGateway420Exception Exception raised by Elemental MediaConnect when creating the gateway. See
     *         the error message for the operation for more information on the cause of this exception.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateGateway" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGatewayResponse> createGateway(CreateGatewayRequest createGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGatewayRequest, CreateGatewayResponse>()
                            .withOperationName("CreateGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createGatewayRequest));
            CompletableFuture<CreateGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param createRouterInputRequest
     * @return A Java Future containing the result of the CreateRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>RouterInputServiceQuotaExceededException The request to create a new router input would exceed the
     *         service quotas for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRouterInputResponse> createRouterInput(CreateRouterInputRequest createRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRouterInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateRouterInputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRouterInputRequest, CreateRouterInputResponse>()
                            .withOperationName("CreateRouterInput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRouterInputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRouterInputRequest));
            CompletableFuture<CreateRouterInputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new router network interface in AWS Elemental MediaConnect.
     * </p>
     *
     * @param createRouterNetworkInterfaceRequest
     * @return A Java Future containing the result of the CreateRouterNetworkInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>RouterNetworkInterfaceServiceQuotaExceededException The request to create a new router network
     *         interface would exceed the service quotas (limits) set for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRouterNetworkInterfaceResponse> createRouterNetworkInterface(
            CreateRouterNetworkInterfaceRequest createRouterNetworkInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRouterNetworkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRouterNetworkInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRouterNetworkInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRouterNetworkInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRouterNetworkInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateRouterNetworkInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRouterNetworkInterfaceRequest, CreateRouterNetworkInterfaceResponse>()
                            .withOperationName("CreateRouterNetworkInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRouterNetworkInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRouterNetworkInterfaceRequest));
            CompletableFuture<CreateRouterNetworkInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param createRouterOutputRequest
     * @return A Java Future containing the result of the CreateRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>RouterOutputServiceQuotaExceededException The request to create a new router output would exceed the
     *         service quotas (limits) set for the account.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRouterOutputResponse> createRouterOutput(CreateRouterOutputRequest createRouterOutputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRouterOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRouterOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRouterOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRouterOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRouterOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateRouterOutputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRouterOutputRequest, CreateRouterOutputResponse>()
                            .withOperationName("CreateRouterOutput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRouterOutputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRouterOutputRequest));
            CompletableFuture<CreateRouterOutputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a bridge. Before you can delete a bridge, you must stop the bridge.
     * </p>
     *
     * @param deleteBridgeRequest
     * @return A Java Future containing the result of the DeleteBridge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteBridge" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBridgeResponse> deleteBridge(DeleteBridgeRequest deleteBridgeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBridgeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBridgeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBridge");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBridgeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteBridgeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteBridgeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBridgeRequest, DeleteBridgeResponse>()
                            .withOperationName("DeleteBridge").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBridgeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBridgeRequest));
            CompletableFuture<DeleteBridgeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a flow. Before you can delete a flow, you must stop the flow.
     * </p>
     *
     * @param deleteFlowRequest
     * @return A Java Future containing the result of the DeleteFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteFlow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFlowResponse> deleteFlow(DeleteFlowRequest deleteFlowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFlowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFlow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFlowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteFlowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteFlowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFlowRequest, DeleteFlowResponse>().withOperationName("DeleteFlow")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFlowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFlowRequest));
            CompletableFuture<DeleteFlowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a gateway. Before you can delete a gateway, you must deregister its instances and delete its bridges.
     * </p>
     *
     * @param deleteGatewayRequest
     * @return A Java Future containing the result of the DeleteGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteGateway" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGatewayResponse> deleteGateway(DeleteGatewayRequest deleteGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGatewayRequest, DeleteGatewayResponse>()
                            .withOperationName("DeleteGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGatewayRequest));
            CompletableFuture<DeleteGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a router input from AWS Elemental MediaConnect.
     * </p>
     *
     * @param deleteRouterInputRequest
     * @return A Java Future containing the result of the DeleteRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRouterInputResponse> deleteRouterInput(DeleteRouterInputRequest deleteRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRouterInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteRouterInputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRouterInputRequest, DeleteRouterInputResponse>()
                            .withOperationName("DeleteRouterInput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRouterInputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRouterInputRequest));
            CompletableFuture<DeleteRouterInputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a router network interface from AWS Elemental MediaConnect.
     * </p>
     *
     * @param deleteRouterNetworkInterfaceRequest
     * @return A Java Future containing the result of the DeleteRouterNetworkInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRouterNetworkInterfaceResponse> deleteRouterNetworkInterface(
            DeleteRouterNetworkInterfaceRequest deleteRouterNetworkInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRouterNetworkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouterNetworkInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRouterNetworkInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRouterNetworkInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRouterNetworkInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteRouterNetworkInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRouterNetworkInterfaceRequest, DeleteRouterNetworkInterfaceResponse>()
                            .withOperationName("DeleteRouterNetworkInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRouterNetworkInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRouterNetworkInterfaceRequest));
            CompletableFuture<DeleteRouterNetworkInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a router output from AWS Elemental MediaConnect.
     * </p>
     *
     * @param deleteRouterOutputRequest
     * @return A Java Future containing the result of the DeleteRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRouterOutputResponse> deleteRouterOutput(DeleteRouterOutputRequest deleteRouterOutputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRouterOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouterOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRouterOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRouterOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRouterOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteRouterOutputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRouterOutputRequest, DeleteRouterOutputResponse>()
                            .withOperationName("DeleteRouterOutput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRouterOutputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRouterOutputRequest));
            CompletableFuture<DeleteRouterOutputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters an instance. Before you deregister an instance, all bridges running on the instance must be stopped.
     * If you want to deregister an instance without stopping the bridges, you must use the --force option.
     * </p>
     *
     * @param deregisterGatewayInstanceRequest
     * @return A Java Future containing the result of the DeregisterGatewayInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeregisterGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeregisterGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterGatewayInstanceResponse> deregisterGatewayInstance(
            DeregisterGatewayInstanceRequest deregisterGatewayInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterGatewayInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterGatewayInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterGatewayInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterGatewayInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterGatewayInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeregisterGatewayInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterGatewayInstanceRequest, DeregisterGatewayInstanceResponse>()
                            .withOperationName("DeregisterGatewayInstance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterGatewayInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterGatewayInstanceRequest));
            CompletableFuture<DeregisterGatewayInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays the details of a bridge.
     * </p>
     *
     * @param describeBridgeRequest
     * @return A Java Future containing the result of the DescribeBridge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeBridge" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBridgeResponse> describeBridge(DescribeBridgeRequest describeBridgeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBridgeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBridgeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBridge");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBridgeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeBridgeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeBridgeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBridgeRequest, DescribeBridgeResponse>()
                            .withOperationName("DescribeBridge").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeBridgeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeBridgeRequest));
            CompletableFuture<DescribeBridgeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays the details of a flow. The response includes the flow Amazon Resource Name (ARN), name, and Availability
     * Zone, as well as details about the source, outputs, and entitlements.
     * </p>
     *
     * @param describeFlowRequest
     * @return A Java Future containing the result of the DescribeFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFlowResponse> describeFlow(DescribeFlowRequest describeFlowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFlowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFlow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFlowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeFlowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFlowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFlowRequest, DescribeFlowResponse>()
                            .withOperationName("DescribeFlow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFlowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFlowRequest));
            CompletableFuture<DescribeFlowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The <code>DescribeFlowSourceMetadata</code> API is used to view information about the flow's source transport
     * stream and programs. This API displays status messages about the flow's source as well as details about the
     * program's video, audio, and other data.
     * </p>
     *
     * @param describeFlowSourceMetadataRequest
     * @return A Java Future containing the result of the DescribeFlowSourceMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeFlowSourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlowSourceMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFlowSourceMetadataResponse> describeFlowSourceMetadata(
            DescribeFlowSourceMetadataRequest describeFlowSourceMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFlowSourceMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFlowSourceMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFlowSourceMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFlowSourceMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFlowSourceMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFlowSourceMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFlowSourceMetadataRequest, DescribeFlowSourceMetadataResponse>()
                            .withOperationName("DescribeFlowSourceMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFlowSourceMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFlowSourceMetadataRequest));
            CompletableFuture<DescribeFlowSourceMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the thumbnail for the flow source.
     * </p>
     *
     * @param describeFlowSourceThumbnailRequest
     * @return A Java Future containing the result of the DescribeFlowSourceThumbnail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeFlowSourceThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlowSourceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFlowSourceThumbnailResponse> describeFlowSourceThumbnail(
            DescribeFlowSourceThumbnailRequest describeFlowSourceThumbnailRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFlowSourceThumbnailRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFlowSourceThumbnailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFlowSourceThumbnail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFlowSourceThumbnailResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFlowSourceThumbnailResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFlowSourceThumbnailResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFlowSourceThumbnailRequest, DescribeFlowSourceThumbnailResponse>()
                            .withOperationName("DescribeFlowSourceThumbnail").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFlowSourceThumbnailRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFlowSourceThumbnailRequest));
            CompletableFuture<DescribeFlowSourceThumbnailResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays the details of a gateway. The response includes the gateway Amazon Resource Name (ARN), name, and CIDR
     * blocks, as well as details about the networks.
     * </p>
     *
     * @param describeGatewayRequest
     * @return A Java Future containing the result of the DescribeGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeGateway" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGatewayResponse> describeGateway(DescribeGatewayRequest describeGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGatewayRequest, DescribeGatewayResponse>()
                            .withOperationName("DescribeGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeGatewayRequest));
            CompletableFuture<DescribeGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays the details of an instance.
     * </p>
     *
     * @param describeGatewayInstanceRequest
     * @return A Java Future containing the result of the DescribeGatewayInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGatewayInstanceResponse> describeGatewayInstance(
            DescribeGatewayInstanceRequest describeGatewayInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGatewayInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGatewayInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGatewayInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGatewayInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeGatewayInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeGatewayInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGatewayInstanceRequest, DescribeGatewayInstanceResponse>()
                            .withOperationName("DescribeGatewayInstance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeGatewayInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeGatewayInstanceRequest));
            CompletableFuture<DescribeGatewayInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays the details of an offering. The response includes the offering description, duration, outbound
     * bandwidth, price, and Amazon Resource Name (ARN).
     * </p>
     *
     * @param describeOfferingRequest
     * @return A Java Future containing the result of the DescribeOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeOffering" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOfferingResponse> describeOffering(DescribeOfferingRequest describeOfferingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOfferingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOfferingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOffering");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOfferingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeOfferingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeOfferingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOfferingRequest, DescribeOfferingResponse>()
                            .withOperationName("DescribeOffering").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeOfferingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeOfferingRequest));
            CompletableFuture<DescribeOfferingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays the details of a reservation. The response includes the reservation name, state, start date and time,
     * and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound
     * bandwidth).
     * </p>
     *
     * @param describeReservationRequest
     * @return A Java Future containing the result of the DescribeReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservationResponse> describeReservation(
            DescribeReservationRequest describeReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeReservationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservationRequest, DescribeReservationResponse>()
                            .withOperationName("DescribeReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReservationRequest));
            CompletableFuture<DescribeReservationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a specific router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param getRouterInputRequest
     * @return A Java Future containing the result of the GetRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GetRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRouterInputResponse> getRouterInput(GetRouterInputRequest getRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRouterInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetRouterInputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRouterInputRequest, GetRouterInputResponse>()
                            .withOperationName("GetRouterInput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRouterInputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRouterInputRequest));
            CompletableFuture<GetRouterInputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves detailed metadata information about a specific router input source, including stream details and
     * connection state.
     * </p>
     *
     * @param getRouterInputSourceMetadataRequest
     * @return A Java Future containing the result of the GetRouterInputSourceMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GetRouterInputSourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInputSourceMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRouterInputSourceMetadataResponse> getRouterInputSourceMetadata(
            GetRouterInputSourceMetadataRequest getRouterInputSourceMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRouterInputSourceMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRouterInputSourceMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRouterInputSourceMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRouterInputSourceMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRouterInputSourceMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetRouterInputSourceMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRouterInputSourceMetadataRequest, GetRouterInputSourceMetadataResponse>()
                            .withOperationName("GetRouterInputSourceMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRouterInputSourceMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRouterInputSourceMetadataRequest));
            CompletableFuture<GetRouterInputSourceMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the thumbnail for a router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param getRouterInputThumbnailRequest
     * @return A Java Future containing the result of the GetRouterInputThumbnail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GetRouterInputThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInputThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRouterInputThumbnailResponse> getRouterInputThumbnail(
            GetRouterInputThumbnailRequest getRouterInputThumbnailRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRouterInputThumbnailRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRouterInputThumbnailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRouterInputThumbnail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRouterInputThumbnailResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRouterInputThumbnailResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetRouterInputThumbnailResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRouterInputThumbnailRequest, GetRouterInputThumbnailResponse>()
                            .withOperationName("GetRouterInputThumbnail").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRouterInputThumbnailRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRouterInputThumbnailRequest));
            CompletableFuture<GetRouterInputThumbnailResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a specific router network interface in AWS Elemental MediaConnect.
     * </p>
     *
     * @param getRouterNetworkInterfaceRequest
     * @return A Java Future containing the result of the GetRouterNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GetRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRouterNetworkInterfaceResponse> getRouterNetworkInterface(
            GetRouterNetworkInterfaceRequest getRouterNetworkInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRouterNetworkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRouterNetworkInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRouterNetworkInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRouterNetworkInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRouterNetworkInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetRouterNetworkInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRouterNetworkInterfaceRequest, GetRouterNetworkInterfaceResponse>()
                            .withOperationName("GetRouterNetworkInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRouterNetworkInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRouterNetworkInterfaceRequest));
            CompletableFuture<GetRouterNetworkInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a specific router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param getRouterOutputRequest
     * @return A Java Future containing the result of the GetRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GetRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterOutput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRouterOutputResponse> getRouterOutput(GetRouterOutputRequest getRouterOutputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRouterOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRouterOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRouterOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRouterOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRouterOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetRouterOutputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRouterOutputRequest, GetRouterOutputResponse>()
                            .withOperationName("GetRouterOutput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRouterOutputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRouterOutputRequest));
            CompletableFuture<GetRouterOutputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants entitlements to an existing flow.
     * </p>
     *
     * @param grantFlowEntitlementsRequest
     * @return A Java Future containing the result of the GrantFlowEntitlements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>GrantFlowEntitlements420Exception Exception raised by Elemental MediaConnect when granting the
     *         entitlement. See the error message for the operation for more information on the cause of this exception.
     *         </li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GrantFlowEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GrantFlowEntitlements"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GrantFlowEntitlementsResponse> grantFlowEntitlements(
            GrantFlowEntitlementsRequest grantFlowEntitlementsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(grantFlowEntitlementsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, grantFlowEntitlementsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GrantFlowEntitlements");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GrantFlowEntitlementsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GrantFlowEntitlementsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GrantFlowEntitlementsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GrantFlowEntitlementsRequest, GrantFlowEntitlementsResponse>()
                            .withOperationName("GrantFlowEntitlements").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GrantFlowEntitlementsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(grantFlowEntitlementsRequest));
            CompletableFuture<GrantFlowEntitlementsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays a list of bridges that are associated with this account and an optionally specified Amazon Resource Name
     * (ARN). This request returns a paginated result.
     * </p>
     *
     * @param listBridgesRequest
     * @return A Java Future containing the result of the ListBridges operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListBridges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListBridges" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListBridgesResponse> listBridges(ListBridgesRequest listBridgesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBridgesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBridgesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBridges");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBridgesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListBridgesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListBridgesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBridgesRequest, ListBridgesResponse>()
                            .withOperationName("ListBridges").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBridgesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBridgesRequest));
            CompletableFuture<ListBridgesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per
     * page.
     * </p>
     *
     * @param listEntitlementsRequest
     * @return A Java Future containing the result of the ListEntitlements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEntitlementsResponse> listEntitlements(ListEntitlementsRequest listEntitlementsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEntitlementsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEntitlementsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEntitlements");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEntitlementsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEntitlementsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListEntitlementsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEntitlementsRequest, ListEntitlementsResponse>()
                            .withOperationName("ListEntitlements").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEntitlementsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEntitlementsRequest));
            CompletableFuture<ListEntitlementsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays a list of flows that are associated with this account. This request returns a paginated result.
     * </p>
     *
     * @param listFlowsRequest
     * @return A Java Future containing the result of the ListFlows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFlowsResponse> listFlows(ListFlowsRequest listFlowsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFlowsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFlowsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFlows");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFlowsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFlowsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListFlowsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFlowsRequest, ListFlowsResponse>().withOperationName("ListFlows")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFlowsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(listFlowsRequest));
            CompletableFuture<ListFlowsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays a list of instances associated with the Amazon Web Services account. This request returns a paginated
     * result. You can use the filterArn property to display only the instances associated with the selected Gateway
     * Amazon Resource Name (ARN).
     * </p>
     *
     * @param listGatewayInstancesRequest
     * @return A Java Future containing the result of the ListGatewayInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListGatewayInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGatewayInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGatewayInstancesResponse> listGatewayInstances(
            ListGatewayInstancesRequest listGatewayInstancesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGatewayInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGatewayInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGatewayInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGatewayInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGatewayInstancesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListGatewayInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGatewayInstancesRequest, ListGatewayInstancesResponse>()
                            .withOperationName("ListGatewayInstances").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGatewayInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGatewayInstancesRequest));
            CompletableFuture<ListGatewayInstancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays a list of gateways that are associated with this account. This request returns a paginated result.
     * </p>
     *
     * @param listGatewaysRequest
     * @return A Java Future containing the result of the ListGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGatewaysResponse> listGateways(ListGatewaysRequest listGatewaysRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGatewaysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGatewaysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGateways");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGatewaysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListGatewaysResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListGatewaysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGatewaysRequest, ListGatewaysResponse>()
                            .withOperationName("ListGateways").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGatewaysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGatewaysRequest));
            CompletableFuture<ListGatewaysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays a list of all offerings that are available to this account in the current Amazon Web Services Region. If
     * you have an active reservation (which means you've purchased an offering that has already started and hasn't
     * expired yet), your account isn't eligible for other offerings.
     * </p>
     *
     * @param listOfferingsRequest
     * @return A Java Future containing the result of the ListOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListOfferings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOfferingsResponse> listOfferings(ListOfferingsRequest listOfferingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOfferingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOfferingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOfferings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOfferingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListOfferingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListOfferingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOfferingsRequest, ListOfferingsResponse>()
                            .withOperationName("ListOfferings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListOfferingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOfferingsRequest));
            CompletableFuture<ListOfferingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays a list of all reservations that have been purchased by this account in the current Amazon Web Services
     * Region. This list includes all reservations in all states (such as active and expired).
     * </p>
     *
     * @param listReservationsRequest
     * @return A Java Future containing the result of the ListReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListReservationsResponse> listReservations(ListReservationsRequest listReservationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReservationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReservationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReservations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReservationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListReservationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListReservationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReservationsRequest, ListReservationsResponse>()
                            .withOperationName("ListReservations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReservationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listReservationsRequest));
            CompletableFuture<ListReservationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of router inputs in AWS Elemental MediaConnect.
     * </p>
     *
     * @param listRouterInputsRequest
     * @return A Java Future containing the result of the ListRouterInputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListRouterInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterInputs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRouterInputsResponse> listRouterInputs(ListRouterInputsRequest listRouterInputsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRouterInputsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRouterInputsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRouterInputs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRouterInputsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRouterInputsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListRouterInputsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRouterInputsRequest, ListRouterInputsResponse>()
                            .withOperationName("ListRouterInputs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRouterInputsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRouterInputsRequest));
            CompletableFuture<ListRouterInputsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of router network interfaces in AWS Elemental MediaConnect.
     * </p>
     *
     * @param listRouterNetworkInterfacesRequest
     * @return A Java Future containing the result of the ListRouterNetworkInterfaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListRouterNetworkInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRouterNetworkInterfacesResponse> listRouterNetworkInterfaces(
            ListRouterNetworkInterfacesRequest listRouterNetworkInterfacesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRouterNetworkInterfacesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRouterNetworkInterfacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRouterNetworkInterfaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRouterNetworkInterfacesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRouterNetworkInterfacesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListRouterNetworkInterfacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRouterNetworkInterfacesRequest, ListRouterNetworkInterfacesResponse>()
                            .withOperationName("ListRouterNetworkInterfaces").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRouterNetworkInterfacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRouterNetworkInterfacesRequest));
            CompletableFuture<ListRouterNetworkInterfacesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of router outputs in AWS Elemental MediaConnect.
     * </p>
     *
     * @param listRouterOutputsRequest
     * @return A Java Future containing the result of the ListRouterOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListRouterOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRouterOutputsResponse> listRouterOutputs(ListRouterOutputsRequest listRouterOutputsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRouterOutputsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRouterOutputsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRouterOutputs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRouterOutputsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRouterOutputsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListRouterOutputsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRouterOutputsRequest, ListRouterOutputsResponse>()
                            .withOperationName("ListRouterOutputs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRouterOutputsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRouterOutputsRequest));
            CompletableFuture<ListRouterOutputsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags associated with a global resource in AWS Elemental MediaConnect. The API supports the following
     * global resources: router inputs, router outputs and router network interfaces.
     * </p>
     *
     * @param listTagsForGlobalResourceRequest
     * @return A Java Future containing the result of the ListTagsForGlobalResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListTagsForGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListTagsForGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForGlobalResourceResponse> listTagsForGlobalResource(
            ListTagsForGlobalResourceRequest listTagsForGlobalResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForGlobalResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForGlobalResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForGlobalResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForGlobalResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForGlobalResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTagsForGlobalResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForGlobalResourceRequest, ListTagsForGlobalResourceResponse>()
                            .withOperationName("ListTagsForGlobalResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForGlobalResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForGlobalResourceRequest));
            CompletableFuture<ListTagsForGlobalResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all tags on a MediaConnect resource in the current region.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another
     * offering.
     * </p>
     *
     * @param purchaseOfferingRequest
     * @return A Java Future containing the result of the PurchaseOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.PurchaseOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PurchaseOfferingResponse> purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(purchaseOfferingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, purchaseOfferingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PurchaseOffering");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PurchaseOfferingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PurchaseOfferingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<PurchaseOfferingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PurchaseOfferingRequest, PurchaseOfferingResponse>()
                            .withOperationName("PurchaseOffering").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PurchaseOfferingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(purchaseOfferingRequest));
            CompletableFuture<PurchaseOfferingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes an output from a bridge.
     * </p>
     *
     * @param removeBridgeOutputRequest
     * @return A Java Future containing the result of the RemoveBridgeOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveBridgeOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveBridgeOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveBridgeOutputResponse> removeBridgeOutput(RemoveBridgeOutputRequest removeBridgeOutputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeBridgeOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeBridgeOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveBridgeOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveBridgeOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveBridgeOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RemoveBridgeOutputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveBridgeOutputRequest, RemoveBridgeOutputResponse>()
                            .withOperationName("RemoveBridgeOutput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveBridgeOutputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeBridgeOutputRequest));
            CompletableFuture<RemoveBridgeOutputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a source from a bridge.
     * </p>
     *
     * @param removeBridgeSourceRequest
     * @return A Java Future containing the result of the RemoveBridgeSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveBridgeSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveBridgeSource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveBridgeSourceResponse> removeBridgeSource(RemoveBridgeSourceRequest removeBridgeSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeBridgeSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeBridgeSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveBridgeSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveBridgeSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveBridgeSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RemoveBridgeSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveBridgeSourceRequest, RemoveBridgeSourceResponse>()
                            .withOperationName("RemoveBridgeSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveBridgeSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeBridgeSourceRequest));
            CompletableFuture<RemoveBridgeSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a media stream from a flow. This action is only available if the media stream is not associated with a
     * source or output.
     * </p>
     *
     * @param removeFlowMediaStreamRequest
     * @return A Java Future containing the result of the RemoveFlowMediaStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveFlowMediaStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowMediaStream"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveFlowMediaStreamResponse> removeFlowMediaStream(
            RemoveFlowMediaStreamRequest removeFlowMediaStreamRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeFlowMediaStreamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeFlowMediaStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveFlowMediaStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveFlowMediaStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveFlowMediaStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RemoveFlowMediaStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveFlowMediaStreamRequest, RemoveFlowMediaStreamResponse>()
                            .withOperationName("RemoveFlowMediaStream").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveFlowMediaStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeFlowMediaStreamRequest));
            CompletableFuture<RemoveFlowMediaStreamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes an output from an existing flow. This request can be made only on an output that does not have an
     * entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When
     * an entitlement is revoked from a flow, the service automatically removes the associated output.
     * </p>
     *
     * @param removeFlowOutputRequest
     * @return A Java Future containing the result of the RemoveFlowOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveFlowOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowOutput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveFlowOutputResponse> removeFlowOutput(RemoveFlowOutputRequest removeFlowOutputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeFlowOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeFlowOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveFlowOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveFlowOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveFlowOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RemoveFlowOutputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveFlowOutputRequest, RemoveFlowOutputResponse>()
                            .withOperationName("RemoveFlowOutput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveFlowOutputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeFlowOutputRequest));
            CompletableFuture<RemoveFlowOutputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a source from an existing flow. This request can be made only if there is more than one source on the
     * flow.
     * </p>
     *
     * @param removeFlowSourceRequest
     * @return A Java Future containing the result of the RemoveFlowSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveFlowSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveFlowSourceResponse> removeFlowSource(RemoveFlowSourceRequest removeFlowSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeFlowSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeFlowSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveFlowSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveFlowSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveFlowSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RemoveFlowSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveFlowSourceRequest, RemoveFlowSourceResponse>()
                            .withOperationName("RemoveFlowSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveFlowSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeFlowSourceRequest));
            CompletableFuture<RemoveFlowSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not
     * have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must
     * first delete or update the Source or Output to no longer reference the VPC interface.
     * </p>
     *
     * @param removeFlowVpcInterfaceRequest
     * @return A Java Future containing the result of the RemoveFlowVpcInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveFlowVpcInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowVpcInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveFlowVpcInterfaceResponse> removeFlowVpcInterface(
            RemoveFlowVpcInterfaceRequest removeFlowVpcInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeFlowVpcInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeFlowVpcInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveFlowVpcInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveFlowVpcInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveFlowVpcInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RemoveFlowVpcInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveFlowVpcInterfaceRequest, RemoveFlowVpcInterfaceResponse>()
                            .withOperationName("RemoveFlowVpcInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveFlowVpcInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeFlowVpcInterfaceRequest));
            CompletableFuture<RemoveFlowVpcInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restarts a router input. This operation can be used to recover from errors or refresh the input state.
     * </p>
     *
     * @param restartRouterInputRequest
     * @return A Java Future containing the result of the RestartRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RestartRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RestartRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestartRouterInputResponse> restartRouterInput(RestartRouterInputRequest restartRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restartRouterInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restartRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestartRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RestartRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RestartRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RestartRouterInputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestartRouterInputRequest, RestartRouterInputResponse>()
                            .withOperationName("RestartRouterInput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RestartRouterInputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(restartRouterInputRequest));
            CompletableFuture<RestartRouterInputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restarts a router output. This operation can be used to recover from errors or refresh the output state.
     * </p>
     *
     * @param restartRouterOutputRequest
     * @return A Java Future containing the result of the RestartRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RestartRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RestartRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestartRouterOutputResponse> restartRouterOutput(
            RestartRouterOutputRequest restartRouterOutputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restartRouterOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restartRouterOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestartRouterOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RestartRouterOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RestartRouterOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RestartRouterOutputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestartRouterOutputRequest, RestartRouterOutputResponse>()
                            .withOperationName("RestartRouterOutput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RestartRouterOutputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(restartRouterOutputRequest));
            CompletableFuture<RestartRouterOutputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the
     * subscriber and the associated output is removed.
     * </p>
     *
     * @param revokeFlowEntitlementRequest
     * @return A Java Future containing the result of the RevokeFlowEntitlement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RevokeFlowEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RevokeFlowEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RevokeFlowEntitlementResponse> revokeFlowEntitlement(
            RevokeFlowEntitlementRequest revokeFlowEntitlementRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(revokeFlowEntitlementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, revokeFlowEntitlementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokeFlowEntitlement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RevokeFlowEntitlementResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RevokeFlowEntitlementResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RevokeFlowEntitlementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RevokeFlowEntitlementRequest, RevokeFlowEntitlementResponse>()
                            .withOperationName("RevokeFlowEntitlement").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RevokeFlowEntitlementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(revokeFlowEntitlementRequest));
            CompletableFuture<RevokeFlowEntitlementResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a flow.
     * </p>
     *
     * @param startFlowRequest
     * @return A Java Future containing the result of the StartFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StartFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartFlow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartFlowResponse> startFlow(StartFlowRequest startFlowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startFlowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartFlow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartFlowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartFlowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartFlowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartFlowRequest, StartFlowResponse>().withOperationName("StartFlow")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartFlowRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(startFlowRequest));
            CompletableFuture<StartFlowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param startRouterInputRequest
     * @return A Java Future containing the result of the StartRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StartRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartRouterInputResponse> startRouterInput(StartRouterInputRequest startRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startRouterInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartRouterInputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartRouterInputRequest, StartRouterInputResponse>()
                            .withOperationName("StartRouterInput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartRouterInputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startRouterInputRequest));
            CompletableFuture<StartRouterInputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param startRouterOutputRequest
     * @return A Java Future containing the result of the StartRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StartRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartRouterOutputResponse> startRouterOutput(StartRouterOutputRequest startRouterOutputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startRouterOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startRouterOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartRouterOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartRouterOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartRouterOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartRouterOutputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartRouterOutputRequest, StartRouterOutputResponse>()
                            .withOperationName("StartRouterOutput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartRouterOutputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startRouterOutputRequest));
            CompletableFuture<StartRouterOutputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a flow.
     * </p>
     *
     * @param stopFlowRequest
     * @return A Java Future containing the result of the StopFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StopFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopFlow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopFlowResponse> stopFlow(StopFlowRequest stopFlowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopFlowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopFlow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopFlowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StopFlowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopFlowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopFlowRequest, StopFlowResponse>().withOperationName("StopFlow")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopFlowRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopFlowRequest));
            CompletableFuture<StopFlowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param stopRouterInputRequest
     * @return A Java Future containing the result of the StopRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StopRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StopRouterInputResponse> stopRouterInput(StopRouterInputRequest stopRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopRouterInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopRouterInputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopRouterInputRequest, StopRouterInputResponse>()
                            .withOperationName("StopRouterInput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopRouterInputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopRouterInputRequest));
            CompletableFuture<StopRouterInputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param stopRouterOutputRequest
     * @return A Java Future containing the result of the StopRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StopRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopRouterOutput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StopRouterOutputResponse> stopRouterOutput(StopRouterOutputRequest stopRouterOutputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopRouterOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopRouterOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopRouterOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopRouterOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopRouterOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopRouterOutputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopRouterOutputRequest, StopRouterOutputResponse>()
                            .withOperationName("StopRouterOutput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopRouterOutputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopRouterOutputRequest));
            CompletableFuture<StopRouterOutputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds tags to a global resource in AWS Elemental MediaConnect. The API supports the following global resources:
     * router inputs, router outputs and router network interfaces.
     * </p>
     *
     * @param tagGlobalResourceRequest
     * @return A Java Future containing the result of the TagGlobalResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.TagGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TagGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<TagGlobalResourceResponse> tagGlobalResource(TagGlobalResourceRequest tagGlobalResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagGlobalResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagGlobalResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagGlobalResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagGlobalResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TagGlobalResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<TagGlobalResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagGlobalResourceRequest, TagGlobalResourceResponse>()
                            .withOperationName("TagGlobalResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagGlobalResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagGlobalResourceRequest));
            CompletableFuture<TagGlobalResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code> in the current region. If
     * existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is
     * deleted, the tags associated with that resource are deleted as well.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a router input with a router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param takeRouterInputRequest
     * @return A Java Future containing the result of the TakeRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.TakeRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TakeRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<TakeRouterInputResponse> takeRouterInput(TakeRouterInputRequest takeRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(takeRouterInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, takeRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TakeRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TakeRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TakeRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<TakeRouterInputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TakeRouterInputRequest, TakeRouterInputResponse>()
                            .withOperationName("TakeRouterInput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TakeRouterInputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(takeRouterInputRequest));
            CompletableFuture<TakeRouterInputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes tags from a global resource in AWS Elemental MediaConnect. The API supports the following global
     * resources: router inputs, router outputs and router network interfaces.
     * </p>
     *
     * @param untagGlobalResourceRequest
     * @return A Java Future containing the result of the UntagGlobalResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UntagGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UntagGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagGlobalResourceResponse> untagGlobalResource(
            UntagGlobalResourceRequest untagGlobalResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagGlobalResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagGlobalResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagGlobalResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagGlobalResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UntagGlobalResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UntagGlobalResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagGlobalResourceRequest, UntagGlobalResourceResponse>()
                            .withOperationName("UntagGlobalResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagGlobalResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagGlobalResourceRequest));
            CompletableFuture<UntagGlobalResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes specified tags from a resource in the current region.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the bridge.
     * </p>
     *
     * @param updateBridgeRequest
     * @return A Java Future containing the result of the UpdateBridge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridge" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBridgeResponse> updateBridge(UpdateBridgeRequest updateBridgeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBridgeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBridgeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBridge");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBridgeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateBridgeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateBridgeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBridgeRequest, UpdateBridgeResponse>()
                            .withOperationName("UpdateBridge").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateBridgeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateBridgeRequest));
            CompletableFuture<UpdateBridgeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing bridge output.
     * </p>
     *
     * @param updateBridgeOutputRequest
     * @return A Java Future containing the result of the UpdateBridgeOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateBridgeOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBridgeOutputResponse> updateBridgeOutput(UpdateBridgeOutputRequest updateBridgeOutputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBridgeOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBridgeOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBridgeOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBridgeOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBridgeOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateBridgeOutputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBridgeOutputRequest, UpdateBridgeOutputResponse>()
                            .withOperationName("UpdateBridgeOutput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateBridgeOutputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateBridgeOutputRequest));
            CompletableFuture<UpdateBridgeOutputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing bridge source.
     * </p>
     *
     * @param updateBridgeSourceRequest
     * @return A Java Future containing the result of the UpdateBridgeSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateBridgeSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeSource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBridgeSourceResponse> updateBridgeSource(UpdateBridgeSourceRequest updateBridgeSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBridgeSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBridgeSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBridgeSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBridgeSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBridgeSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateBridgeSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBridgeSourceRequest, UpdateBridgeSourceResponse>()
                            .withOperationName("UpdateBridgeSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateBridgeSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateBridgeSourceRequest));
            CompletableFuture<UpdateBridgeSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the bridge state.
     * </p>
     *
     * @param updateBridgeStateRequest
     * @return A Java Future containing the result of the UpdateBridgeState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateBridgeState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeState"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBridgeStateResponse> updateBridgeState(UpdateBridgeStateRequest updateBridgeStateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBridgeStateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBridgeStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBridgeState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBridgeStateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBridgeStateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateBridgeStateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBridgeStateRequest, UpdateBridgeStateResponse>()
                            .withOperationName("UpdateBridgeState").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateBridgeStateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateBridgeStateRequest));
            CompletableFuture<UpdateBridgeStateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing flow.
     * </p>
     *
     * @param updateFlowRequest
     * @return A Java Future containing the result of the UpdateFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFlowResponse> updateFlow(UpdateFlowRequest updateFlowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFlowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFlow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFlowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateFlowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateFlowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFlowRequest, UpdateFlowResponse>().withOperationName("UpdateFlow")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFlowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFlowRequest));
            CompletableFuture<UpdateFlowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an entitlement. You can change an entitlement's description, subscribers, and encryption. If you change
     * the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
     * </p>
     *
     * @param updateFlowEntitlementRequest
     * @return A Java Future containing the result of the UpdateFlowEntitlement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateFlowEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFlowEntitlementResponse> updateFlowEntitlement(
            UpdateFlowEntitlementRequest updateFlowEntitlementRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFlowEntitlementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFlowEntitlementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFlowEntitlement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFlowEntitlementResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFlowEntitlementResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateFlowEntitlementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFlowEntitlementRequest, UpdateFlowEntitlementResponse>()
                            .withOperationName("UpdateFlowEntitlement").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFlowEntitlementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFlowEntitlementRequest));
            CompletableFuture<UpdateFlowEntitlementResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing media stream.
     * </p>
     *
     * @param updateFlowMediaStreamRequest
     * @return A Java Future containing the result of the UpdateFlowMediaStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateFlowMediaStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowMediaStream"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFlowMediaStreamResponse> updateFlowMediaStream(
            UpdateFlowMediaStreamRequest updateFlowMediaStreamRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFlowMediaStreamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFlowMediaStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFlowMediaStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFlowMediaStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFlowMediaStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateFlowMediaStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFlowMediaStreamRequest, UpdateFlowMediaStreamResponse>()
                            .withOperationName("UpdateFlowMediaStream").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFlowMediaStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFlowMediaStreamRequest));
            CompletableFuture<UpdateFlowMediaStreamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing flow output.
     * </p>
     *
     * @param updateFlowOutputRequest
     * @return A Java Future containing the result of the UpdateFlowOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateFlowOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowOutput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFlowOutputResponse> updateFlowOutput(UpdateFlowOutputRequest updateFlowOutputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFlowOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFlowOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFlowOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFlowOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFlowOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateFlowOutputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFlowOutputRequest, UpdateFlowOutputResponse>()
                            .withOperationName("UpdateFlowOutput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFlowOutputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFlowOutputRequest));
            CompletableFuture<UpdateFlowOutputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the source of a flow.
     * </p>
     *
     * @param updateFlowSourceRequest
     * @return A Java Future containing the result of the UpdateFlowSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateFlowSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFlowSourceResponse> updateFlowSource(UpdateFlowSourceRequest updateFlowSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFlowSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFlowSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFlowSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFlowSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFlowSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateFlowSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFlowSourceRequest, UpdateFlowSourceResponse>()
                            .withOperationName("UpdateFlowSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFlowSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFlowSourceRequest));
            CompletableFuture<UpdateFlowSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing gateway instance.
     * </p>
     *
     * @param updateGatewayInstanceRequest
     * @return A Java Future containing the result of the UpdateGatewayInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGatewayInstanceResponse> updateGatewayInstance(
            UpdateGatewayInstanceRequest updateGatewayInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGatewayInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGatewayInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGatewayInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGatewayInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateGatewayInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateGatewayInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGatewayInstanceRequest, UpdateGatewayInstanceResponse>()
                            .withOperationName("UpdateGatewayInstance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateGatewayInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateGatewayInstanceRequest));
            CompletableFuture<UpdateGatewayInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param updateRouterInputRequest
     * @return A Java Future containing the result of the UpdateRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRouterInputResponse> updateRouterInput(UpdateRouterInputRequest updateRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRouterInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateRouterInputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRouterInputRequest, UpdateRouterInputResponse>()
                            .withOperationName("UpdateRouterInput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRouterInputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRouterInputRequest));
            CompletableFuture<UpdateRouterInputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing router network interface in AWS Elemental MediaConnect.
     * </p>
     *
     * @param updateRouterNetworkInterfaceRequest
     * @return A Java Future containing the result of the UpdateRouterNetworkInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRouterNetworkInterfaceResponse> updateRouterNetworkInterface(
            UpdateRouterNetworkInterfaceRequest updateRouterNetworkInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRouterNetworkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRouterNetworkInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRouterNetworkInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRouterNetworkInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRouterNetworkInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateRouterNetworkInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRouterNetworkInterfaceRequest, UpdateRouterNetworkInterfaceResponse>()
                            .withOperationName("UpdateRouterNetworkInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRouterNetworkInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRouterNetworkInterfaceRequest));
            CompletableFuture<UpdateRouterNetworkInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param updateRouterOutputRequest
     * @return A Java Future containing the result of the UpdateRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRouterOutputResponse> updateRouterOutput(UpdateRouterOutputRequest updateRouterOutputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRouterOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRouterOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRouterOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRouterOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRouterOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RouterInputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder)
                            .build());
                case "ForbiddenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                            .exceptionBuilderSupplier(ForbiddenException::builder).build());
                case "CreateFlow420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "RouterNetworkInterfaceServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(420)
                            .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                case "CreateGateway420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "GrantFlowEntitlements420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception")
                            .httpStatusCode(420).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                case "AddFlowOutputs420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                case "BadRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BadRequestException::builder).build());
                case "RouterOutputServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                            .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                            .build());
                case "CreateBridge420Exception":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                            .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                case "ServiceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                case "InternalServerErrorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateRouterOutputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRouterOutputRequest, UpdateRouterOutputResponse>()
                            .withOperationName("UpdateRouterOutput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRouterOutputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRouterOutputRequest));
            CompletableFuture<UpdateRouterOutputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public MediaConnectAsyncWaiter waiter() {
        return MediaConnectAsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }

    @Override
    public final MediaConnectServiceClientConfiguration serviceClientConfiguration() {
        return new MediaConnectServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(MediaConnectException::builder)
                .protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        MediaConnectServiceClientConfigurationBuilder serviceConfigBuilder = new MediaConnectServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
