/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.Reservation;
import software.amazon.awssdk.services.mediaconnect.model.___listOfReservationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReservationsResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, ListReservationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListReservationsResponse.getter(ListReservationsResponse::nextToken)).setter(ListReservationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<Reservation>> RESERVATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Reservations").getter(ListReservationsResponse.getter(ListReservationsResponse::reservations)).setter(ListReservationsResponse.setter(Builder::reservations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Reservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESERVATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListReservationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<Reservation> reservations;

    private ListReservationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservations = builder.reservations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasReservations() {
        return this.reservations != null && !(this.reservations instanceof SdkAutoConstructList);
    }

    public final List<Reservation> reservations() {
        return this.reservations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservations() ? this.reservations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReservationsResponse)) {
            return false;
        }
        ListReservationsResponse other = (ListReservationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasReservations() == other.hasReservations() && Objects.equals(this.reservations(), other.reservations());
    }

    public final String toString() {
        return ToString.builder((String)"ListReservationsResponse").add("NextToken", (Object)this.nextToken()).add("Reservations", this.hasReservations() ? this.reservations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Reservations": {
                return Optional.ofNullable(clazz.cast(this.reservations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("reservations", RESERVATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReservationsResponse, T> g) {
        return obj -> g.apply((ListReservationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Reservation> reservations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReservationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.reservations(model.reservations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Reservation.Builder> getReservations() {
            List<Reservation.Builder> result = ___listOfReservationCopier.copyToBuilder(this.reservations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservations(Collection<Reservation.BuilderImpl> reservations) {
            this.reservations = ___listOfReservationCopier.copyFromBuilder(reservations);
        }

        @Override
        public final Builder reservations(Collection<Reservation> reservations) {
            this.reservations = ___listOfReservationCopier.copy(reservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservations(Reservation ... reservations) {
            this.reservations(Arrays.asList(reservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservations(Consumer<Reservation.Builder> ... reservations) {
            this.reservations(Stream.of(reservations).map(c -> (Reservation)((Reservation.Builder)Reservation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListReservationsResponse build() {
            return new ListReservationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReservationsResponse> {
        public Builder nextToken(String var1);

        public Builder reservations(Collection<Reservation> var1);

        public Builder reservations(Reservation ... var1);

        public Builder reservations(Consumer<Reservation.Builder> ... var1);
    }
}

