/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.BlackFrames;
import software.amazon.awssdk.services.mediaconnect.model.FrozenFrames;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoMonitoringSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoMonitoringSetting> {
    private static final SdkField<BlackFrames> BLACK_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BlackFrames").getter(VideoMonitoringSetting.getter(VideoMonitoringSetting::blackFrames)).setter(VideoMonitoringSetting.setter(Builder::blackFrames)).constructor(BlackFrames::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blackFrames").build()}).build();
    private static final SdkField<FrozenFrames> FROZEN_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FrozenFrames").getter(VideoMonitoringSetting.getter(VideoMonitoringSetting::frozenFrames)).setter(VideoMonitoringSetting.setter(Builder::frozenFrames)).constructor(FrozenFrames::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frozenFrames").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLACK_FRAMES_FIELD, FROZEN_FRAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VideoMonitoringSetting.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final BlackFrames blackFrames;
    private final FrozenFrames frozenFrames;

    private VideoMonitoringSetting(BuilderImpl builder) {
        this.blackFrames = builder.blackFrames;
        this.frozenFrames = builder.frozenFrames;
    }

    public final BlackFrames blackFrames() {
        return this.blackFrames;
    }

    public final FrozenFrames frozenFrames() {
        return this.frozenFrames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blackFrames());
        hashCode = 31 * hashCode + Objects.hashCode(this.frozenFrames());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoMonitoringSetting)) {
            return false;
        }
        VideoMonitoringSetting other = (VideoMonitoringSetting)obj;
        return Objects.equals(this.blackFrames(), other.blackFrames()) && Objects.equals(this.frozenFrames(), other.frozenFrames());
    }

    public final String toString() {
        return ToString.builder((String)"VideoMonitoringSetting").add("BlackFrames", (Object)this.blackFrames()).add("FrozenFrames", (Object)this.frozenFrames()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlackFrames": {
                return Optional.ofNullable(clazz.cast(this.blackFrames()));
            }
            case "FrozenFrames": {
                return Optional.ofNullable(clazz.cast(this.frozenFrames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("blackFrames", BLACK_FRAMES_FIELD);
        map.put("frozenFrames", FROZEN_FRAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoMonitoringSetting, T> g) {
        return obj -> g.apply((VideoMonitoringSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BlackFrames blackFrames;
        private FrozenFrames frozenFrames;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoMonitoringSetting model) {
            this.blackFrames(model.blackFrames);
            this.frozenFrames(model.frozenFrames);
        }

        public final BlackFrames.Builder getBlackFrames() {
            return this.blackFrames != null ? this.blackFrames.toBuilder() : null;
        }

        public final void setBlackFrames(BlackFrames.BuilderImpl blackFrames) {
            this.blackFrames = blackFrames != null ? blackFrames.build() : null;
        }

        @Override
        public final Builder blackFrames(BlackFrames blackFrames) {
            this.blackFrames = blackFrames;
            return this;
        }

        public final FrozenFrames.Builder getFrozenFrames() {
            return this.frozenFrames != null ? this.frozenFrames.toBuilder() : null;
        }

        public final void setFrozenFrames(FrozenFrames.BuilderImpl frozenFrames) {
            this.frozenFrames = frozenFrames != null ? frozenFrames.build() : null;
        }

        @Override
        public final Builder frozenFrames(FrozenFrames frozenFrames) {
            this.frozenFrames = frozenFrames;
            return this;
        }

        public VideoMonitoringSetting build() {
            return new VideoMonitoringSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoMonitoringSetting> {
        public Builder blackFrames(BlackFrames var1);

        default public Builder blackFrames(Consumer<BlackFrames.Builder> blackFrames) {
            return this.blackFrames((BlackFrames)((BlackFrames.Builder)BlackFrames.builder().applyMutation(blackFrames)).build());
        }

        public Builder frozenFrames(FrozenFrames var1);

        default public Builder frozenFrames(Consumer<FrozenFrames.Builder> frozenFrames) {
            return this.frozenFrames((FrozenFrames)((FrozenFrames.Builder)FrozenFrames.builder().applyMutation(frozenFrames)).build());
        }
    }
}

