/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectAsyncClient;
import software.amazon.awssdk.services.mediaconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewaysResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListedGateway;

public class ListGatewaysPublisher
implements SdkPublisher<ListGatewaysResponse> {
    private final MediaConnectAsyncClient client;
    private final ListGatewaysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGatewaysPublisher(MediaConnectAsyncClient client, ListGatewaysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGatewaysPublisher(MediaConnectAsyncClient client, ListGatewaysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGatewaysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGatewaysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListedGateway> gateways() {
        Function<ListGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.gateways() != null) {
                return response.gateways().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGatewaysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGatewaysResponseFetcher
    implements AsyncPageFetcher<ListGatewaysResponse> {
        private ListGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(ListGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGatewaysResponse> nextPage(ListGatewaysResponse previousPage) {
            if (previousPage == null) {
                return ListGatewaysPublisher.this.client.listGateways(ListGatewaysPublisher.this.firstRequest);
            }
            return ListGatewaysPublisher.this.client.listGateways((ListGatewaysRequest)((Object)ListGatewaysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

