/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.TransportStreamProgram;
import software.amazon.awssdk.services.mediaconnect.model.___listOfTransportStreamProgramCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransportMediaInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransportMediaInfo> {
    private static final SdkField<List<TransportStreamProgram>> PROGRAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Programs").getter(TransportMediaInfo.getter(TransportMediaInfo::programs)).setter(TransportMediaInfo.setter(Builder::programs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransportStreamProgram::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRAMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<TransportStreamProgram> programs;

    private TransportMediaInfo(BuilderImpl builder) {
        this.programs = builder.programs;
    }

    public final boolean hasPrograms() {
        return this.programs != null && !(this.programs instanceof SdkAutoConstructList);
    }

    public final List<TransportStreamProgram> programs() {
        return this.programs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrograms() ? this.programs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransportMediaInfo)) {
            return false;
        }
        TransportMediaInfo other = (TransportMediaInfo)obj;
        return this.hasPrograms() == other.hasPrograms() && Objects.equals(this.programs(), other.programs());
    }

    public final String toString() {
        return ToString.builder((String)"TransportMediaInfo").add("Programs", this.hasPrograms() ? this.programs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Programs": {
                return Optional.ofNullable(clazz.cast(this.programs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransportMediaInfo, T> g) {
        return obj -> g.apply((TransportMediaInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TransportStreamProgram> programs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransportMediaInfo model) {
            this.programs(model.programs);
        }

        public final List<TransportStreamProgram.Builder> getPrograms() {
            List<TransportStreamProgram.Builder> result = ___listOfTransportStreamProgramCopier.copyToBuilder(this.programs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrograms(Collection<TransportStreamProgram.BuilderImpl> programs) {
            this.programs = ___listOfTransportStreamProgramCopier.copyFromBuilder(programs);
        }

        @Override
        public final Builder programs(Collection<TransportStreamProgram> programs) {
            this.programs = ___listOfTransportStreamProgramCopier.copy(programs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programs(TransportStreamProgram ... programs) {
            this.programs(Arrays.asList(programs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programs(Consumer<TransportStreamProgram.Builder> ... programs) {
            this.programs(Stream.of(programs).map(c -> (TransportStreamProgram)((TransportStreamProgram.Builder)TransportStreamProgram.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TransportMediaInfo build() {
            return new TransportMediaInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransportMediaInfo> {
        public Builder programs(Collection<TransportStreamProgram> var1);

        public Builder programs(TransportStreamProgram ... var1);

        public Builder programs(Consumer<TransportStreamProgram.Builder> ... var1);
    }
}

