/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddEgressGatewayBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddIngressGatewayBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.FailoverConfig;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.___listOfAddBridgeOutputRequestCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOfAddBridgeSourceRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBridgeRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, CreateBridgeRequest> {
    private static final SdkField<AddEgressGatewayBridgeRequest> EGRESS_GATEWAY_BRIDGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EgressGatewayBridge").getter(CreateBridgeRequest.getter(CreateBridgeRequest::egressGatewayBridge)).setter(CreateBridgeRequest.setter(Builder::egressGatewayBridge)).constructor(AddEgressGatewayBridgeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressGatewayBridge").build()}).build();
    private static final SdkField<AddIngressGatewayBridgeRequest> INGRESS_GATEWAY_BRIDGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngressGatewayBridge").getter(CreateBridgeRequest.getter(CreateBridgeRequest::ingressGatewayBridge)).setter(CreateBridgeRequest.setter(Builder::ingressGatewayBridge)).constructor(AddIngressGatewayBridgeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressGatewayBridge").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateBridgeRequest.getter(CreateBridgeRequest::name)).setter(CreateBridgeRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<AddBridgeOutputRequest>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outputs").getter(CreateBridgeRequest.getter(CreateBridgeRequest::outputs)).setter(CreateBridgeRequest.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddBridgeOutputRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLACEMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlacementArn").getter(CreateBridgeRequest.getter(CreateBridgeRequest::placementArn)).setter(CreateBridgeRequest.setter(Builder::placementArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementArn").build()}).build();
    private static final SdkField<FailoverConfig> SOURCE_FAILOVER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceFailoverConfig").getter(CreateBridgeRequest.getter(CreateBridgeRequest::sourceFailoverConfig)).setter(CreateBridgeRequest.setter(Builder::sourceFailoverConfig)).constructor(FailoverConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFailoverConfig").build()}).build();
    private static final SdkField<List<AddBridgeSourceRequest>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(CreateBridgeRequest.getter(CreateBridgeRequest::sources)).setter(CreateBridgeRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddBridgeSourceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_GATEWAY_BRIDGE_FIELD, INGRESS_GATEWAY_BRIDGE_FIELD, NAME_FIELD, OUTPUTS_FIELD, PLACEMENT_ARN_FIELD, SOURCE_FAILOVER_CONFIG_FIELD, SOURCES_FIELD));
    private final AddEgressGatewayBridgeRequest egressGatewayBridge;
    private final AddIngressGatewayBridgeRequest ingressGatewayBridge;
    private final String name;
    private final List<AddBridgeOutputRequest> outputs;
    private final String placementArn;
    private final FailoverConfig sourceFailoverConfig;
    private final List<AddBridgeSourceRequest> sources;

    private CreateBridgeRequest(BuilderImpl builder) {
        super(builder);
        this.egressGatewayBridge = builder.egressGatewayBridge;
        this.ingressGatewayBridge = builder.ingressGatewayBridge;
        this.name = builder.name;
        this.outputs = builder.outputs;
        this.placementArn = builder.placementArn;
        this.sourceFailoverConfig = builder.sourceFailoverConfig;
        this.sources = builder.sources;
    }

    public final AddEgressGatewayBridgeRequest egressGatewayBridge() {
        return this.egressGatewayBridge;
    }

    public final AddIngressGatewayBridgeRequest ingressGatewayBridge() {
        return this.ingressGatewayBridge;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<AddBridgeOutputRequest> outputs() {
        return this.outputs;
    }

    public final String placementArn() {
        return this.placementArn;
    }

    public final FailoverConfig sourceFailoverConfig() {
        return this.sourceFailoverConfig;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<AddBridgeSourceRequest> sources() {
        return this.sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.egressGatewayBridge());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressGatewayBridge());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.placementArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFailoverConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBridgeRequest)) {
            return false;
        }
        CreateBridgeRequest other = (CreateBridgeRequest)((Object)obj);
        return Objects.equals(this.egressGatewayBridge(), other.egressGatewayBridge()) && Objects.equals(this.ingressGatewayBridge(), other.ingressGatewayBridge()) && Objects.equals(this.name(), other.name()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.placementArn(), other.placementArn()) && Objects.equals(this.sourceFailoverConfig(), other.sourceFailoverConfig()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBridgeRequest").add("EgressGatewayBridge", (Object)this.egressGatewayBridge()).add("IngressGatewayBridge", (Object)this.ingressGatewayBridge()).add("Name", (Object)this.name()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("PlacementArn", (Object)this.placementArn()).add("SourceFailoverConfig", (Object)this.sourceFailoverConfig()).add("Sources", this.hasSources() ? this.sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EgressGatewayBridge": {
                return Optional.ofNullable(clazz.cast(this.egressGatewayBridge()));
            }
            case "IngressGatewayBridge": {
                return Optional.ofNullable(clazz.cast(this.ingressGatewayBridge()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "PlacementArn": {
                return Optional.ofNullable(clazz.cast(this.placementArn()));
            }
            case "SourceFailoverConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceFailoverConfig()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBridgeRequest, T> g) {
        return obj -> g.apply((CreateBridgeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private AddEgressGatewayBridgeRequest egressGatewayBridge;
        private AddIngressGatewayBridgeRequest ingressGatewayBridge;
        private String name;
        private List<AddBridgeOutputRequest> outputs = DefaultSdkAutoConstructList.getInstance();
        private String placementArn;
        private FailoverConfig sourceFailoverConfig;
        private List<AddBridgeSourceRequest> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBridgeRequest model) {
            super(model);
            this.egressGatewayBridge(model.egressGatewayBridge);
            this.ingressGatewayBridge(model.ingressGatewayBridge);
            this.name(model.name);
            this.outputs(model.outputs);
            this.placementArn(model.placementArn);
            this.sourceFailoverConfig(model.sourceFailoverConfig);
            this.sources(model.sources);
        }

        public final AddEgressGatewayBridgeRequest.Builder getEgressGatewayBridge() {
            return this.egressGatewayBridge != null ? this.egressGatewayBridge.toBuilder() : null;
        }

        public final void setEgressGatewayBridge(AddEgressGatewayBridgeRequest.BuilderImpl egressGatewayBridge) {
            this.egressGatewayBridge = egressGatewayBridge != null ? egressGatewayBridge.build() : null;
        }

        @Override
        public final Builder egressGatewayBridge(AddEgressGatewayBridgeRequest egressGatewayBridge) {
            this.egressGatewayBridge = egressGatewayBridge;
            return this;
        }

        public final AddIngressGatewayBridgeRequest.Builder getIngressGatewayBridge() {
            return this.ingressGatewayBridge != null ? this.ingressGatewayBridge.toBuilder() : null;
        }

        public final void setIngressGatewayBridge(AddIngressGatewayBridgeRequest.BuilderImpl ingressGatewayBridge) {
            this.ingressGatewayBridge = ingressGatewayBridge != null ? ingressGatewayBridge.build() : null;
        }

        @Override
        public final Builder ingressGatewayBridge(AddIngressGatewayBridgeRequest ingressGatewayBridge) {
            this.ingressGatewayBridge = ingressGatewayBridge;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AddBridgeOutputRequest.Builder> getOutputs() {
            List<AddBridgeOutputRequest.Builder> result = ___listOfAddBridgeOutputRequestCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<AddBridgeOutputRequest.BuilderImpl> outputs) {
            this.outputs = ___listOfAddBridgeOutputRequestCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<AddBridgeOutputRequest> outputs) {
            this.outputs = ___listOfAddBridgeOutputRequestCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(AddBridgeOutputRequest ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<AddBridgeOutputRequest.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (AddBridgeOutputRequest)((AddBridgeOutputRequest.Builder)AddBridgeOutputRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPlacementArn() {
            return this.placementArn;
        }

        public final void setPlacementArn(String placementArn) {
            this.placementArn = placementArn;
        }

        @Override
        public final Builder placementArn(String placementArn) {
            this.placementArn = placementArn;
            return this;
        }

        public final FailoverConfig.Builder getSourceFailoverConfig() {
            return this.sourceFailoverConfig != null ? this.sourceFailoverConfig.toBuilder() : null;
        }

        public final void setSourceFailoverConfig(FailoverConfig.BuilderImpl sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig != null ? sourceFailoverConfig.build() : null;
        }

        @Override
        public final Builder sourceFailoverConfig(FailoverConfig sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        public final List<AddBridgeSourceRequest.Builder> getSources() {
            List<AddBridgeSourceRequest.Builder> result = ___listOfAddBridgeSourceRequestCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<AddBridgeSourceRequest.BuilderImpl> sources) {
            this.sources = ___listOfAddBridgeSourceRequestCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<AddBridgeSourceRequest> sources) {
            this.sources = ___listOfAddBridgeSourceRequestCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(AddBridgeSourceRequest ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<AddBridgeSourceRequest.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (AddBridgeSourceRequest)((AddBridgeSourceRequest.Builder)AddBridgeSourceRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBridgeRequest build() {
            return new CreateBridgeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBridgeRequest> {
        public Builder egressGatewayBridge(AddEgressGatewayBridgeRequest var1);

        default public Builder egressGatewayBridge(Consumer<AddEgressGatewayBridgeRequest.Builder> egressGatewayBridge) {
            return this.egressGatewayBridge((AddEgressGatewayBridgeRequest)((AddEgressGatewayBridgeRequest.Builder)AddEgressGatewayBridgeRequest.builder().applyMutation(egressGatewayBridge)).build());
        }

        public Builder ingressGatewayBridge(AddIngressGatewayBridgeRequest var1);

        default public Builder ingressGatewayBridge(Consumer<AddIngressGatewayBridgeRequest.Builder> ingressGatewayBridge) {
            return this.ingressGatewayBridge((AddIngressGatewayBridgeRequest)((AddIngressGatewayBridgeRequest.Builder)AddIngressGatewayBridgeRequest.builder().applyMutation(ingressGatewayBridge)).build());
        }

        public Builder name(String var1);

        public Builder outputs(Collection<AddBridgeOutputRequest> var1);

        public Builder outputs(AddBridgeOutputRequest ... var1);

        public Builder outputs(Consumer<AddBridgeOutputRequest.Builder> ... var1);

        public Builder placementArn(String var1);

        public Builder sourceFailoverConfig(FailoverConfig var1);

        default public Builder sourceFailoverConfig(Consumer<FailoverConfig.Builder> sourceFailoverConfig) {
            return this.sourceFailoverConfig((FailoverConfig)((FailoverConfig.Builder)FailoverConfig.builder().applyMutation(sourceFailoverConfig)).build());
        }

        public Builder sources(Collection<AddBridgeSourceRequest> var1);

        public Builder sources(AddBridgeSourceRequest ... var1);

        public Builder sources(Consumer<AddBridgeSourceRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

