/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.mediaconnect.MediaConnectClient;
import software.amazon.awssdk.services.mediaconnect.MediaConnectServiceClientConfiguration;
import software.amazon.awssdk.services.mediaconnect.internal.MediaConnectServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourcesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourcesResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowMediaStreamsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowMediaStreamsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputs420Exception;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowSourcesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowSourcesResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowVpcInterfacesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowVpcInterfacesResponse;
import software.amazon.awssdk.services.mediaconnect.model.BadRequestException;
import software.amazon.awssdk.services.mediaconnect.model.ConflictException;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridge420Exception;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlow420Exception;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateGateway420Exception;
import software.amazon.awssdk.services.mediaconnect.model.CreateGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeregisterGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeregisterGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeOfferingRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeOfferingResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeReservationRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeReservationResponse;
import software.amazon.awssdk.services.mediaconnect.model.ForbiddenException;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlements420Exception;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlementsRequest;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlementsResponse;
import software.amazon.awssdk.services.mediaconnect.model.InternalServerErrorException;
import software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListBridgesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewaysResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListOfferingsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListReservationsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectException;
import software.amazon.awssdk.services.mediaconnect.model.NotFoundException;
import software.amazon.awssdk.services.mediaconnect.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.mediaconnect.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowMediaStreamRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowMediaStreamResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowVpcInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowVpcInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RevokeFlowEntitlementRequest;
import software.amazon.awssdk.services.mediaconnect.model.RevokeFlowEntitlementResponse;
import software.amazon.awssdk.services.mediaconnect.model.ServiceUnavailableException;
import software.amazon.awssdk.services.mediaconnect.model.StartFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.StartFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.StopFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.StopFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.TagResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.TagResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.TooManyRequestsException;
import software.amazon.awssdk.services.mediaconnect.model.UntagResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UntagResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeStateRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeStateResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowEntitlementRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowEntitlementResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowMediaStreamRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowMediaStreamResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.transform.AddBridgeOutputsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddBridgeSourcesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddFlowMediaStreamsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddFlowOutputsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddFlowSourcesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddFlowVpcInterfacesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateBridgeRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateGatewayRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteBridgeRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteGatewayRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeregisterGatewayInstanceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeBridgeRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeGatewayInstanceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeGatewayRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeOfferingRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeReservationRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GrantFlowEntitlementsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListBridgesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListEntitlementsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListFlowsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListGatewayInstancesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListGatewaysRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListOfferingsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListReservationsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.PurchaseOfferingRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveBridgeOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveBridgeSourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveFlowMediaStreamRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveFlowOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveFlowSourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveFlowVpcInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RevokeFlowEntitlementRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StartFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StopFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateBridgeOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateBridgeRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateBridgeSourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateBridgeStateRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowEntitlementRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowMediaStreamRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowSourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateGatewayInstanceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.waiters.MediaConnectWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultMediaConnectClient
implements MediaConnectClient {
    private static final Logger log = Logger.loggerFor(DefaultMediaConnectClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final MediaConnectServiceClientConfiguration serviceClientConfiguration;

    protected DefaultMediaConnectClient(MediaConnectServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddBridgeOutputsResponse addBridgeOutputs(AddBridgeOutputsRequest addBridgeOutputsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddBridgeOutputsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addBridgeOutputsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, addBridgeOutputsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddBridgeOutputs");
            AddBridgeOutputsResponse addBridgeOutputsResponse = (AddBridgeOutputsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddBridgeOutputs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addBridgeOutputsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddBridgeOutputsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addBridgeOutputsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$addBridgeOutputs$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddBridgeSourcesResponse addBridgeSources(AddBridgeSourcesRequest addBridgeSourcesRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddBridgeSourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addBridgeSourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, addBridgeSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddBridgeSources");
            AddBridgeSourcesResponse addBridgeSourcesResponse = (AddBridgeSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddBridgeSources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addBridgeSourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddBridgeSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addBridgeSourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$addBridgeSources$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddFlowMediaStreamsResponse addFlowMediaStreams(AddFlowMediaStreamsRequest addFlowMediaStreamsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddFlowMediaStreamsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addFlowMediaStreamsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, addFlowMediaStreamsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddFlowMediaStreams");
            AddFlowMediaStreamsResponse addFlowMediaStreamsResponse = (AddFlowMediaStreamsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddFlowMediaStreams").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addFlowMediaStreamsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddFlowMediaStreamsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addFlowMediaStreamsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$addFlowMediaStreams$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddFlowOutputsResponse addFlowOutputs(AddFlowOutputsRequest addFlowOutputsRequest) throws AddFlowOutputs420Exception, BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddFlowOutputsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addFlowOutputsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, addFlowOutputsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddFlowOutputs");
            AddFlowOutputsResponse addFlowOutputsResponse = (AddFlowOutputsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddFlowOutputs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addFlowOutputsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddFlowOutputsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addFlowOutputsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$addFlowOutputs$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddFlowSourcesResponse addFlowSources(AddFlowSourcesRequest addFlowSourcesRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddFlowSourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addFlowSourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, addFlowSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddFlowSources");
            AddFlowSourcesResponse addFlowSourcesResponse = (AddFlowSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddFlowSources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addFlowSourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddFlowSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addFlowSourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$addFlowSources$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddFlowVpcInterfacesResponse addFlowVpcInterfaces(AddFlowVpcInterfacesRequest addFlowVpcInterfacesRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddFlowVpcInterfacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addFlowVpcInterfacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, addFlowVpcInterfacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddFlowVpcInterfaces");
            AddFlowVpcInterfacesResponse addFlowVpcInterfacesResponse = (AddFlowVpcInterfacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddFlowVpcInterfaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addFlowVpcInterfacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddFlowVpcInterfacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addFlowVpcInterfacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$addFlowVpcInterfaces$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBridgeResponse createBridge(CreateBridgeRequest createBridgeRequest) throws CreateBridge420Exception, BadRequestException, InternalServerErrorException, ForbiddenException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBridgeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBridgeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, createBridgeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBridge");
            CreateBridgeResponse createBridgeResponse = (CreateBridgeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBridge").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBridgeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBridgeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBridgeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$createBridge$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFlowResponse createFlow(CreateFlowRequest createFlowRequest) throws CreateFlow420Exception, BadRequestException, InternalServerErrorException, ForbiddenException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFlowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, createFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFlow");
            CreateFlowResponse createFlowResponse = (CreateFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFlow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$createFlow$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGatewayResponse createGateway(CreateGatewayRequest createGatewayRequest) throws CreateGateway420Exception, BadRequestException, InternalServerErrorException, ForbiddenException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, createGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGateway");
            CreateGatewayResponse createGatewayResponse = (CreateGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$createGateway$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBridgeResponse deleteBridge(DeleteBridgeRequest deleteBridgeRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBridgeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBridgeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, deleteBridgeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBridge");
            DeleteBridgeResponse deleteBridgeResponse = (DeleteBridgeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBridge").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBridgeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBridgeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBridgeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$deleteBridge$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFlowResponse deleteFlow(DeleteFlowRequest deleteFlowRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFlowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, deleteFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFlow");
            DeleteFlowResponse deleteFlowResponse = (DeleteFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFlow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$deleteFlow$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGatewayResponse deleteGateway(DeleteGatewayRequest deleteGatewayRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, deleteGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGateway");
            DeleteGatewayResponse deleteGatewayResponse = (DeleteGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$deleteGateway$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterGatewayInstanceResponse deregisterGatewayInstance(DeregisterGatewayInstanceRequest deregisterGatewayInstanceRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterGatewayInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterGatewayInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, deregisterGatewayInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterGatewayInstance");
            DeregisterGatewayInstanceResponse deregisterGatewayInstanceResponse = (DeregisterGatewayInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterGatewayInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deregisterGatewayInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterGatewayInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterGatewayInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$deregisterGatewayInstance$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBridgeResponse describeBridge(DescribeBridgeRequest describeBridgeRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBridgeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeBridgeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, describeBridgeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBridge");
            DescribeBridgeResponse describeBridgeResponse = (DescribeBridgeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBridge").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeBridgeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBridgeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBridgeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$describeBridge$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFlowResponse describeFlow(DescribeFlowRequest describeFlowRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFlowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, describeFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFlow");
            DescribeFlowResponse describeFlowResponse = (DescribeFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFlow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$describeFlow$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGatewayResponse describeGateway(DescribeGatewayRequest describeGatewayRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, describeGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGateway");
            DescribeGatewayResponse describeGatewayResponse = (DescribeGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$describeGateway$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGatewayInstanceResponse describeGatewayInstance(DescribeGatewayInstanceRequest describeGatewayInstanceRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGatewayInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeGatewayInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, describeGatewayInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGatewayInstance");
            DescribeGatewayInstanceResponse describeGatewayInstanceResponse = (DescribeGatewayInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGatewayInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeGatewayInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGatewayInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGatewayInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$describeGatewayInstance$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOfferingResponse describeOffering(DescribeOfferingRequest describeOfferingRequest) throws NotFoundException, ServiceUnavailableException, TooManyRequestsException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOfferingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeOfferingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, describeOfferingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOffering");
            DescribeOfferingResponse describeOfferingResponse = (DescribeOfferingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOffering").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeOfferingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOfferingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOfferingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$describeOffering$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReservationResponse describeReservation(DescribeReservationRequest describeReservationRequest) throws NotFoundException, ServiceUnavailableException, TooManyRequestsException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReservationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReservationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, describeReservationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReservation");
            DescribeReservationResponse describeReservationResponse = (DescribeReservationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReservationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReservationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReservationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$describeReservation$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GrantFlowEntitlementsResponse grantFlowEntitlements(GrantFlowEntitlementsRequest grantFlowEntitlementsRequest) throws GrantFlowEntitlements420Exception, BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GrantFlowEntitlementsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)grantFlowEntitlementsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, grantFlowEntitlementsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GrantFlowEntitlements");
            GrantFlowEntitlementsResponse grantFlowEntitlementsResponse = (GrantFlowEntitlementsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GrantFlowEntitlements").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)grantFlowEntitlementsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GrantFlowEntitlementsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return grantFlowEntitlementsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$grantFlowEntitlements$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBridgesResponse listBridges(ListBridgesRequest listBridgesRequest) throws ServiceUnavailableException, TooManyRequestsException, BadRequestException, InternalServerErrorException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBridgesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBridgesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, listBridgesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBridges");
            ListBridgesResponse listBridgesResponse = (ListBridgesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBridges").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listBridgesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBridgesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBridgesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$listBridges$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEntitlementsResponse listEntitlements(ListEntitlementsRequest listEntitlementsRequest) throws ServiceUnavailableException, TooManyRequestsException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEntitlementsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEntitlementsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, listEntitlementsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEntitlements");
            ListEntitlementsResponse listEntitlementsResponse = (ListEntitlementsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEntitlements").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEntitlementsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEntitlementsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEntitlementsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$listEntitlements$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFlowsResponse listFlows(ListFlowsRequest listFlowsRequest) throws ServiceUnavailableException, TooManyRequestsException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFlowsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFlowsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, listFlowsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFlows");
            ListFlowsResponse listFlowsResponse = (ListFlowsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFlows").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listFlowsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFlowsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFlowsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$listFlows$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGatewayInstancesResponse listGatewayInstances(ListGatewayInstancesRequest listGatewayInstancesRequest) throws ServiceUnavailableException, TooManyRequestsException, BadRequestException, InternalServerErrorException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGatewayInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGatewayInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, listGatewayInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGatewayInstances");
            ListGatewayInstancesResponse listGatewayInstancesResponse = (ListGatewayInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGatewayInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listGatewayInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGatewayInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGatewayInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$listGatewayInstances$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGatewaysResponse listGateways(ListGatewaysRequest listGatewaysRequest) throws ServiceUnavailableException, TooManyRequestsException, BadRequestException, InternalServerErrorException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGatewaysResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGatewaysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, listGatewaysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGateways");
            ListGatewaysResponse listGatewaysResponse = (ListGatewaysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGateways").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listGatewaysRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGatewaysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGatewaysResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$listGateways$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOfferingsResponse listOfferings(ListOfferingsRequest listOfferingsRequest) throws ServiceUnavailableException, TooManyRequestsException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOfferingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listOfferingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, listOfferingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOfferings");
            ListOfferingsResponse listOfferingsResponse = (ListOfferingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOfferings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listOfferingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListOfferingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listOfferingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$listOfferings$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReservationsResponse listReservations(ListReservationsRequest listReservationsRequest) throws ServiceUnavailableException, TooManyRequestsException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReservationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listReservationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, listReservationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReservations");
            ListReservationsResponse listReservationsResponse = (ListReservationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReservations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listReservationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReservationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReservationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$listReservations$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$listTagsForResource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PurchaseOfferingResponse purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PurchaseOfferingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)purchaseOfferingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, purchaseOfferingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PurchaseOffering");
            PurchaseOfferingResponse purchaseOfferingResponse = (PurchaseOfferingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PurchaseOffering").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)purchaseOfferingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PurchaseOfferingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return purchaseOfferingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$purchaseOffering$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveBridgeOutputResponse removeBridgeOutput(RemoveBridgeOutputRequest removeBridgeOutputRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveBridgeOutputResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeBridgeOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, removeBridgeOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveBridgeOutput");
            RemoveBridgeOutputResponse removeBridgeOutputResponse = (RemoveBridgeOutputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveBridgeOutput").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeBridgeOutputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveBridgeOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeBridgeOutputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$removeBridgeOutput$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveBridgeSourceResponse removeBridgeSource(RemoveBridgeSourceRequest removeBridgeSourceRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveBridgeSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeBridgeSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, removeBridgeSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveBridgeSource");
            RemoveBridgeSourceResponse removeBridgeSourceResponse = (RemoveBridgeSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveBridgeSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeBridgeSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveBridgeSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeBridgeSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$removeBridgeSource$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveFlowMediaStreamResponse removeFlowMediaStream(RemoveFlowMediaStreamRequest removeFlowMediaStreamRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveFlowMediaStreamResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeFlowMediaStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, removeFlowMediaStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveFlowMediaStream");
            RemoveFlowMediaStreamResponse removeFlowMediaStreamResponse = (RemoveFlowMediaStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveFlowMediaStream").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeFlowMediaStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveFlowMediaStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeFlowMediaStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$removeFlowMediaStream$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveFlowOutputResponse removeFlowOutput(RemoveFlowOutputRequest removeFlowOutputRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveFlowOutputResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeFlowOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, removeFlowOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveFlowOutput");
            RemoveFlowOutputResponse removeFlowOutputResponse = (RemoveFlowOutputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveFlowOutput").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeFlowOutputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveFlowOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeFlowOutputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$removeFlowOutput$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveFlowSourceResponse removeFlowSource(RemoveFlowSourceRequest removeFlowSourceRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveFlowSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeFlowSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, removeFlowSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveFlowSource");
            RemoveFlowSourceResponse removeFlowSourceResponse = (RemoveFlowSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveFlowSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeFlowSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveFlowSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeFlowSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$removeFlowSource$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveFlowVpcInterfaceResponse removeFlowVpcInterface(RemoveFlowVpcInterfaceRequest removeFlowVpcInterfaceRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveFlowVpcInterfaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeFlowVpcInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, removeFlowVpcInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveFlowVpcInterface");
            RemoveFlowVpcInterfaceResponse removeFlowVpcInterfaceResponse = (RemoveFlowVpcInterfaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveFlowVpcInterface").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeFlowVpcInterfaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveFlowVpcInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeFlowVpcInterfaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$removeFlowVpcInterface$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevokeFlowEntitlementResponse revokeFlowEntitlement(RevokeFlowEntitlementRequest revokeFlowEntitlementRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokeFlowEntitlementResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)revokeFlowEntitlementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, revokeFlowEntitlementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeFlowEntitlement");
            RevokeFlowEntitlementResponse revokeFlowEntitlementResponse = (RevokeFlowEntitlementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeFlowEntitlement").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)revokeFlowEntitlementRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RevokeFlowEntitlementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return revokeFlowEntitlementResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$revokeFlowEntitlement$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartFlowResponse startFlow(StartFlowRequest startFlowRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartFlowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, startFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartFlow");
            StartFlowResponse startFlowResponse = (StartFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartFlow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$startFlow$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopFlowResponse stopFlow(StopFlowRequest stopFlowRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopFlowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, stopFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopFlow");
            StopFlowResponse stopFlowResponse = (StopFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopFlow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$stopFlow$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$tagResource$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$untagResource$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBridgeResponse updateBridge(UpdateBridgeRequest updateBridgeRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBridgeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBridgeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, updateBridgeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBridge");
            UpdateBridgeResponse updateBridgeResponse = (UpdateBridgeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBridge").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateBridgeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBridgeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBridgeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$updateBridge$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBridgeOutputResponse updateBridgeOutput(UpdateBridgeOutputRequest updateBridgeOutputRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBridgeOutputResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBridgeOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, updateBridgeOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBridgeOutput");
            UpdateBridgeOutputResponse updateBridgeOutputResponse = (UpdateBridgeOutputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBridgeOutput").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateBridgeOutputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBridgeOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBridgeOutputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$updateBridgeOutput$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBridgeSourceResponse updateBridgeSource(UpdateBridgeSourceRequest updateBridgeSourceRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBridgeSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBridgeSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, updateBridgeSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBridgeSource");
            UpdateBridgeSourceResponse updateBridgeSourceResponse = (UpdateBridgeSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBridgeSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateBridgeSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBridgeSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBridgeSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$updateBridgeSource$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBridgeStateResponse updateBridgeState(UpdateBridgeStateRequest updateBridgeStateRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBridgeStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBridgeStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, updateBridgeStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBridgeState");
            UpdateBridgeStateResponse updateBridgeStateResponse = (UpdateBridgeStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBridgeState").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateBridgeStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBridgeStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBridgeStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$updateBridgeState$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFlowResponse updateFlow(UpdateFlowRequest updateFlowRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, updateFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFlow");
            UpdateFlowResponse updateFlowResponse = (UpdateFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$updateFlow$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFlowEntitlementResponse updateFlowEntitlement(UpdateFlowEntitlementRequest updateFlowEntitlementRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlowEntitlementResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFlowEntitlementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, updateFlowEntitlementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFlowEntitlement");
            UpdateFlowEntitlementResponse updateFlowEntitlementResponse = (UpdateFlowEntitlementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlowEntitlement").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateFlowEntitlementRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFlowEntitlementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFlowEntitlementResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$updateFlowEntitlement$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFlowMediaStreamResponse updateFlowMediaStream(UpdateFlowMediaStreamRequest updateFlowMediaStreamRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlowMediaStreamResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFlowMediaStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, updateFlowMediaStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFlowMediaStream");
            UpdateFlowMediaStreamResponse updateFlowMediaStreamResponse = (UpdateFlowMediaStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlowMediaStream").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateFlowMediaStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFlowMediaStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFlowMediaStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$updateFlowMediaStream$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFlowOutputResponse updateFlowOutput(UpdateFlowOutputRequest updateFlowOutputRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlowOutputResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFlowOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, updateFlowOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFlowOutput");
            UpdateFlowOutputResponse updateFlowOutputResponse = (UpdateFlowOutputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlowOutput").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateFlowOutputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFlowOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFlowOutputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$updateFlowOutput$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFlowSourceResponse updateFlowSource(UpdateFlowSourceRequest updateFlowSourceRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlowSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFlowSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, updateFlowSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFlowSource");
            UpdateFlowSourceResponse updateFlowSourceResponse = (UpdateFlowSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlowSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateFlowSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFlowSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFlowSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$updateFlowSource$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGatewayInstanceResponse updateGatewayInstance(UpdateGatewayInstanceRequest updateGatewayInstanceRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGatewayInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateGatewayInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectClient.resolveMetricPublishers(clientConfiguration, updateGatewayInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGatewayInstance");
            UpdateGatewayInstanceResponse updateGatewayInstanceResponse = (UpdateGatewayInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGatewayInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateGatewayInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGatewayInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGatewayInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectClient.lambda$updateGatewayInstance$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public MediaConnectWaiter waiter() {
        return MediaConnectWaiter.builder().client(this).build();
    }

    public final String serviceName() {
        return "mediaconnect";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        MediaConnectServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = MediaConnectServiceClientConfigurationBuilder.builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(this.serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MediaConnectException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ForbiddenException").exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").exceptionBuilderSupplier(CreateFlow420Exception::builder).httpStatusCode(Integer.valueOf(420)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").exceptionBuilderSupplier(CreateBridge420Exception::builder).httpStatusCode(Integer.valueOf(420)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").exceptionBuilderSupplier(CreateGateway420Exception::builder).httpStatusCode(Integer.valueOf(420)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).httpStatusCode(Integer.valueOf(420)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).httpStatusCode(Integer.valueOf(420)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerErrorException").exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    @Override
    public final MediaConnectServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateGatewayInstance$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFlowSource$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFlowOutput$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFlowMediaStream$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFlowEntitlement$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFlow$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBridgeState$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBridgeSource$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBridgeOutput$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBridge$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopFlow$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startFlow$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokeFlowEntitlement$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeFlowVpcInterface$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeFlowSource$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeFlowOutput$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeFlowMediaStream$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeBridgeSource$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeBridgeOutput$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$purchaseOffering$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReservations$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOfferings$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGateways$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGatewayInstances$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFlows$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEntitlements$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBridges$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$grantFlowEntitlements$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReservation$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeOffering$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGatewayInstance$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGateway$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFlow$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBridge$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterGatewayInstance$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGateway$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFlow$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBridge$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGateway$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFlow$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBridge$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addFlowVpcInterfaces$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addFlowSources$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addFlowOutputs$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addFlowMediaStreams$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addBridgeSources$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addBridgeOutputs$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

