/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MediaStreamType {
    VIDEO("video"),
    AUDIO("audio"),
    ANCILLARY_DATA("ancillary-data"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MediaStreamType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MediaStreamType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MediaStreamType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MediaStreamType> knownValues() {
        return Stream.of(MediaStreamType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

