/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFailoverConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFlowRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, UpdateFlowRequest> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(UpdateFlowRequest.getter(UpdateFlowRequest::flowArn)).setter(UpdateFlowRequest.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()}).build();
    private static final SdkField<UpdateFailoverConfig> SOURCE_FAILOVER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceFailoverConfig").getter(UpdateFlowRequest.getter(UpdateFlowRequest::sourceFailoverConfig)).setter(UpdateFlowRequest.setter(Builder::sourceFailoverConfig)).constructor(UpdateFailoverConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFailoverConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, SOURCE_FAILOVER_CONFIG_FIELD));
    private final String flowArn;
    private final UpdateFailoverConfig sourceFailoverConfig;

    private UpdateFlowRequest(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.sourceFailoverConfig = builder.sourceFailoverConfig;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final UpdateFailoverConfig sourceFailoverConfig() {
        return this.sourceFailoverConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFailoverConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowRequest)) {
            return false;
        }
        UpdateFlowRequest other = (UpdateFlowRequest)((Object)obj);
        return Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.sourceFailoverConfig(), other.sourceFailoverConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFlowRequest").add("FlowArn", (Object)this.flowArn()).add("SourceFailoverConfig", (Object)this.sourceFailoverConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "SourceFailoverConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceFailoverConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowRequest, T> g) {
        return obj -> g.apply((UpdateFlowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private String flowArn;
        private UpdateFailoverConfig sourceFailoverConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowRequest model) {
            super(model);
            this.flowArn(model.flowArn);
            this.sourceFailoverConfig(model.sourceFailoverConfig);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        @Transient
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final UpdateFailoverConfig.Builder getSourceFailoverConfig() {
            return this.sourceFailoverConfig != null ? this.sourceFailoverConfig.toBuilder() : null;
        }

        public final void setSourceFailoverConfig(UpdateFailoverConfig.BuilderImpl sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig != null ? sourceFailoverConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceFailoverConfig(UpdateFailoverConfig sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowRequest build() {
            return new UpdateFlowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFlowRequest> {
        public Builder flowArn(String var1);

        public Builder sourceFailoverConfig(UpdateFailoverConfig var1);

        default public Builder sourceFailoverConfig(Consumer<UpdateFailoverConfig.Builder> sourceFailoverConfig) {
            return this.sourceFailoverConfig((UpdateFailoverConfig)((UpdateFailoverConfig.Builder)UpdateFailoverConfig.builder().applyMutation(sourceFailoverConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

