/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.FailoverMode;
import software.amazon.awssdk.services.mediaconnect.model.SourcePriority;
import software.amazon.awssdk.services.mediaconnect.model.State;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFailoverConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateFailoverConfig> {
    private static final SdkField<String> FAILOVER_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailoverMode").getter(UpdateFailoverConfig.getter(UpdateFailoverConfig::failoverModeAsString)).setter(UpdateFailoverConfig.setter(Builder::failoverMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failoverMode").build()}).build();
    private static final SdkField<Integer> RECOVERY_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RecoveryWindow").getter(UpdateFailoverConfig.getter(UpdateFailoverConfig::recoveryWindow)).setter(UpdateFailoverConfig.setter(Builder::recoveryWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryWindow").build()}).build();
    private static final SdkField<SourcePriority> SOURCE_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourcePriority").getter(UpdateFailoverConfig.getter(UpdateFailoverConfig::sourcePriority)).setter(UpdateFailoverConfig.setter(Builder::sourcePriority)).constructor(SourcePriority::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePriority").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(UpdateFailoverConfig.getter(UpdateFailoverConfig::stateAsString)).setter(UpdateFailoverConfig.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILOVER_MODE_FIELD, RECOVERY_WINDOW_FIELD, SOURCE_PRIORITY_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String failoverMode;
    private final Integer recoveryWindow;
    private final SourcePriority sourcePriority;
    private final String state;

    private UpdateFailoverConfig(BuilderImpl builder) {
        this.failoverMode = builder.failoverMode;
        this.recoveryWindow = builder.recoveryWindow;
        this.sourcePriority = builder.sourcePriority;
        this.state = builder.state;
    }

    public final FailoverMode failoverMode() {
        return FailoverMode.fromValue(this.failoverMode);
    }

    public final String failoverModeAsString() {
        return this.failoverMode;
    }

    public final Integer recoveryWindow() {
        return this.recoveryWindow;
    }

    public final SourcePriority sourcePriority() {
        return this.sourcePriority;
    }

    public final State state() {
        return State.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failoverModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePriority());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFailoverConfig)) {
            return false;
        }
        UpdateFailoverConfig other = (UpdateFailoverConfig)obj;
        return Objects.equals(this.failoverModeAsString(), other.failoverModeAsString()) && Objects.equals(this.recoveryWindow(), other.recoveryWindow()) && Objects.equals(this.sourcePriority(), other.sourcePriority()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFailoverConfig").add("FailoverMode", (Object)this.failoverModeAsString()).add("RecoveryWindow", (Object)this.recoveryWindow()).add("SourcePriority", (Object)this.sourcePriority()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailoverMode": {
                return Optional.ofNullable(clazz.cast(this.failoverModeAsString()));
            }
            case "RecoveryWindow": {
                return Optional.ofNullable(clazz.cast(this.recoveryWindow()));
            }
            case "SourcePriority": {
                return Optional.ofNullable(clazz.cast(this.sourcePriority()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFailoverConfig, T> g) {
        return obj -> g.apply((UpdateFailoverConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String failoverMode;
        private Integer recoveryWindow;
        private SourcePriority sourcePriority;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFailoverConfig model) {
            this.failoverMode(model.failoverMode);
            this.recoveryWindow(model.recoveryWindow);
            this.sourcePriority(model.sourcePriority);
            this.state(model.state);
        }

        public final String getFailoverMode() {
            return this.failoverMode;
        }

        @Override
        public final Builder failoverMode(String failoverMode) {
            this.failoverMode = failoverMode;
            return this;
        }

        @Override
        public final Builder failoverMode(FailoverMode failoverMode) {
            this.failoverMode(failoverMode == null ? null : failoverMode.toString());
            return this;
        }

        public final void setFailoverMode(String failoverMode) {
            this.failoverMode = failoverMode;
        }

        public final Integer getRecoveryWindow() {
            return this.recoveryWindow;
        }

        @Override
        public final Builder recoveryWindow(Integer recoveryWindow) {
            this.recoveryWindow = recoveryWindow;
            return this;
        }

        public final void setRecoveryWindow(Integer recoveryWindow) {
            this.recoveryWindow = recoveryWindow;
        }

        public final SourcePriority.Builder getSourcePriority() {
            return this.sourcePriority != null ? this.sourcePriority.toBuilder() : null;
        }

        @Override
        public final Builder sourcePriority(SourcePriority sourcePriority) {
            this.sourcePriority = sourcePriority;
            return this;
        }

        public final void setSourcePriority(SourcePriority.BuilderImpl sourcePriority) {
            this.sourcePriority = sourcePriority != null ? sourcePriority.build() : null;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public UpdateFailoverConfig build() {
            return new UpdateFailoverConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateFailoverConfig> {
        public Builder failoverMode(String var1);

        public Builder failoverMode(FailoverMode var1);

        public Builder recoveryWindow(Integer var1);

        public Builder sourcePriority(SourcePriority var1);

        default public Builder sourcePriority(Consumer<SourcePriority.Builder> sourcePriority) {
            return this.sourcePriority((SourcePriority)((SourcePriority.Builder)SourcePriority.builder().applyMutation(sourcePriority)).build());
        }

        public Builder state(String var1);

        public Builder state(State var1);
    }
}

