/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacereporting.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacereporting.model.EmbeddingDomainsCopier;
import software.amazon.awssdk.services.marketplacereporting.model.MarketplaceReportingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBuyerDashboardRequest
extends MarketplaceReportingRequest
implements ToCopyableBuilder<Builder, GetBuyerDashboardRequest> {
    private static final SdkField<String> DASHBOARD_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dashboardIdentifier").getter(GetBuyerDashboardRequest.getter(GetBuyerDashboardRequest::dashboardIdentifier)).setter(GetBuyerDashboardRequest.setter(Builder::dashboardIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardIdentifier").build()}).build();
    private static final SdkField<List<String>> EMBEDDING_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("embeddingDomains").getter(GetBuyerDashboardRequest.getter(GetBuyerDashboardRequest::embeddingDomains)).setter(GetBuyerDashboardRequest.setter(Builder::embeddingDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddingDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_IDENTIFIER_FIELD, EMBEDDING_DOMAINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBuyerDashboardRequest.memberNameToFieldInitializer();
    private final String dashboardIdentifier;
    private final List<String> embeddingDomains;

    private GetBuyerDashboardRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardIdentifier = builder.dashboardIdentifier;
        this.embeddingDomains = builder.embeddingDomains;
    }

    public final String dashboardIdentifier() {
        return this.dashboardIdentifier;
    }

    public final boolean hasEmbeddingDomains() {
        return this.embeddingDomains != null && !(this.embeddingDomains instanceof SdkAutoConstructList);
    }

    public final List<String> embeddingDomains() {
        return this.embeddingDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmbeddingDomains() ? this.embeddingDomains() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuyerDashboardRequest)) {
            return false;
        }
        GetBuyerDashboardRequest other = (GetBuyerDashboardRequest)((Object)obj);
        return Objects.equals(this.dashboardIdentifier(), other.dashboardIdentifier()) && this.hasEmbeddingDomains() == other.hasEmbeddingDomains() && Objects.equals(this.embeddingDomains(), other.embeddingDomains());
    }

    public final String toString() {
        return ToString.builder((String)"GetBuyerDashboardRequest").add("DashboardIdentifier", (Object)this.dashboardIdentifier()).add("EmbeddingDomains", this.hasEmbeddingDomains() ? this.embeddingDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dashboardIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dashboardIdentifier()));
            }
            case "embeddingDomains": {
                return Optional.ofNullable(clazz.cast(this.embeddingDomains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dashboardIdentifier", DASHBOARD_IDENTIFIER_FIELD);
        map.put("embeddingDomains", EMBEDDING_DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBuyerDashboardRequest, T> g) {
        return obj -> g.apply((GetBuyerDashboardRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceReportingRequest.BuilderImpl
    implements Builder {
        private String dashboardIdentifier;
        private List<String> embeddingDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuyerDashboardRequest model) {
            super(model);
            this.dashboardIdentifier(model.dashboardIdentifier);
            this.embeddingDomains(model.embeddingDomains);
        }

        public final String getDashboardIdentifier() {
            return this.dashboardIdentifier;
        }

        public final void setDashboardIdentifier(String dashboardIdentifier) {
            this.dashboardIdentifier = dashboardIdentifier;
        }

        @Override
        public final Builder dashboardIdentifier(String dashboardIdentifier) {
            this.dashboardIdentifier = dashboardIdentifier;
            return this;
        }

        public final Collection<String> getEmbeddingDomains() {
            if (this.embeddingDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.embeddingDomains;
        }

        public final void setEmbeddingDomains(Collection<String> embeddingDomains) {
            this.embeddingDomains = EmbeddingDomainsCopier.copy(embeddingDomains);
        }

        @Override
        public final Builder embeddingDomains(Collection<String> embeddingDomains) {
            this.embeddingDomains = EmbeddingDomainsCopier.copy(embeddingDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder embeddingDomains(String ... embeddingDomains) {
            this.embeddingDomains(Arrays.asList(embeddingDomains));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBuyerDashboardRequest build() {
            return new GetBuyerDashboardRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MarketplaceReportingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBuyerDashboardRequest> {
        public Builder dashboardIdentifier(String var1);

        public Builder embeddingDomains(Collection<String> var1);

        public Builder embeddingDomains(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

