/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacedeployment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.marketplacedeployment.model.DeploymentParameterInput;
import software.amazon.awssdk.services.marketplacedeployment.model.MarketplaceDeploymentRequest;
import software.amazon.awssdk.services.marketplacedeployment.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDeploymentParameterRequest
extends MarketplaceDeploymentRequest
implements ToCopyableBuilder<Builder, PutDeploymentParameterRequest> {
    private static final SdkField<String> AGREEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agreementId").getter(PutDeploymentParameterRequest.getter(PutDeploymentParameterRequest::agreementId)).setter(PutDeploymentParameterRequest.setter(Builder::agreementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementId").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("catalog").getter(PutDeploymentParameterRequest.getter(PutDeploymentParameterRequest::catalog)).setter(PutDeploymentParameterRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("catalog").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(PutDeploymentParameterRequest.getter(PutDeploymentParameterRequest::clientToken)).setter(PutDeploymentParameterRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<DeploymentParameterInput> DEPLOYMENT_PARAMETER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentParameter").getter(PutDeploymentParameterRequest.getter(PutDeploymentParameterRequest::deploymentParameter)).setter(PutDeploymentParameterRequest.setter(Builder::deploymentParameter)).constructor(DeploymentParameterInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentParameter").build()}).build();
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expirationDate").getter(PutDeploymentParameterRequest.getter(PutDeploymentParameterRequest::expirationDate)).setter(PutDeploymentParameterRequest.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("productId").getter(PutDeploymentParameterRequest.getter(PutDeploymentParameterRequest::productId)).setter(PutDeploymentParameterRequest.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("productId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(PutDeploymentParameterRequest.getter(PutDeploymentParameterRequest::tags)).setter(PutDeploymentParameterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGREEMENT_ID_FIELD, CATALOG_FIELD, CLIENT_TOKEN_FIELD, DEPLOYMENT_PARAMETER_FIELD, EXPIRATION_DATE_FIELD, PRODUCT_ID_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutDeploymentParameterRequest.memberNameToFieldInitializer();
    private final String agreementId;
    private final String catalog;
    private final String clientToken;
    private final DeploymentParameterInput deploymentParameter;
    private final Instant expirationDate;
    private final String productId;
    private final Map<String, String> tags;

    private PutDeploymentParameterRequest(BuilderImpl builder) {
        super(builder);
        this.agreementId = builder.agreementId;
        this.catalog = builder.catalog;
        this.clientToken = builder.clientToken;
        this.deploymentParameter = builder.deploymentParameter;
        this.expirationDate = builder.expirationDate;
        this.productId = builder.productId;
        this.tags = builder.tags;
    }

    public final String agreementId() {
        return this.agreementId;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final DeploymentParameterInput deploymentParameter() {
        return this.deploymentParameter;
    }

    public final Instant expirationDate() {
        return this.expirationDate;
    }

    public final String productId() {
        return this.productId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agreementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentParameter());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDeploymentParameterRequest)) {
            return false;
        }
        PutDeploymentParameterRequest other = (PutDeploymentParameterRequest)((Object)obj);
        return Objects.equals(this.agreementId(), other.agreementId()) && Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.deploymentParameter(), other.deploymentParameter()) && Objects.equals(this.expirationDate(), other.expirationDate()) && Objects.equals(this.productId(), other.productId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"PutDeploymentParameterRequest").add("AgreementId", (Object)this.agreementId()).add("Catalog", (Object)this.catalog()).add("ClientToken", (Object)this.clientToken()).add("DeploymentParameter", (Object)this.deploymentParameter()).add("ExpirationDate", (Object)this.expirationDate()).add("ProductId", (Object)this.productId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agreementId": {
                return Optional.ofNullable(clazz.cast(this.agreementId()));
            }
            case "catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "deploymentParameter": {
                return Optional.ofNullable(clazz.cast(this.deploymentParameter()));
            }
            case "expirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
            case "productId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agreementId", AGREEMENT_ID_FIELD);
        map.put("catalog", CATALOG_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("deploymentParameter", DEPLOYMENT_PARAMETER_FIELD);
        map.put("expirationDate", EXPIRATION_DATE_FIELD);
        map.put("productId", PRODUCT_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDeploymentParameterRequest, T> g) {
        return obj -> g.apply((PutDeploymentParameterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceDeploymentRequest.BuilderImpl
    implements Builder {
        private String agreementId;
        private String catalog;
        private String clientToken;
        private DeploymentParameterInput deploymentParameter;
        private Instant expirationDate;
        private String productId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutDeploymentParameterRequest model) {
            super(model);
            this.agreementId(model.agreementId);
            this.catalog(model.catalog);
            this.clientToken(model.clientToken);
            this.deploymentParameter(model.deploymentParameter);
            this.expirationDate(model.expirationDate);
            this.productId(model.productId);
            this.tags(model.tags);
        }

        public final String getAgreementId() {
            return this.agreementId;
        }

        public final void setAgreementId(String agreementId) {
            this.agreementId = agreementId;
        }

        @Override
        public final Builder agreementId(String agreementId) {
            this.agreementId = agreementId;
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DeploymentParameterInput.Builder getDeploymentParameter() {
            return this.deploymentParameter != null ? this.deploymentParameter.toBuilder() : null;
        }

        public final void setDeploymentParameter(DeploymentParameterInput.BuilderImpl deploymentParameter) {
            this.deploymentParameter = deploymentParameter != null ? deploymentParameter.build() : null;
        }

        @Override
        public final Builder deploymentParameter(DeploymentParameterInput deploymentParameter) {
            this.deploymentParameter = deploymentParameter;
            return this;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final String getProductId() {
            return this.productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDeploymentParameterRequest build() {
            return new PutDeploymentParameterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MarketplaceDeploymentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDeploymentParameterRequest> {
        public Builder agreementId(String var1);

        public Builder catalog(String var1);

        public Builder clientToken(String var1);

        public Builder deploymentParameter(DeploymentParameterInput var1);

        default public Builder deploymentParameter(Consumer<DeploymentParameterInput.Builder> deploymentParameter) {
            return this.deploymentParameter((DeploymentParameterInput)((DeploymentParameterInput.Builder)DeploymentParameterInput.builder().applyMutation(deploymentParameter)).build());
        }

        public Builder expirationDate(Instant var1);

        public Builder productId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

