/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacedeployment.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.marketplacedeployment.model.MarketplaceDeploymentResponse;
import software.amazon.awssdk.services.marketplacedeployment.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDeploymentParameterResponse
extends MarketplaceDeploymentResponse
implements ToCopyableBuilder<Builder, PutDeploymentParameterResponse> {
    private static final SdkField<String> AGREEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agreementId").getter(PutDeploymentParameterResponse.getter(PutDeploymentParameterResponse::agreementId)).setter(PutDeploymentParameterResponse.setter(Builder::agreementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementId").build()}).build();
    private static final SdkField<String> DEPLOYMENT_PARAMETER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentParameterId").getter(PutDeploymentParameterResponse.getter(PutDeploymentParameterResponse::deploymentParameterId)).setter(PutDeploymentParameterResponse.setter(Builder::deploymentParameterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentParameterId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(PutDeploymentParameterResponse.getter(PutDeploymentParameterResponse::resourceArn)).setter(PutDeploymentParameterResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(PutDeploymentParameterResponse.getter(PutDeploymentParameterResponse::tags)).setter(PutDeploymentParameterResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGREEMENT_ID_FIELD, DEPLOYMENT_PARAMETER_ID_FIELD, RESOURCE_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("agreementId", AGREEMENT_ID_FIELD);
            this.put("deploymentParameterId", DEPLOYMENT_PARAMETER_ID_FIELD);
            this.put("resourceArn", RESOURCE_ARN_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String agreementId;
    private final String deploymentParameterId;
    private final String resourceArn;
    private final Map<String, String> tags;

    private PutDeploymentParameterResponse(BuilderImpl builder) {
        super(builder);
        this.agreementId = builder.agreementId;
        this.deploymentParameterId = builder.deploymentParameterId;
        this.resourceArn = builder.resourceArn;
        this.tags = builder.tags;
    }

    public final String agreementId() {
        return this.agreementId;
    }

    public final String deploymentParameterId() {
        return this.deploymentParameterId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agreementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentParameterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDeploymentParameterResponse)) {
            return false;
        }
        PutDeploymentParameterResponse other = (PutDeploymentParameterResponse)((Object)obj);
        return Objects.equals(this.agreementId(), other.agreementId()) && Objects.equals(this.deploymentParameterId(), other.deploymentParameterId()) && Objects.equals(this.resourceArn(), other.resourceArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"PutDeploymentParameterResponse").add("AgreementId", (Object)this.agreementId()).add("DeploymentParameterId", (Object)this.deploymentParameterId()).add("ResourceArn", (Object)this.resourceArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agreementId": {
                return Optional.ofNullable(clazz.cast(this.agreementId()));
            }
            case "deploymentParameterId": {
                return Optional.ofNullable(clazz.cast(this.deploymentParameterId()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutDeploymentParameterResponse, T> g) {
        return obj -> g.apply((PutDeploymentParameterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceDeploymentResponse.BuilderImpl
    implements Builder {
        private String agreementId;
        private String deploymentParameterId;
        private String resourceArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutDeploymentParameterResponse model) {
            super(model);
            this.agreementId(model.agreementId);
            this.deploymentParameterId(model.deploymentParameterId);
            this.resourceArn(model.resourceArn);
            this.tags(model.tags);
        }

        public final String getAgreementId() {
            return this.agreementId;
        }

        public final void setAgreementId(String agreementId) {
            this.agreementId = agreementId;
        }

        @Override
        public final Builder agreementId(String agreementId) {
            this.agreementId = agreementId;
            return this;
        }

        public final String getDeploymentParameterId() {
            return this.deploymentParameterId;
        }

        public final void setDeploymentParameterId(String deploymentParameterId) {
            this.deploymentParameterId = deploymentParameterId;
        }

        @Override
        public final Builder deploymentParameterId(String deploymentParameterId) {
            this.deploymentParameterId = deploymentParameterId;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public PutDeploymentParameterResponse build() {
            return new PutDeploymentParameterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MarketplaceDeploymentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDeploymentParameterResponse> {
        public Builder agreementId(String var1);

        public Builder deploymentParameterId(String var1);

        public Builder resourceArn(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

