/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeEthereumAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeEthereumAttributes> {
    private static final SdkField<String> HTTP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpEndpoint").getter(NodeEthereumAttributes.getter(NodeEthereumAttributes::httpEndpoint)).setter(NodeEthereumAttributes.setter(Builder::httpEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpoint").build()}).build();
    private static final SdkField<String> WEB_SOCKET_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebSocketEndpoint").getter(NodeEthereumAttributes.getter(NodeEthereumAttributes::webSocketEndpoint)).setter(NodeEthereumAttributes.setter(Builder::webSocketEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebSocketEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_ENDPOINT_FIELD, WEB_SOCKET_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodeEthereumAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String httpEndpoint;
    private final String webSocketEndpoint;

    private NodeEthereumAttributes(BuilderImpl builder) {
        this.httpEndpoint = builder.httpEndpoint;
        this.webSocketEndpoint = builder.webSocketEndpoint;
    }

    public final String httpEndpoint() {
        return this.httpEndpoint;
    }

    public final String webSocketEndpoint() {
        return this.webSocketEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.webSocketEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeEthereumAttributes)) {
            return false;
        }
        NodeEthereumAttributes other = (NodeEthereumAttributes)obj;
        return Objects.equals(this.httpEndpoint(), other.httpEndpoint()) && Objects.equals(this.webSocketEndpoint(), other.webSocketEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"NodeEthereumAttributes").add("HttpEndpoint", (Object)this.httpEndpoint()).add("WebSocketEndpoint", (Object)this.webSocketEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HttpEndpoint": {
                return Optional.ofNullable(clazz.cast(this.httpEndpoint()));
            }
            case "WebSocketEndpoint": {
                return Optional.ofNullable(clazz.cast(this.webSocketEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("HttpEndpoint", HTTP_ENDPOINT_FIELD);
        map.put("WebSocketEndpoint", WEB_SOCKET_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeEthereumAttributes, T> g) {
        return obj -> g.apply((NodeEthereumAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String httpEndpoint;
        private String webSocketEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeEthereumAttributes model) {
            this.httpEndpoint(model.httpEndpoint);
            this.webSocketEndpoint(model.webSocketEndpoint);
        }

        public final String getHttpEndpoint() {
            return this.httpEndpoint;
        }

        public final void setHttpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
        }

        @Override
        public final Builder httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        public final String getWebSocketEndpoint() {
            return this.webSocketEndpoint;
        }

        public final void setWebSocketEndpoint(String webSocketEndpoint) {
            this.webSocketEndpoint = webSocketEndpoint;
        }

        @Override
        public final Builder webSocketEndpoint(String webSocketEndpoint) {
            this.webSocketEndpoint = webSocketEndpoint;
            return this;
        }

        public NodeEthereumAttributes build() {
            return new NodeEthereumAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeEthereumAttributes> {
        public Builder httpEndpoint(String var1);

        public Builder webSocketEndpoint(String var1);
    }
}

