/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainAsyncClient;
import software.amazon.awssdk.services.managedblockchain.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesResponse;

public class ListProposalVotesPublisher
implements SdkPublisher<ListProposalVotesResponse> {
    private final ManagedBlockchainAsyncClient client;
    private final ListProposalVotesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProposalVotesPublisher(ManagedBlockchainAsyncClient client, ListProposalVotesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProposalVotesPublisher(ManagedBlockchainAsyncClient client, ListProposalVotesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProposalVotesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProposalVotesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListProposalVotesResponseFetcher
    implements AsyncPageFetcher<ListProposalVotesResponse> {
        private ListProposalVotesResponseFetcher() {
        }

        public boolean hasNextPage(ListProposalVotesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProposalVotesResponse> nextPage(ListProposalVotesResponse previousPage) {
            if (previousPage == null) {
                return ListProposalVotesPublisher.this.client.listProposalVotes(ListProposalVotesPublisher.this.firstRequest);
            }
            return ListProposalVotesPublisher.this.client.listProposalVotes((ListProposalVotesRequest)((Object)ListProposalVotesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

